/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.temporalcouplingview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingModel;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.ui.standalone.temporalcouplingview.TemporalCouplingLinkAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class TemporalCouplingView
extends WorkbenchView
implements IContextWorkbenchView {
    private PropertyTableViewer<TemporalCouplingLink> m_tcTableViewer;
    private final TemporalCouplingLinkAdapter m_tcBeanAdapter = new TemporalCouplingLinkAdapter();
    private final SelectionListener m_listener = new SelectionListener();
    private TemporalCouplingModel m_currentModel = null;
    private SourceFile m_currentSourceFile = null;
    private List<TemporalCouplingLink> m_currentLinks = Collections.emptyList();

    public IViewId getViewId() {
        return ViewId.TEMPORAL_COUPLING_VIEW;
    }

    public List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_tcTableViewer.getTable());
    }

    public boolean supportsCopy() {
        return this.m_tcTableViewer.hasCopyToClipBoardData();
    }

    public String copy() {
        return this.m_tcTableViewer.getCopyToClipboardData();
    }

    private synchronized void handleElementSelectionChanged(List<Element> elements) {
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'handleSelectionChanged' must not be null";
        Element element2 = element = !elements.isEmpty() ? elements.get(0) : null;
        if (element instanceof SourceFile && element.isValid()) {
            this.m_currentSourceFile = (SourceFile)element;
            this.setFromFile(this.m_currentSourceFile);
            if (this.m_currentModel != null) {
                this.show();
            }
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        AnalyzerResult scmResult;
        this.m_tcTableViewer = new PropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)this.m_tcBeanAdapter, "weight", false, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_tcTableViewer.addColumn("Path", "path", "path", "pathImage", 300, PropertyTableViewer.ColumnType.TEXT);
        TableViewerColumn col = this.m_tcTableViewer.addColumn("Weight", "weight", "weight", null, 50, PropertyTableViewer.ColumnType.NUMBER);
        this.m_tcTableViewer.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this.m_listener);
        col.getColumn().setToolTipText("The numbers in this columns represent the number of shared committs with the source file displayed in the tab title within the last 5 years.");
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzerResult analyzerResult;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (event.getProvider() == TemporalCouplingView.this.getSoftwareSystemProvider() && (analyzerResult = event.getResult()).getId() == CoreAnalyzerId.SCM_METRICS) {
                    TemporalCouplingView.this.setCurrentModel((TemporalCouplingModel)analyzerResult.getFirstChild(TemporalCouplingModel.class));
                    if (TemporalCouplingView.this.isActive() && TemporalCouplingView.this.m_currentSourceFile != null) {
                        TemporalCouplingView.this.show();
                    }
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (event.getProvider() == TemporalCouplingView.this.getSoftwareSystemProvider() && event.contains((IAnalyzerId)CoreAnalyzerId.SCM_METRICS)) {
                    TemporalCouplingView.this.setCurrentModel(null);
                    if (TemporalCouplingView.this.isActive()) {
                        TemporalCouplingView.this.reset();
                    }
                }
            }
        });
        if (this.getSoftwareSystem() != null && (scmResult = ((IAnalyzerProvider)this.getSoftwareSystem().getExtension(IAnalyzerProvider.class)).getAnalyzerResult((IAnalyzerId)CoreAnalyzerId.SCM_METRICS, false)) != null) {
            this.setCurrentModel((TemporalCouplingModel)scmResult.getFirstChild(TemporalCouplingModel.class));
        }
    }

    private synchronized void setCurrentModel(TemporalCouplingModel model) {
        this.m_currentModel = model;
    }

    private synchronized TemporalCouplingModel getCurrentModel() {
        return this.m_currentModel;
    }

    private List<Element> getElementsFromSelection() {
        if (this.m_tcTableViewer == null || this.m_tcTableViewer.isDisposed()) {
            return Collections.emptyList();
        }
        IStructuredSelection selection = this.m_tcTableViewer.getSelection();
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> elements = new ArrayList<Element>(selection.size());
        for (Object next : selection.toList()) {
            assert (next instanceof TemporalCouplingLink) : "Unexpected class in method \u2018getElementsFromSelection\u2019: " + String.valueOf(next);
            elements.add((Element)((TemporalCouplingLink)next).getSource());
        }
        return elements;
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    private synchronized void show() {
        TemporalCouplingModel model = this.getCurrentModel();
        if (model == null || this.m_currentSourceFile == null) {
            return;
        }
        this.m_currentLinks = model.getTemporalCouplingFor(this.m_currentSourceFile);
        this.setFromFile(this.m_currentSourceFile);
        this.m_tcTableViewer.showData(this.m_currentLinks);
    }

    private void setFromFile(SourceFile sourceFile) {
        this.resetPartName();
        this.setTitleTooltip("");
        if (sourceFile != null) {
            this.setTitleTooltip(sourceFile.getIdentifyingPath());
            WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.getPart().getLabel() + ": " + sourceFile.getShortName());
        }
    }

    private synchronized void reset() {
        this.setFromFile(null);
        this.m_currentLinks = Collections.emptyList();
        this.m_tcTableViewer.showData(null);
    }

    protected boolean supportsSleep() {
        return false;
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.handleElementSelectionChanged(this.getSelectionProviderAdapter().getCurrentSelection());
        super.softwareSystemShow(mode);
    }

    protected void performViewSelectionChanged(IWorkbenchView view, List<Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'selectionChanged' must not be null";
        this.handleElementSelectionChanged(elements);
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && !this.m_currentLinks.isEmpty();
    }

    public synchronized List<ExportData> getExportData(IWorkerContext workerContext) {
        if (!this.m_currentLinks.isEmpty() && this.m_currentSourceFile != null) {
            return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getTemporalCouplingLinks(this.m_currentSourceFile, this.m_currentLinks);
        }
        return Collections.emptyList();
    }

    public List<Element> getSelectedElements() {
        return this.getElementsFromSelection();
    }

    public synchronized void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        this.m_currentSourceFile = (SourceFile)elements.get(0);
        if (this.m_currentModel != null) {
            this.show();
        }
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private SelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TemporalCouplingView.this.getSelectionProviderAdapter().handleSelectionChanged(TemporalCouplingView.this.getElementsFromSelection());
        }
    }
}

