/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sourceview;

import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import java.util.EnumSet;

public abstract class SingleSourceView
extends WorkbenchSlaveView {
    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected final boolean supportsSleep() {
        return false;
    }

    protected abstract SourceViewWidget getSourceViewWidget();

    protected final void processIssues(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'processIssues' must not be null";
        SourceViewWidget sourceViewWidget = this.getSourceViewWidget();
        assert (sourceViewWidget != null) : "Parameter 'sourceViewWidget' of method 'processIssues' must not be null";
        sourceViewWidget.setRedraw(false);
        sourceViewWidget.clearMarkers();
        for (Issue nextIssue : this.getContext().collectIssues((ElementWithIssues)element, true)) {
            String prefix;
            String imageResourceName = nextIssue.getImageResourceName() + "Annotation";
            Object issueName = nextIssue.getPresentationName(false);
            IResolution resolution = nextIssue.getResolution();
            if (resolution != null && !(prefix = resolution.getIssuePrefix()).isEmpty()) {
                issueName = prefix + ": " + (String)issueName;
            }
            sourceViewWidget.addMarker(nextIssue.getLineNumber(), nextIssue.getProvider().getPresentationName(), (String)issueName, nextIssue.getDescription(), imageResourceName);
        }
        sourceViewWidget.setRedraw(true);
    }
}

