/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.enterprise.IConnectionValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.HttpConnectionCheckComposite;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class SonargraphEnterpriseConnectionWidget
extends Composite {
    private SonargraphEnterpriseConnection m_initialConnection;
    private String m_serverUrl;
    private String m_serverPort;
    private String m_clientKey;
    private boolean m_useProxy;
    private ValidatingTextWidget m_serverUrlText;
    private ValidatingTextWidget m_portText;
    private ValidatingTextWidget m_clientKeyText;
    private Button m_useProxyCheck;
    private HttpConnectionCheckComposite m_httpCheck;
    private IConnectionValidator m_connectionValidator;

    public SonargraphEnterpriseConnectionWidget(Composite parent, final IConnectionValidator connectionValidator, final ICallback callback) {
        super(parent, 0);
        assert (connectionValidator != null) : "Parameter 'connectionValidator' of method 'SonargraphEnterpriseConnectionWidget' must not be null";
        assert (callback != null) : "Parameter 'callback' of method 'SonargraphEnterpriseConnectionWidget' must not be null";
        this.m_connectionValidator = connectionValidator;
        this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Label urlLabel = new Label((Composite)this, 131072);
        urlLabel.setText("URL: ");
        this.m_serverUrlText = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult validationResult = connectionValidator.validateServer(newInput, !StringUtility.areEqual((String)currentInput, (String)newInput));
                return validationResult;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                SonargraphEnterpriseConnectionWidget.this.m_serverUrl = input != null ? input.trim() : "";
                callback.hasChanged(SonargraphEnterpriseConnectionWidget.this.isValid(), SonargraphEnterpriseConnectionWidget.this.isModified());
            }
        });
        this.m_serverUrlText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label portLabel = new Label((Composite)this, 131072);
        portLabel.setText("Port: ");
        this.m_portText = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = connectionValidator.validatePort(newInput, !StringUtility.areEqual((String)currentInput, (String)newInput));
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                SonargraphEnterpriseConnectionWidget.this.m_serverPort = text != null ? text.trim() : "";
                callback.hasChanged(SonargraphEnterpriseConnectionWidget.this.isValid(), SonargraphEnterpriseConnectionWidget.this.isModified());
            }
        });
        this.m_portText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label clientKeyLabel = new Label((Composite)this, 131072);
        clientKeyLabel.setText("Client Key: ");
        this.m_clientKeyText = new ValidatingTextWidget((Composite)this, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                return connectionValidator.validateClientKey(newInput, !StringUtility.areEqual((String)currentInput, (String)newInput));
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                SonargraphEnterpriseConnectionWidget.this.m_clientKey = input != null ? input.trim() : "";
                callback.hasChanged(SonargraphEnterpriseConnectionWidget.this.isValid(), SonargraphEnterpriseConnectionWidget.this.isModified());
            }
        });
        this.m_clientKeyText.setLayoutData((Object)new GridData(4, 4, true, false));
        SwtUtility.createFillerForGridLayoutCell((Composite)this);
        this.m_useProxyCheck = new Button((Composite)this, 32);
        this.m_useProxyCheck.setText("Use Proxy");
        this.m_useProxyCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SonargraphEnterpriseConnectionWidget.this.m_useProxy = SonargraphEnterpriseConnectionWidget.this.m_useProxyCheck.getSelection();
                callback.hasChanged(SonargraphEnterpriseConnectionWidget.this.isValid(), SonargraphEnterpriseConnectionWidget.this.isModified());
            }
        });
        this.m_useProxyCheck.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_httpCheck = new HttpConnectionCheckComposite(this, new HttpConnectionCheckComposite.IInfoProvider(){

            @Override
            public List<String> getUrls() {
                return Arrays.asList(SonargraphEnterpriseConnectionWidget.this.getSonargraphConnection().getConnectionCheckUrl());
            }

            @Override
            public String getExpectedResonse() {
                return "OK\n";
            }

            @Override
            public ProxySettings getProxy() {
                if (SonargraphEnterpriseConnectionWidget.this.m_useProxy) {
                    return SonargraphEnterpriseConnectionWidget.this.getProxySettings();
                }
                return null;
            }

            @Override
            public boolean isActive() {
                return WorkbenchRegistry.isRunning();
            }

            @Override
            public void setChecking(boolean isChecking) {
            }

            @Override
            public Map<String, String> getHeaders() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("X-ClientKey", SonargraphEnterpriseConnectionWidget.this.m_clientKey);
                return headers;
            }

            @Override
            public String getTestConnectionButtonLabel() {
                return "Test Connection";
            }
        });
        this.m_httpCheck.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.m_httpCheck.enableTestConnectionButton(false);
    }

    boolean isValid() {
        boolean isValid = this.m_connectionValidator.validate(this.getSonargraphConnection()).isSuccess();
        this.m_httpCheck.enableTestConnectionButton(isValid);
        if (isValid) {
            this.m_httpCheck.setDefaultButton(this.getShell());
        }
        return isValid;
    }

    public SonargraphEnterpriseConnection getSonargraphConnection() {
        return new SonargraphEnterpriseConnection(this.m_serverUrl, this.m_serverPort, this.m_clientKey, this.m_useProxy);
    }

    private ProxySettings getProxySettings() {
        StandaloneProxySettingsProvider proxyProvider = new StandaloneProxySettingsProvider();
        return proxyProvider.getProxySettings(false);
    }

    public void init(SonargraphEnterpriseConnection connection) {
        assert (connection != null) : "Parameter 'connection' of method 'init' must not be null";
        this.m_initialConnection = connection;
        this.reset();
    }

    boolean isModified() {
        return !this.getSonargraphConnection().equals((Object)this.m_initialConnection);
    }

    public void updateProxySettings() {
        if (this.getProxySettings() != null) {
            this.m_useProxyCheck.setText("Use Proxy");
            this.m_useProxyCheck.setEnabled(true);
        } else {
            this.m_useProxyCheck.setText("Use Proxy (Not Configured)");
            this.m_useProxyCheck.setEnabled(false);
        }
    }

    public void reset() {
        this.m_serverUrl = this.m_initialConnection.getServer();
        this.m_serverPort = this.m_initialConnection.getPort();
        this.m_clientKey = this.m_initialConnection.getClientKey();
        this.m_useProxy = this.m_initialConnection.useProxy();
        this.m_serverUrlText.setText(this.m_serverUrl);
        this.m_portText.setText(this.m_serverPort);
        this.m_clientKeyText.setText(this.m_clientKey);
        this.m_useProxyCheck.setSelection(this.m_useProxy);
    }

    public static interface ICallback {
        public void hasChanged(boolean var1, boolean var2);
    }
}

