/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SaveSnapshotCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.ISnapshotProvider;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveSnapshotDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SoftwareSystemBasedHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class SaveSnapshotHandler
extends SoftwareSystemBasedHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.SAVE_SYSTEM_AS_SNAPSHOT;
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem)) {
            return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED, WorkbenchState.SOFTWARE_SYSTEM_IS_CLEARABLE});
        }
        return false;
    }

    @Execute
    public void execute() {
        SaveSnapshotCommand cmd = new SaveSnapshotCommand(WorkbenchRegistry.getInstance().getProvider(), (SaveSnapshotCommand.ISaveSnapshotInteraction)new Interaction());
        UserInterfaceAdapter.getInstance().run((Command)cmd);
    }

    private static class Interaction
    extends SaveCommandInteraction
    implements SaveSnapshotCommand.ISaveSnapshotInteraction {
        private String m_filePath;

        private Interaction() {
            super(true);
        }

        public boolean collect(final SaveSnapshotCommand.SaveSnapshotData data) {
            RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                public void run() {
                    SaveSnapshotDialog dialog = new SaveSnapshotDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), ((ISnapshotProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(ISnapshotProvider.class)).getDefaultSnapshotName());
                    if (dialog.open() == 0) {
                        m_filePath = dialog.getDirectory().getNormalizedPath() + "/" + dialog.getName() + CoreFileType.SNAPSHOT.getDefaultExtension();
                        data.setFilePath(m_filePath);
                        data.setIncludeSources(dialog.getIncludeSources());
                        this.setResult(true);
                    } else {
                        this.setResult(false);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
        }

        public boolean confirmActiveBaselineWarning(String message) {
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'confirmActiveBaselineWarning' must not be empty";
            return UserInterfaceAdapter.getInstance().question(message + "\n\nDo you want to continue?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        public boolean confirmSnapshotOverwrite(String fileName) {
            return UserInterfaceAdapter.getInstance().question("About to overwrite existing snapshot '" + fileName + "'!\n\nDo you want to continue?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
        }

        @Override
        public boolean collectSaveData(final SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

                public void run() {
                    SaveDialog saveDialog = new SaveDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "All Modified File(s) Must Be Saved To Proceed", data.getNeedingSave(), data.getNeedingSave(), false, true);
                    if (saveDialog.open() == 0) {
                        data.setToBeSaved(saveDialog.getToBeSaved());
                        this.setResult(Boolean.TRUE);
                    } else {
                        this.setResult(Boolean.FALSE);
                    }
                }
            };
            return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
        }

        public void processSaveSnapshotResult(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processResult' must not be null";
            if (result.isSuccess()) {
                result.addInfo((OperationResult.IMessageCause)SaveSnapshotMessageCause.SAVED_SNAPSHOT, "File: " + this.m_filePath);
            }
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    public static enum SaveSnapshotMessageCause implements OperationResult.IMessageCause
    {
        SAVED_SNAPSHOT;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

