/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.system.AbstractOpenCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.PreRefreshActionsDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CloseCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;

public class RefreshSoftwareSystemInteraction
extends CloseCommandInteraction
implements RefreshCommand.IRefreshInteraction {
    private final TFile m_systemDirectory;
    private RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse m_response;

    public RefreshSoftwareSystemInteraction(TFile systemDirectory) {
        super(true);
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'Interaction' must not be null";
        this.m_systemDirectory = systemDirectory;
    }

    @Override
    public final boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        if (this.m_response != RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CLOSE) {
            data.setToBeSaved(Collections.emptyList());
            return true;
        }
        return super.collectSaveData(data);
    }

    public final void processRefreshResult(OperationResult result) {
        UserInterfaceAdapter.getInstance().process(result);
    }

    public final boolean confirmPreRefreshActions(final PrepareRefreshResult prepareRefreshResult) {
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'confirmPreRefreshActions' must not be null";
        RunnableWithResult<Boolean> result = new RunnableWithResult<Boolean>(){

            public void run() {
                PreRefreshActionsDialog dialog = new PreRefreshActionsDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), prepareRefreshResult);
                if (dialog.open() == 0) {
                    this.setResult(Boolean.TRUE);
                } else {
                    this.setResult(Boolean.FALSE);
                }
            }
        };
        return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)result);
    }

    public final boolean answerPreRefreshQuestion(PrepareRefreshResult.Question question) {
        return UserInterfaceAdapter.getInstance().question(question.getQuestion(), new String[]{"Yes", "No"}) == 0;
    }

    public final void processPrepareRefreshResult(PrepareRefreshResult result) {
        assert (result != null) : "Parameter 'result' of method 'processRefreshPrepareResult' must not be null";
        UserInterfaceAdapter.getInstance().process((OperationResult)result);
    }

    public final RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse confirmPreRefreshSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'confirmSoftwareSystemModification' must not be null";
        assert (modification != PrepareRefreshResult.SoftwareSystemFileModification.NONE) : "Unexpected: " + String.valueOf(modification);
        String question = null;
        String[] buttonLabels = null;
        int response = -1;
        switch (modification) {
            case DELETED: 
            case DELETED_CONFLICT: {
                question = "System file has been deleted on disk. What do you want to do?";
                buttonLabels = new String[]{"Continue", "Close system"};
                response = UserInterfaceAdapter.getInstance().question(question, buttonLabels);
                if (response <= 0 || response >= buttonLabels.length) {
                    this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
                    break;
                }
                this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CLOSE;
                break;
            }
            case MODIFIED: 
            case MODIFIED_CONFLICT: {
                question = "System file has been modified on disk. What do you want to do?";
                buttonLabels = new String[]{"Continue", "Reload system"};
                response = UserInterfaceAdapter.getInstance().question(question, buttonLabels);
                if (response <= 0 || response >= buttonLabels.length) {
                    this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
                    break;
                }
                this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.RELOAD;
                break;
            }
            case NONE: {
                assert (false) : "None specified";
                this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
                break;
            }
            default: {
                assert (false) : "Unhandled: " + String.valueOf(modification);
                this.m_response = RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
            }
        }
        return this.m_response;
    }

    @Override
    public final boolean closeSoftwareSystem() {
        return true;
    }

    public final boolean collectOpenData(AbstractOpenCommand.OpenData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        data.setLocation(this.m_systemDirectory);
        return true;
    }

    public final void processOpenResult(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'processOpenResult' must not be null";
        UserInterfaceAdapter.getInstance().process(result);
    }

    public final boolean confirmSystemSaveDueToExternalFileChangesOnOpen(boolean hasUndoHistory) {
        Object message = "External files that the workspace depends on have been changed.\nDo you want to save the software system file and continue?";
        if (hasUndoHistory) {
            message = (String)message + "\n\nNote that the undo/redo history for this file will be cleared.";
        }
        return UserInterfaceAdapter.getInstance().question((String)message, false) == UserInterfaceAdapter.Feedback.CONFIRMED;
    }

    public final void processSaveResultDueToExternalFileChangesOnOpen(OperationResult saveResult) {
        UserInterfaceAdapter.getInstance().process(saveResult);
    }

    public void collectRefreshData(RefreshCommand.RefreshData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        data.addOptions(new ISoftwareSystemProvider.IRefreshOption[]{ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL});
        data.addOptions(new ISoftwareSystemProvider.IRefreshOption[]{ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT});
    }
}

