/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemAdditionalFilesCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.PreRefreshActionsDialog;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RefreshSoftwareSystemInteraction;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class RefreshSoftwareSystemHandler
extends CommandHandler {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                if (!$assertionsDisabled && currentSelection == null) {
                    throw new AssertionError((Object)"Parameter 'currentSelection' of method 'showInContextMenu' must not be null");
                }
                return currentSelection.isEmpty() && (workbenchView.getViewId() == ViewId.NAVIGATION_VIEW || workbenchView.getViewId() == ViewId.LOGICAL_NAMESPACES_VIEW || workbenchView.getViewId() == ViewId.FILES_VIEW);
            }
        };
    }

    @CanExecute
    public boolean canExecute(@Optional MMenuItem menuItem) {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (provider.hasSoftwareSystem()) {
            SoftwareSystemMode mode = provider.getSoftwareSystem().getMode();
            boolean available = switch (mode) {
                case SoftwareSystemMode.SYSTEM -> CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.REFRESH_SOFTWARE_SYSTEM);
                case SoftwareSystemMode.SYSTEM_ATTACHED_TO_SNAPSHOT, SoftwareSystemMode.SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT -> CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.REFRESH_SOFTWARE_SYSTEM_ADDITIONAL_FILES);
                case SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT -> false;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled mode: " + String.valueOf(mode)));
                    }
                    yield false;
                }
            };
            RefreshSoftwareSystemHandler.setVisibility((MMenuItem)menuItem, (boolean)available);
            return available;
        }
        return false;
    }

    @Execute
    public void execute() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        SoftwareSystemMode mode = softwareSystem.getMode();
        switch (mode) {
            case SYSTEM: {
                RefreshSoftwareSystemCommand command = new RefreshSoftwareSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (RefreshCommand.IRefreshInteraction)new RefreshSoftwareSystemInteraction(((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getSystemDirectory().getFile()));
                UserInterfaceAdapter.getInstance().run((Command)command);
                break;
            }
            case SYSTEM_ATTACHED_TO_SNAPSHOT: 
            case SYSTEM_EXTRACTED_AND_ATTACHED_TO_SNAPSHOT: {
                RefreshSoftwareSystemAdditionalFilesCommand command = new RefreshSoftwareSystemAdditionalFilesCommand(provider, new RefreshSoftwareSystemAdditionalFilesCommand.RefreshSoftwareSystemAdditionalFilesInteraction(){

                    public boolean confirmPreRefreshActions(final PrepareRefreshResult prepareRefreshResult) {
                        if (!$assertionsDisabled && prepareRefreshResult == null) {
                            throw new AssertionError((Object)"Parameter 'prepareRefreshResult' of method 'confirmPreRefreshActions' must not be null");
                        }
                        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

                            public void run() {
                                PreRefreshActionsDialog dialog = new PreRefreshActionsDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "Confirm refresh actions", prepareRefreshResult);
                                if (dialog.open() == 0) {
                                    this.setResult(Boolean.TRUE);
                                } else {
                                    this.setResult(Boolean.FALSE);
                                }
                            }
                        };
                        return (Boolean)UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                    }

                    public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                        if (!$assertionsDisabled && system == null) {
                            throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                        }
                        if (!$assertionsDisabled && toBeSaved == null) {
                            throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                        }
                        return SaveCommandInteraction.performAboutToSave(system, toBeSaved);
                    }

                    public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collectSaveData' must not be null");
                        }
                        return SaveCommandInteraction.performCollectSaveData(data, true);
                    }

                    public boolean processSaveResult(OperationResult result) {
                        return SaveCommandInteraction.performProcessSaveResult(result, false);
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)command);
                break;
            }
            case SYSTEM_LOADED_FROM_SNAPSHOT: {
                assert (false) : "Unexpected mode: " + String.valueOf(mode);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf(mode);
                break;
            }
        }
    }
}

