/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.MetricTrend;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StackedBarWidget;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import java.util.function.Function;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class RedYellowGreenWithMetricTrend
extends MetricTrend {
    private StackedBarWidget m_stackedBarWidget;
    private final String m_redToolTip;
    private final String m_yellowToolTip;
    private final String m_greenToolTip;

    public RedYellowGreenWithMetricTrend(Composite parent, String label, String toolTipText, boolean showTrend, String redToolTip, String yellowToolTip, String greenToolTip, int firstColumnWidth) {
        super(parent, label, showTrend, toolTipText, firstColumnWidth);
        this.m_redToolTip = redToolTip;
        this.m_yellowToolTip = yellowToolTip;
        this.m_greenToolTip = greenToolTip;
    }

    @Override
    protected Control createCenterControl(Composite parent) {
        this.m_stackedBarWidget = new StackedBarWidget(parent, 0, StackedBarWidget.ValueType.NUMERIC_AND_PERCENT, this.getName());
        return this.m_stackedBarWidget;
    }

    public void setDiscriminationValues(int redValue, int redAndYellow, int all) {
        if (all == 0) {
            this.m_stackedBarWidget.reset();
            return;
        }
        int warningEntangledLoc = redAndYellow - redValue;
        int untangledLoc = all - redAndYellow;
        ArrayList<StackedBarWidget.BarPartInfo> parts = new ArrayList<StackedBarWidget.BarPartInfo>(3);
        Function<Integer, Float> percent = a -> Float.valueOf((float)a.intValue() * 100.0f / (float)all);
        parts.add(new StackedBarWidget.BarPartInfo(this.m_redToolTip, redValue, percent.apply(redValue), UiResourceManager.getInstance().getColor(UiResourceManager.RED), "red", true));
        parts.add(new StackedBarWidget.BarPartInfo(this.m_yellowToolTip, warningEntangledLoc, percent.apply(warningEntangledLoc), UiResourceManager.getInstance().getColor(UiResourceManager.YELLOW), "yellow", true));
        parts.add(new StackedBarWidget.BarPartInfo(this.m_greenToolTip, untangledLoc, percent.apply(untangledLoc), UiResourceManager.getInstance().getColor(UiResourceManager.GREEN), "green", true));
        this.m_stackedBarWidget.setPartInfos(parts, false);
    }
}

