/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.ClearRecentlyUsedMenuItem;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.EmptyRecentlyUsedMenuItem;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RecentlyUsedMenuItem;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecentlyUsedSubMenu
implements ISonargraphUIContribution {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentlyUsedSubMenu.class);
    private static final String MENU_ROOT = "com.hello2morrow.sonargraph.standalone.menu.openRecentlyUsed";

    public static void removeEntries(IEclipseContext eclipseContext, MWindow mainApplicationWindow) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'removeEntries' must not be null";
        MMenu found = (MMenu)RcpUtility.findUniqueModelElement((IEclipseContext)eclipseContext, (MUIElement)mainApplicationWindow.getMainMenu(), (String)MENU_ROOT, MMenu.class);
        if (found != null) {
            ArrayList<MMenuElement> toBeRemoved = new ArrayList<MMenuElement>();
            for (MMenuElement next : found.getChildren()) {
                if (next instanceof MDynamicMenuContribution) continue;
                toBeRemoved.add(next);
            }
            found.getChildren().removeAll(toBeRemoved);
        }
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        assert (items != null) : "Parameter 'items' of method 'aboutToShow' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        SoftwareSystem softwareSystem = provider.hasSoftwareSystem() ? provider.getSoftwareSystem() : null;
        PersistentRecentlyUsedList persistentRecentlyUsedList = provider.getRecentlyUsedList();
        block4: for (String next : persistentRecentlyUsedList.getAll()) {
            MDirectMenuItem nextItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            ISoftwareSystemProvider.PathType pathType = provider.getPathType(next);
            if (pathType != null) {
                switch (pathType) {
                    case SNAPSHOT: {
                        if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.OPEN_SOFTWARE_SYSTEM_FROM_SNAPSHOT, (SoftwareSystem)softwareSystem)) continue block4;
                        nextItem.setIconURI("platform:/plugin/com.hello2morrow.sonargraph.standalone/images/Snapshot.gif");
                        break;
                    }
                    case SOFTWARE_SYSTEM: {
                        if (!SonargraphCommand.isAvailable((ICommandId)CoreCommandId.OPEN_SOFTWARE_SYSTEM, (SoftwareSystem)softwareSystem)) continue block4;
                        nextItem.setIconURI("platform:/plugin/com.hello2morrow.sonargraph.standalone/images/OpenSystem.gif");
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled path type: " + String.valueOf(pathType);
                        break;
                    }
                }
                items.add((MMenuElement)nextItem);
            } else {
                LOGGER.warn("Unrecognized path: " + next);
            }
            nextItem.setLabel(next);
            nextItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.standalone");
            nextItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.standalone/" + RecentlyUsedMenuItem.class.getName());
        }
        if (items.isEmpty()) {
            MDirectMenuItem emptyItem = MMenuFactory.INSTANCE.createDirectMenuItem();
            emptyItem.setLabel("<< Empty >>");
            emptyItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.standalone");
            emptyItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.standalone/" + EmptyRecentlyUsedMenuItem.class.getName());
            items.add((MMenuElement)emptyItem);
        }
        items.add((MMenuElement)MMenuFactory.INSTANCE.createMenuSeparator());
        MDirectMenuItem clearItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        clearItem.setLabel("Clear List");
        clearItem.setContributorURI("platform:/plugin/com.hello2morrow.sonargraph.standalone");
        clearItem.setContributionURI("bundleclass://com.hello2morrow.sonargraph.standalone/" + ClearRecentlyUsedMenuItem.class.getName());
        clearItem.setIconURI("platform:/plugin/com.hello2morrow.sonargraph.standalone/images/ClearRecentlyUsedList.gif");
        items.add((MMenuElement)clearItem);
    }
}

