/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.IBoxCompositeContribution;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StackedBarWidget;
import com.hello2morrow.sonargraph.ui.swt.base.DetailsSeparatorWidget;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class QualityGatesStatus
implements IBoxCompositeContribution {
    private final InfoWidget m_statusInfo;
    private final GridData m_statusGridData;
    private final StackedBarWidget m_stackedBarWidget;
    private final GridData m_widgetData;

    QualityGatesStatus(Composite parent, int firstColumnWidth) {
        assert (parent != null) : "Parameter 'parent' of method 'QualityGatesStatus' must not be null";
        this.m_statusInfo = new InfoWidget(parent);
        this.m_statusGridData = new GridData(4, 0x1000000, false, false);
        this.m_statusGridData.widthHint = firstColumnWidth;
        this.m_statusInfo.setLayoutData(this.m_statusGridData);
        this.m_stackedBarWidget = new StackedBarWidget(parent, 0, StackedBarWidget.ValueType.NUMERIC, "Quality Gate Status");
        this.m_widgetData = new GridData(4, 0x1000000, false, false);
        this.m_widgetData.heightHint = 12;
        this.m_widgetData.widthHint = 140;
        this.m_stackedBarWidget.setLayoutData(this.m_widgetData);
        SwtUtility.createFillerForGridLayoutCell((Composite)parent, (int)2, (int)1);
        this.m_statusInfo.setValues("n/a", "n/a", "n/a");
    }

    public void resetStatusInfo() {
        this.m_statusInfo.setValues("n/a", "n/a", "n/a");
        this.m_stackedBarWidget.reset();
    }

    public void setStatusInfo(int failed, int passed, int inactive) {
        this.m_statusInfo.setValues(Integer.toString(failed), Integer.toString(passed), Integer.toString(inactive));
        if (failed + passed + inactive == 0) {
            this.m_stackedBarWidget.reset();
            return;
        }
        ArrayList<StackedBarWidget.BarPartInfo> parts = new ArrayList<StackedBarWidget.BarPartInfo>(3);
        parts.add(new StackedBarWidget.BarPartInfo("Failed", failed, UiResourceManager.getInstance().getColor(UiResourceManager.RED), "red", true));
        parts.add(new StackedBarWidget.BarPartInfo("Passed", passed, UiResourceManager.getInstance().getColor(UiResourceManager.GREEN), "green", true));
        parts.add(new StackedBarWidget.BarPartInfo("Inactive", inactive, UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREY), "gray", true));
        this.m_stackedBarWidget.setPartInfos(parts);
    }

    public void changeExpansionState(DetailsSeparatorWidget.ExpansionState expansionState, String identifier) {
        assert (expansionState != null) : "Parameter 'expansionState' of method 'changeExpansionState' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'changeExpansionState' must not be empty";
        boolean visible = expansionState == DetailsSeparatorWidget.ExpansionState.EXPANDED;
        this.m_statusInfo.setVisible(visible);
        this.m_statusGridData.exclude = !visible;
        this.m_stackedBarWidget.setVisible(visible);
        this.m_widgetData.exclude = !visible;
    }

    private static class InfoWidget
    extends Composite {
        private static final int HORIZONTAL_INDENT = 5;
        private final Label m_failedValue;
        private final Label m_passedValue;
        private final Label m_inactiveValue;
        private final Label m_passed;
        private final Label m_failed;
        private final Label m_inactive;

        public InfoWidget(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)6));
            this.m_failed = new Label((Composite)this, 0);
            this.m_failed.setText("Failed: ");
            this.m_failedValue = new Label((Composite)this, 0);
            this.m_passed = new Label((Composite)this, 0);
            GridData passedGridData = new GridData(4, 0x1000000, false, false);
            passedGridData.horizontalIndent = 5;
            this.m_passed.setLayoutData((Object)passedGridData);
            this.m_passed.setText("Passed: ");
            this.m_passedValue = new Label((Composite)this, 0);
            this.m_inactive = new Label((Composite)this, 0);
            GridData inactiveGridData = new GridData(4, 0x1000000, false, false);
            inactiveGridData.horizontalIndent = 5;
            this.m_inactive.setLayoutData((Object)inactiveGridData);
            this.m_inactive.setText("Inactive: ");
            this.m_inactiveValue = new Label((Composite)this, 0);
        }

        public void setValues(String failed, String passed, String inactive) {
            this.changeColorAndFont(this.m_failedValue, failed, UiResourceManager.getInstance().getColor(UiResourceManager.RED));
            this.m_failedValue.setText(failed);
            this.changeColorAndFont(this.m_passedValue, passed, UiResourceManager.getInstance().getColor(UiResourceManager.GREEN));
            this.m_passedValue.setText(passed);
            this.changeColorAndFont(this.m_inactiveValue, inactive, UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREY));
            this.m_inactiveValue.setText(inactive);
        }

        private void changeColorAndFont(Label label, String value, Color color) {
            if (value.equals("n/a") || value.equals("0")) {
                label.setForeground(UiResourceManager.getInstance().getForegroundColor());
                label.setFont(UiResourceManager.getInstance().getFont(0));
            } else {
                label.setForeground(color);
                label.setFont(UiResourceManager.getInstance().getFont(1));
            }
        }
    }
}

