/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.ImportQualityModelCommand;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.QualityModelLoader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CreateManualSystemCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;

public final class ManualSystemWizard
extends NonLazySonargraphWizard {
    private final ISoftwareSystemProvider m_softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
    private SystemDirectoryWizardPage m_basicDataPage;

    public ManualSystemWizard() {
        super("New System");
    }

    public void addPages() {
        List fileDescriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        List<ResolvedQualityModelDescriptorFile> resolvedDescriptors = QualityModelLoader.loadQualityModelFiles(fileDescriptors);
        int defaultIndex = 0;
        int i = 0;
        while (i < resolvedDescriptors.size()) {
            if (resolvedDescriptors.get(i).getQualityModelFileDescriptor().getLanguage() == null) {
                defaultIndex = i;
                break;
            }
            ++i;
        }
        this.m_basicDataPage = new SystemDirectoryWizardPage("New System", "Specify the name, description and location of the new system", "Name:", "Directory:", "Use quality model", CreateSoftwareSystemCommand.getNameValidator((ISoftwareSystemProvider)this.m_softwareSystemProvider), CreateSoftwareSystemCommand.getBaseDirectoryValidator((ISoftwareSystemProvider)this.m_softwareSystemProvider), ImportQualityModelCommand.getImportQualityModelValidator((ISoftwareSystemProvider)this.m_softwareSystemProvider), resolvedDescriptors, defaultIndex, "", "");
        this.addPage((SonargraphWizardPage)this.m_basicDataPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            CreateSoftwareSystemCommand createSystemCommand = new CreateSoftwareSystemCommand(this.m_softwareSystemProvider, (AbstractCreateSoftwareSystemCommand.IInteraction)new CreateManualSystemCommandInteraction(this.m_basicDataPage));
            UserInterfaceAdapter.getInstance().run((Command)createSystemCommand);
            return true;
        }
        return false;
    }
}

