/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

final class CloseExtractedAndAttachedSystemDialog
extends StandardDialog {
    private final CloseSoftwareSystemCommand.CloseExtractedAndAttachedSystemData m_data;
    private boolean m_hasValidPath = true;

    CloseExtractedAndAttachedSystemDialog(Shell parentShell, CloseSoftwareSystemCommand.CloseExtractedAndAttachedSystemData data) {
        super(parentShell, "Close Extracted and 'Attached' System");
        assert (data != null) : "Parameter 'data' of method 'CloseExtractedAndAttachedSystemDialog' must not be null";
        this.m_data = data;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CLOSE_EXTRACTED_AND_ATTACHED_SYSTEM_DIALOG;
    }

    protected void applyData() {
        this.getButton(0).setEnabled(true);
    }

    protected Point getPreferredSize() {
        return new Point(500, 200);
    }

    private void modified() {
        this.getButton(0).setEnabled(!this.m_data.saveTo() || this.m_hasValidPath);
    }

    protected void fillDialogArea(Composite composite) {
        final Button remove = new Button(composite, 32);
        remove.setText("Delete extracted system files");
        remove.setSelection(this.m_data.delete());
        remove.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloseExtractedAndAttachedSystemDialog.this.m_data.setDelete(remove.getSelection());
                CloseExtractedAndAttachedSystemDialog.this.modified();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        final Button update = new Button(composite, 32);
        update.setText("Create system snapshot based on extracted system files");
        update.setSelection(this.m_data.saveTo());
        update.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final ValidatingPathWidget pathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    CloseExtractedAndAttachedSystemDialog.this.m_data.setSaveToFile(input);
                    CloseExtractedAndAttachedSystemDialog.this.m_hasValidPath = true;
                } else {
                    CloseExtractedAndAttachedSystemDialog.this.m_hasValidPath = false;
                }
                CloseExtractedAndAttachedSystemDialog.this.modified();
            }
        }, this.m_data.getPathValidator(), 2, this.m_data.saveToFile(), true, false);
        pathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pathWidget.setEnabled(this.m_data.saveTo());
        update.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloseExtractedAndAttachedSystemDialog.this.m_data.setSaveTo(update.getSelection());
                pathWidget.setEnabled(CloseExtractedAndAttachedSystemDialog.this.m_data.saveTo());
                CloseExtractedAndAttachedSystemDialog.this.modified();
            }
        });
    }
}

