/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.command.system.settings.SearchPathAddPathCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.SearchPathEditPathCommand;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.ui.standalone.settings.ButtonControl;
import com.hello2morrow.sonargraph.ui.standalone.settings.SearchPathContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchPathControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchPathControl.class);
    private TreeViewer m_treeview;
    private ISearchPathProviderManager m_provider;
    private TreeViewer m_pathTree;
    private SearchPathDelta m_delta;
    private final ISearchPathControlCallback m_callback;

    public SearchPathControl(ISearchPathProviderManager provider, ISearchPathControlCallback callback) {
        assert (provider != null) : "Parameter 'provider' of method 'SearchPathControl' must not be null";
        assert (callback != null) : "Parameter 'callback' of method 'SearchPathControl' must not be null";
        this.m_provider = provider;
        this.m_callback = callback;
    }

    public void setSearchPathProviderManager(ISearchPathProviderManager newProvider) {
        this.m_provider = newProvider;
    }

    public void createContent(Composite container, int widthHint, int heightHint) {
        assert (container != null) : "Parameter 'container' of method 'SearchPathControl' must not be null";
        this.m_treeview = this.createTreeView(container, widthHint, heightHint);
        final ButtonControl buttonControl = new ButtonControl(container);
        this.m_treeview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = SearchPathControl.isSingleDirectorySelected(SearchPathControl.this.m_treeview);
                buttonControl.setEnabled("Delete", enabled);
                buttonControl.setEnabled("Edit...", enabled);
                buttonControl.setEnabled("Move Up", enabled);
                buttonControl.setEnabled("Move Down", enabled);
            }
        });
        SelectionAdapter addListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dirDialog = new DirectoryDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
                String fileName = dirDialog.open();
                if (fileName == null) {
                    return;
                }
                TFile dir = new TFile(fileName);
                if (!dir.isDirectory() || !dir.exists()) {
                    LOGGER.warn("Selected directory is not a valid existing directory!");
                    return;
                }
                if (SearchPathControl.this.m_delta.getNewMap().keySet().contains(dir)) {
                    LOGGER.info("Directory '" + dir.getNormalizedAbsolutePath() + "' already exists in search path");
                    return;
                }
                SearchPathAddPathCommand command = new SearchPathAddPathCommand(WorkbenchRegistry.getInstance().getProvider(), SearchPathControl.this.m_provider, SearchPathControl.this.m_delta, dir);
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
                if (command.getResult().isFailure()) {
                    UserInterfaceAdapter.getInstance().process(command.getResult());
                    return;
                }
                SearchPathControl.this.m_callback.searchPathChanged(SearchPathControl.this.m_delta);
            }
        };
        SelectionAdapter editListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TFile oldPath = SearchPathControl.this.getSelectedDir();
                if (oldPath == null) {
                    return;
                }
                DirectoryDialog dirDialog = new DirectoryDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 4096);
                dirDialog.setFilterPath(oldPath.getNormalizedAbsolutePath());
                String fileName = dirDialog.open();
                if (fileName == null) {
                    return;
                }
                TFile newPath = new TFile(fileName);
                if (!newPath.isDirectory() || !newPath.exists()) {
                    LOGGER.warn("Selected directory is not a valid existing directory!");
                    return;
                }
                if (newPath.equals((Object)oldPath)) {
                    return;
                }
                SearchPathEditPathCommand command = new SearchPathEditPathCommand(WorkbenchRegistry.getInstance().getProvider(), SearchPathControl.this.m_provider, SearchPathControl.this.m_delta, oldPath, newPath);
                UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
                if (command.getResult().isFailure()) {
                    UserInterfaceAdapter.getInstance().process(command.getResult());
                    return;
                }
                SearchPathControl.this.m_callback.searchPathChanged(SearchPathControl.this.m_delta);
            }
        };
        SelectionAdapter deleteListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TFile dir = SearchPathControl.this.getSelectedDir();
                if (dir == null) {
                    return;
                }
                SearchPathControl.this.m_delta.delete(dir);
                SearchPathControl.this.m_callback.searchPathChanged(SearchPathControl.this.m_delta);
            }
        };
        buttonControl.addButton("Add...", (SelectionListener)addListener, true);
        buttonControl.addButton("Edit...", (SelectionListener)editListener, false);
        buttonControl.addButton("Delete", (SelectionListener)deleteListener, false);
        buttonControl.addPlaceholder();
        buttonControl.addButton("Move Up", (SelectionListener)new MovePathSelectionAdapter(true), false);
        buttonControl.addButton("Move Down", (SelectionListener)new MovePathSelectionAdapter(false), false);
    }

    public boolean isEdited() {
        if (this.m_delta == null) {
            return false;
        }
        return this.m_delta.isModified();
    }

    public SearchPath getOriginalSearchPath() {
        return this.m_delta.getOriginal();
    }

    private TFile getSelectedDir() {
        if (this.m_treeview.getSelection().isEmpty()) {
            UserInterfaceAdapter.getInstance().information("Please select a directory!", null);
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)this.m_treeview.getSelection();
        if (selection.size() > 1) {
            UserInterfaceAdapter.getInstance().information("Multiple selects are not supported!", null);
            return null;
        }
        Object selected = selection.getFirstElement();
        if (selected instanceof TFile) {
            LOGGER.debug("Selected entry " + String.valueOf(selected) + " for edit");
            return (TFile)selected;
        }
        UserInterfaceAdapter.getInstance().information("Please select a directory!", null);
        return null;
    }

    public static boolean isSingleDirectorySelected(TreeViewer treeviewer) {
        if (treeviewer.getSelection().isEmpty()) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)treeviewer.getSelection();
        if (selection.size() > 1) {
            return false;
        }
        Object selected = selection.getFirstElement();
        if (selected instanceof TFile) {
            TFile dir = (TFile)selected;
            return !dir.isFile();
        }
        return false;
    }

    public void setInput(Map<TFile, List<TFile>> input, SearchPathDelta delta) {
        assert (input != null) : "Parameter 'input' of method 'setInput' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'setInput' must not be null";
        if (this.m_pathTree.getControl().isDisposed()) {
            return;
        }
        if (input.isEmpty()) {
            LOGGER.debug("No input provided");
        }
        this.m_pathTree.setInput(input);
        this.m_delta = delta;
    }

    private TreeViewer createTreeView(Composite container, int widthHint, int heightHint) {
        this.m_pathTree = new TreeViewer(container, 68354);
        SearchPathContentAndLabelProvider labelAndContentProvider = new SearchPathContentAndLabelProvider();
        this.m_pathTree.setContentProvider((IContentProvider)labelAndContentProvider);
        this.m_pathTree.setLabelProvider((IBaseLabelProvider)labelAndContentProvider);
        this.m_pathTree.setAutoExpandLevel(2);
        GridData gridData = new GridData(4, 4, true, true);
        if (widthHint > 0) {
            gridData.widthHint = widthHint;
        }
        if (heightHint > 0) {
            gridData.heightHint = heightHint;
        }
        this.m_pathTree.getTree().setLayoutData((Object)gridData);
        return this.m_pathTree;
    }

    public static interface ISearchPathControlCallback {
        public void searchPathChanged(SearchPathDelta var1);

        public boolean okToLeave();

        public boolean performCancel();
    }

    class MovePathSelectionAdapter
    extends SelectionAdapter {
        private final boolean m_IsMoveUp;

        public MovePathSelectionAdapter(boolean isMoveUp) {
            this.m_IsMoveUp = isMoveUp;
        }

        public void widgetSelected(SelectionEvent e) {
            TFile dir = SearchPathControl.this.getSelectedDir();
            if (dir == null) {
                UserInterfaceAdapter.getInstance().information("Please select a directory.", null);
                return;
            }
            if (this.m_IsMoveUp) {
                SearchPathControl.this.m_delta.moveDirUp(dir);
            } else {
                SearchPathControl.this.m_delta.moveDirDown(dir);
            }
            SearchPathControl.this.m_callback.searchPathChanged(SearchPathControl.this.m_delta);
        }
    }
}

