/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

final class ScriptRunnerEntryDialog
extends StandardDialog
implements ComboWithImages.IItemSelectionListener {
    private final IDataProvider m_provider;
    private ComboWithImages m_scriptCombo;
    private ComboWithImages m_runConfigurationCombo;
    private GroovyScript m_currentGroovyScript;
    private IRunConfiguration m_currentIRunConfiguration;

    ScriptRunnerEntryDialog(Shell parentShell, IDataProvider provider) {
        super(parentShell, "Add As Automated Script");
        assert (provider != null) : "Parameter 'provider' of method 'ScriptRunnerEntryDialog' must not be null";
        this.m_provider = provider;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void applyData() {
        this.getButton(0).setEnabled(true);
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label scriptLabel = new Label(composite, 0);
        scriptLabel.setText("Script:");
        List<GroovyScript> scripts = this.m_provider.getAvailableScripts();
        assert (scripts != null && scripts.size() > 0) : "'scripts' of method 'fillDialogArea' must not be empty";
        this.m_scriptCombo = new ComboWithImages(composite, -1, "Select Script", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof GroovyScript)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((GroovyScript)item).getIdentifyingPath();
            }

            public Image getImage(Object item) {
                return UiResourceManager.getInstance().getImage("GroovyScript");
            }
        });
        this.m_currentGroovyScript = scripts.get(0);
        this.m_scriptCombo.setItems(scripts, (Object)this.m_currentGroovyScript);
        this.m_scriptCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        Label runConfigurationLabel = new Label(composite, 0);
        runConfigurationLabel.setText("Run configuration:");
        this.m_runConfigurationCombo = new ComboWithImages(composite, -1, "Select Run Configuration", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof IRunConfiguration)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((IRunConfiguration)item).getRunConfigurationName();
            }

            public Image getImage(Object item) {
                return UiResourceManager.getInstance().getImage("RunConfiguration");
            }
        });
        List<IRunConfiguration> runConfigurations = this.m_provider.getAvailableRunConfigurations(scripts.get(0));
        assert (runConfigurations != null && !runConfigurations.isEmpty()) : "'runConfigurations' of method 'fillDialogArea' must not be empty";
        this.m_currentIRunConfiguration = runConfigurations.get(0);
        this.m_runConfigurationCombo.setItems(runConfigurations, (Object)this.m_currentIRunConfiguration);
        this.m_runConfigurationCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.m_scriptCombo.setSelectionListener((ComboWithImages.IItemSelectionListener)this);
        this.m_runConfigurationCombo.setSelectionListener((ComboWithImages.IItemSelectionListener)this);
    }

    public void itemSelected(ComboWithImages source, Object item) {
        assert (source != null) : "Parameter 'source' of method 'itemSelected' must not be null";
        assert (item != null) : "Parameter 'item' of method 'itemSelected' must not be null";
        if (source == this.m_scriptCombo) {
            this.m_currentGroovyScript = (GroovyScript)item;
            List<IRunConfiguration> runConfigurations = this.m_provider.getAvailableRunConfigurations(this.m_currentGroovyScript);
            assert (runConfigurations != null && !runConfigurations.isEmpty()) : "'runConfigurations' of method 'itemSelected' must not be empty";
            this.m_currentIRunConfiguration = runConfigurations.get(0);
            this.m_runConfigurationCombo.setItems(runConfigurations, (Object)this.m_currentIRunConfiguration);
        } else if (source == this.m_runConfigurationCombo) {
            this.m_currentIRunConfiguration = (IRunConfiguration)item;
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    GroovyScript getGroovyScript() {
        assert (this.m_currentGroovyScript != null) : "'m_currentGroovyScript' of method 'getGroovyScript' must not be null";
        return this.m_currentGroovyScript;
    }

    IRunConfiguration getRunConfiguration() {
        assert (this.m_currentIRunConfiguration != null) : "'m_currentIRunConfiguration' of method 'getCurrentRunConfiguration' must not be null";
        return this.m_currentIRunConfiguration;
    }

    static interface IDataProvider {
        public List<GroovyScript> getAvailableScripts();

        public List<IRunConfiguration> getAvailableRunConfigurations(GroovyScript var1);
    }
}

