/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.remoting.ConfigureRemoteSelectionCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.PortValidator;
import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class RemoteSelectionSettingsPage
extends StandardPreferencePage
implements ISettingsDelta {
    private final IRemoteSelectionProvider m_remoteSelectionProvider;
    private RemoteConfiguration m_originalConfiguration;
    private ValidatingTextWidget m_portOutgoing;
    private int m_modifiedPortOutgoing;
    private ValidatingTextWidget m_portIncoming;
    private int m_modifiedPortIncoming;
    private boolean m_modified;
    private OperationResult m_operationResult;

    public RemoteSelectionSettingsPage() {
        this.noDefaultAndApplyButton();
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        this.m_remoteSelectionProvider = (IRemoteSelectionProvider)installation.getExtension(IRemoteSelectionProvider.class);
        this.init();
    }

    private void init() {
        OperationResultWithOutcome result = this.m_remoteSelectionProvider.getConfiguration();
        this.m_originalConfiguration = result.getOutcome() != null ? (RemoteConfiguration)result.getOutcome() : this.m_remoteSelectionProvider.getDefaultConfiguration();
        this.m_modifiedPortIncoming = this.m_originalConfiguration.getServerPort();
        this.m_modifiedPortOutgoing = this.m_originalConfiguration.getRemotePort();
    }

    public String getTitle() {
        return "Remote Selection";
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.REMOTE_SELECTION_SETTINGS_PAGE;
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2));
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label info = new Label(content, 64);
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        gridData.widthHint = 500;
        info.setLayoutData((Object)gridData);
        info.setText("Specify the port for incoming selection events Sonargraph receives from IDE plugin and the port for outgoing selection events that Sonargraph sends to IDE plugin.");
        SwtUtility.placeHorizontalSeparator((Composite)content, (int)2);
        Label incomingPortLabel = new Label(content, 0);
        incomingPortLabel.setText("Sonargraph Port (Incoming Requests): ");
        incomingPortLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_portIncoming = new ValidatingTextWidget(content, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                RemoteSelectionSettingsPage.this.m_modifiedPortIncoming = input != null ? Integer.parseInt(input.trim()) : -1;
                RemoteSelectionSettingsPage.this.inputModified();
            }
        }, Integer.toString(this.m_originalConfiguration.getServerPort()), 0);
        this.m_portIncoming.setLayoutData((Object)new GridData(4, 4, true, false));
        Label outgoingPortLabel = new Label(content, 0);
        outgoingPortLabel.setText("IDE Port (Outgoing Requests): ");
        outgoingPortLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_portOutgoing = new ValidatingTextWidget(content, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                RemoteSelectionSettingsPage.this.m_modifiedPortOutgoing = input != null ? Integer.parseInt(input.trim()) : -1;
                RemoteSelectionSettingsPage.this.inputModified();
            }
        }, Integer.toString(this.m_originalConfiguration.getRemotePort()), 0);
        this.m_portOutgoing.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite filler = new Composite(content, 0);
        filler.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createButtonsPart(content, true);
        this.getApplyButton().setEnabled(this.m_modified);
        this.getCancelButton().setEnabled(this.m_modified);
        return parent;
    }

    @Override
    protected ISettingsDelta getDelta() {
        return this;
    }

    @Override
    protected void internPerformOk() {
        if (!this.m_modified) {
            return;
        }
        ConfigureRemoteSelectionCommand command = new ConfigureRemoteSelectionCommand(WorkbenchRegistry.getInstance().getProvider(), new ConfigureRemoteSelectionCommand.IInteraction(){

            public boolean collect(ConfigureRemoteSelectionCommand.RemoteSelectionConfigurationData data) {
                RemoteConfiguration configuration = new RemoteConfiguration(RemoteSelectionSettingsPage.this.m_originalConfiguration.isEnabled(), RemoteSelectionSettingsPage.this.m_modifiedPortIncoming, RemoteSelectionSettingsPage.this.m_originalConfiguration.isRemoteEnabled(), RemoteSelectionSettingsPage.this.m_modifiedPortOutgoing);
                data.setModifiedConfiguration(configuration);
                return true;
            }

            public void processResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
                RemoteSelectionSettingsPage.this.m_operationResult = result;
                UserInterfaceAdapter.getInstance().displayUiElement(() -> {
                    if (!RemoteSelectionSettingsPage.this.m_portIncoming.isDisposed()) {
                        RemoteSelectionSettingsPage.this.init();
                        RemoteSelectionSettingsPage.this.m_portIncoming.setText(Integer.toString(RemoteSelectionSettingsPage.this.m_originalConfiguration.getServerPort()));
                        RemoteSelectionSettingsPage.this.m_portOutgoing.setText(Integer.toString(RemoteSelectionSettingsPage.this.m_originalConfiguration.getRemotePort()));
                    }
                });
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }

    protected final void performDefaults() {
        RemoteConfiguration defaultConfiguration = this.m_remoteSelectionProvider.getDefaultConfiguration();
        this.m_portIncoming.setText(Integer.toString(defaultConfiguration.getServerPort()));
        this.m_portOutgoing.setText(Integer.toString(defaultConfiguration.getRemotePort()));
    }

    @Override
    protected OperationResult getOperationResult() {
        return this.m_operationResult;
    }

    @Override
    protected void cancel() {
        this.reset();
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void reset() {
        this.m_portIncoming.setText(Integer.toString(this.m_originalConfiguration.getServerPort()));
        this.m_portOutgoing.setText(Integer.toString(this.m_originalConfiguration.getRemotePort()));
    }

    @Override
    public void dispose() {
    }

    private void inputModified() {
        boolean isValid;
        this.m_modified = this.m_modifiedPortIncoming != this.m_originalConfiguration.getServerPort() || this.m_modifiedPortOutgoing != this.m_originalConfiguration.getRemotePort();
        boolean bl = isValid = this.m_modifiedPortIncoming > 0 && this.m_modifiedPortOutgoing > 0;
        if (isValid && this.m_modifiedPortIncoming == this.m_modifiedPortOutgoing) {
            isValid = false;
            this.setErrorMessage("Ports must be different");
        } else {
            this.setErrorMessage(null);
        }
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(this.m_modified && isValid);
            this.getCancelButton().setEnabled(this.m_modified);
        }
    }
}

