/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.UpdateAuthorsCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.author.IAuthorsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.StandardCommandInteractionWithResult;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class AuthorsPropertyPage
extends StandardPreferencePage {
    private final List<String> m_currentAuthors = new ArrayList<String>();
    private final Map<String, String> m_currentAliasesToAuthors = new LinkedHashMap<String, String>();
    private final IAuthorsProvider m_provider;
    private final boolean m_isReadOnly;
    private PropertyTableViewer<String> m_authorsViewer;
    private PropertyTableViewer<String> m_aliasesToAuthorsViewer;
    private OperationResult m_result;
    private Button m_addAuthorButton;
    private Button m_editAuthorButton;
    private Button m_deleteAuthorButton;
    private Button m_addAliasButton;
    private Button m_editAliasButton;
    private Button m_deleteAliasButton;

    public AuthorsPropertyPage() {
        SoftwareSystem system = WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem();
        this.m_provider = (IAuthorsProvider)system.getExtension(IAuthorsProvider.class);
        this.m_isReadOnly = !SonargraphCommand.isAvailable((ICommandId)CoreCommandId.APPLY_EDITED_CONFIGURATION, (SoftwareSystem)system);
        this.m_currentAuthors.addAll(this.m_provider.getAuthors());
        this.m_currentAliasesToAuthors.putAll(this.m_provider.getAliasMap());
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.AUTHORS_MANAGEMENT_PROPERTY_PAGE;
    }

    private void dataModified() {
        this.m_authorsViewer.showData(this.m_currentAuthors);
        this.m_aliasesToAuthorsViewer.showData(new ArrayList<String>(this.m_currentAliasesToAuthors.keySet()));
        this.m_addAliasButton.setEnabled(!this.m_isReadOnly && !this.m_currentAuthors.isEmpty());
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createPageContents' must not be null";
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Label info = new Label(container, 64);
        info.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        info.setText("An author name can be used as 'Assignee' in Tasks and Refactorings. Author names are\nused in source file properties if a version control system (e.g. git) is configured.\n\nNOTE: If a version control system is configured, the defined author names are synched with\nthe author names retrieved from the version control system. If a retrieved author name\ncannot be found in the author or alias list, the name will be added to the author list.\nIf an author has several names in the version control system you might consider to create\n1 unique author name (manually) and define aliases for each author name from the version\ncontrol system pointing to that unique author name.\n");
        this.m_authorsViewer = new PropertyTableViewer(container, (BeanPropertyReader.BeanAdapter)new AuthorBeanAdapter(), "author", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 2048);
        this.m_authorsViewer.addColumn("Author", "author", "author", null, 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_authorsViewer.setLayoutData((Object)new GridData(4, 4, true, false));
        if (!this.m_isReadOnly) {
            this.m_authorsViewer.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                    }
                    IStructuredSelection selection = event.getStructuredSelection();
                    int selectionCount = selection.size();
                    AuthorsPropertyPage.this.m_deleteAuthorButton.setEnabled(selectionCount > 0);
                    AuthorsPropertyPage.this.m_editAuthorButton.setEnabled(selectionCount == 1);
                }
            });
        }
        Composite authorButtonRow = new Composite(container, 0);
        authorButtonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        authorButtonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_addAuthorButton = new Button(authorButtonRow, 8);
        this.m_addAuthorButton.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_addAuthorButton.setEnabled(!this.m_isReadOnly);
        this.m_addAuthorButton.setToolTipText("Add a new author");
        if (!this.m_isReadOnly) {
            this.m_addAuthorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AuthorDialog dialog = new AuthorDialog(AuthorsPropertyPage.this.getShell(), null);
                    if (dialog.open() == 0) {
                        AuthorsPropertyPage.this.m_currentAuthors.add(dialog.m_currentAuthorName);
                        AuthorsPropertyPage.this.dataModified();
                    }
                }
            });
        }
        this.m_editAuthorButton = new Button(authorButtonRow, 8);
        this.m_editAuthorButton.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_editAuthorButton.setEnabled(false);
        if (!this.m_isReadOnly) {
            this.m_editAuthorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = AuthorsPropertyPage.this.m_authorsViewer.getSelection();
                    if (!$assertionsDisabled && selection.size() != 1) {
                        throw new AssertionError((Object)"Exactly 1 selected author expected");
                    }
                    Object selectedObject = selection.getFirstElement();
                    if (!($assertionsDisabled || selectedObject != null && selectedObject instanceof String)) {
                        throw new AssertionError((Object)("Unexpected class in method 'widgetSelected': " + String.valueOf(selectedObject)));
                    }
                    AuthorDialog dialog = new AuthorDialog(AuthorsPropertyPage.this.getShell(), selectedObject.toString());
                    if (dialog.open() == 0) {
                        AuthorsPropertyPage.this.m_currentAuthors.remove(selectedObject);
                        AuthorsPropertyPage.this.m_currentAuthors.add(dialog.getAuthorName());
                        ArrayList<String> reAddAliases = new ArrayList<String>();
                        Iterator<Map.Entry<String, String>> iter = AuthorsPropertyPage.this.m_currentAliasesToAuthors.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry<String, String> nextAliasEntry = iter.next();
                            if (!selectedObject.equals(nextAliasEntry.getValue())) continue;
                            reAddAliases.add(nextAliasEntry.getKey());
                            iter.remove();
                        }
                        for (String next : reAddAliases) {
                            AuthorsPropertyPage.this.m_currentAliasesToAuthors.put(next, dialog.getAuthorName());
                        }
                        AuthorsPropertyPage.this.dataModified();
                    }
                }
            });
        }
        this.m_deleteAuthorButton = new Button(authorButtonRow, 8);
        this.m_deleteAuthorButton.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_deleteAuthorButton.setEnabled(false);
        if (!this.m_isReadOnly) {
            this.m_deleteAuthorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = AuthorsPropertyPage.this.m_authorsViewer.getSelection();
                    THashSet removedAuthors = new THashSet();
                    for (Object next : selection.toList()) {
                        if (!($assertionsDisabled || next != null && next instanceof String)) {
                            throw new AssertionError((Object)("Unexpected class in method 'createPageContents': " + String.valueOf(next)));
                        }
                        removedAuthors.add((String)next);
                    }
                    AuthorsPropertyPage.this.m_currentAuthors.removeAll((Collection<?>)removedAuthors);
                    Iterator<Map.Entry<String, String>> iter = AuthorsPropertyPage.this.m_currentAliasesToAuthors.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<String, String> nextAliasEntry = iter.next();
                        if (!removedAuthors.contains(nextAliasEntry.getValue())) continue;
                        iter.remove();
                    }
                    AuthorsPropertyPage.this.dataModified();
                }
            });
        }
        this.m_aliasesToAuthorsViewer = new PropertyTableViewer(container, (BeanPropertyReader.BeanAdapter)new AliasBeanAdapter(), "alias", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 2048);
        this.m_aliasesToAuthorsViewer.addColumn("Alias", "alias", "alias", null, 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_aliasesToAuthorsViewer.addColumn("Author", "author", "author", null, 120, PropertyTableViewer.ColumnType.TEXT);
        this.m_aliasesToAuthorsViewer.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!this.m_isReadOnly) {
            this.m_aliasesToAuthorsViewer.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!$assertionsDisabled && event == null) {
                        throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                    }
                    IStructuredSelection selection = event.getStructuredSelection();
                    int selectionCount = selection.size();
                    AuthorsPropertyPage.this.m_deleteAliasButton.setEnabled(selectionCount > 0);
                    AuthorsPropertyPage.this.m_editAliasButton.setEnabled(selectionCount == 1);
                }
            });
        }
        Composite aliasButtonRow = new Composite(container, 0);
        aliasButtonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        aliasButtonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_addAliasButton = new Button(aliasButtonRow, 8);
        this.m_addAliasButton.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_addAliasButton.setToolTipText("Add a new alias");
        this.m_addAliasButton.setEnabled(false);
        if (!this.m_isReadOnly) {
            this.m_addAliasButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AliasDialog dialog = new AliasDialog(AuthorsPropertyPage.this.getShell(), null, null);
                    if (dialog.open() == 0) {
                        AuthorsPropertyPage.this.m_currentAliasesToAuthors.put(dialog.getAliasName(), dialog.getAuthorName());
                        AuthorsPropertyPage.this.m_currentAuthors.remove(dialog.getAliasName());
                        AuthorsPropertyPage.this.dataModified();
                    }
                }
            });
        }
        this.m_editAliasButton = new Button(aliasButtonRow, 8);
        this.m_editAliasButton.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_editAliasButton.setEnabled(false);
        this.m_editAliasButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = AuthorsPropertyPage.this.m_aliasesToAuthorsViewer.getSelection();
                if (!$assertionsDisabled && selection.size() != 1) {
                    throw new AssertionError((Object)"Exactly 1 selected alias expected");
                }
                Object selectedObject = selection.getFirstElement();
                String selectedAlias = selectedObject.toString();
                if (!($assertionsDisabled || selectedObject != null && selectedObject instanceof String)) {
                    throw new AssertionError((Object)("Unexpected class in method 'widgetSelected': " + String.valueOf(selectedObject)));
                }
                AliasDialog dialog = new AliasDialog(AuthorsPropertyPage.this.getShell(), selectedAlias, AuthorsPropertyPage.this.m_currentAliasesToAuthors.get(selectedAlias));
                if (dialog.open() == 0) {
                    AuthorsPropertyPage.this.m_currentAliasesToAuthors.remove(selectedAlias);
                    AuthorsPropertyPage.this.m_currentAliasesToAuthors.put(dialog.getAliasName(), dialog.getAuthorName());
                    AuthorsPropertyPage.this.dataModified();
                }
            }
        });
        this.m_deleteAliasButton = new Button(aliasButtonRow, 8);
        this.m_deleteAliasButton.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_deleteAliasButton.setEnabled(false);
        if (!this.m_isReadOnly) {
            this.m_deleteAliasButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = AuthorsPropertyPage.this.m_aliasesToAuthorsViewer.getSelection();
                    THashSet removedAliases = new THashSet();
                    for (Object next : selection.toList()) {
                        if (!($assertionsDisabled || next != null && next instanceof String)) {
                            throw new AssertionError((Object)("Unexpected class in method 'createPageContents': " + String.valueOf(next)));
                        }
                        removedAliases.add((String)next);
                    }
                    removedAliases.forEach(a -> {
                        String string = AuthorsPropertyPage.this.m_currentAliasesToAuthors.remove(a);
                    });
                    AuthorsPropertyPage.this.dataModified();
                }
            });
        }
        this.dataModified();
        return container;
    }

    @Override
    protected ISettingsDelta getDelta() {
        return new Delta();
    }

    @Override
    protected OperationResult getOperationResult() {
        return this.m_result;
    }

    @Override
    protected void cancel() {
        this.m_result = null;
    }

    @Override
    protected void internPerformOk() {
        if (this.getDelta().isModified()) {
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)new UpdateAuthorsCommand(WorkbenchRegistry.getInstance().getProvider(), (UpdateAuthorsCommand.IInteraction)new Interaction()));
        }
    }

    private final class AliasBeanAdapter
    extends BeanPropertyReader.BeanAdapter<String> {
        private String m_alias;

        AliasBeanAdapter() {
        }

        protected void setAdaptedObject(String adaptedObject) {
            this.m_alias = adaptedObject;
        }

        public String getAlias() {
            return this.m_alias;
        }

        public String getAuthor() {
            return AuthorsPropertyPage.this.m_currentAliasesToAuthors.get(this.m_alias);
        }
    }

    private final class AliasDialog
    extends StandardDialog {
        private final String m_aliasNameToEdit;
        private final String m_authorNameToEdit;
        private ValidatingTextWidget m_aliasNameWidget;
        private String m_currentAliasName;
        private String m_currentAuthorName;
        private Combo m_availableAuthors;

        private AliasDialog(Shell shell, String aliasNameToEdit, String authorNameToEdit) {
            super(shell, aliasNameToEdit == null ? "Add Alias" : "Edit Alias");
            assert (aliasNameToEdit == null && authorNameToEdit == null || !aliasNameToEdit.isEmpty() && !authorNameToEdit.isEmpty());
            this.m_aliasNameToEdit = aliasNameToEdit;
            this.m_authorNameToEdit = authorNameToEdit;
        }

        protected int getNumberOfColumns() {
            return 2;
        }

        protected void fillDialogArea(Composite composite) {
            assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
            ArrayList<String> existingNames = new ArrayList<String>(AuthorsPropertyPage.this.m_currentAliasesToAuthors.keySet());
            if (this.m_aliasNameToEdit != null) {
                existingNames.remove(this.m_aliasNameToEdit);
            }
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText("Alias:");
            this.m_aliasNameWidget = new ValidatingTextWidget(composite, AuthorsPropertyPage.this.m_provider.getAliasNameValidator(existingNames), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                    AliasDialog.this.m_currentAliasName = text;
                    AliasDialog.this.getButton(0).setEnabled(AliasDialog.this.hasValidData());
                }
            }, this.m_aliasNameToEdit, 0);
            this.m_aliasNameWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.m_currentAliasName = this.m_aliasNameToEdit;
            Label authorLabel = new Label(composite, 0);
            authorLabel.setText("Author:");
            this.m_availableAuthors = new Combo(composite, 8);
            this.m_availableAuthors.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ArrayList<String> sortedAvailableAuthors = new ArrayList<String>(AuthorsPropertyPage.this.m_currentAuthors);
            Collections.sort(sortedAvailableAuthors);
            sortedAvailableAuthors.forEach(a -> this.m_availableAuthors.add(a));
            this.m_availableAuthors.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AliasDialog.this.m_currentAuthorName = AliasDialog.this.m_availableAuthors.getItem(AliasDialog.this.m_availableAuthors.getSelectionIndex());
                    AliasDialog.this.getButton(0).setEnabled(AliasDialog.this.hasValidData());
                }
            });
            if (this.m_authorNameToEdit != null) {
                this.m_availableAuthors.select(this.m_availableAuthors.indexOf(this.m_authorNameToEdit));
                this.m_currentAuthorName = this.m_authorNameToEdit;
            } else {
                this.m_availableAuthors.select(0);
                this.m_currentAuthorName = this.m_availableAuthors.getItem(0);
            }
        }

        public boolean hasValidData() {
            return this.m_currentAliasName != null && !this.m_currentAliasName.isEmpty() && this.m_currentAuthorName != null && !this.m_currentAuthorName.isEmpty() && (this.m_aliasNameToEdit == null && this.m_authorNameToEdit == null || !this.m_aliasNameToEdit.equals(this.m_currentAliasName) || !this.m_authorNameToEdit.equals(this.m_currentAuthorName));
        }

        String getAliasName() {
            assert (this.m_currentAliasName != null && this.m_currentAliasName.length() > 0) : "'m_currentAliasName' of method 'getAliasName' must not be empty";
            return this.m_currentAliasName;
        }

        String getAuthorName() {
            assert (this.m_currentAuthorName != null && this.m_currentAuthorName.length() > 0) : "'m_currentAuthorName' of method 'getAuthorName' must not be empty";
            return this.m_currentAuthorName;
        }
    }

    private final class AuthorBeanAdapter
    extends BeanPropertyReader.BeanAdapter<String> {
        private String m_author;

        AuthorBeanAdapter() {
        }

        protected void setAdaptedObject(String adaptedObject) {
            this.m_author = adaptedObject;
        }

        public String getAuthor() {
            return this.m_author;
        }
    }

    private final class AuthorDialog
    extends StandardDialog {
        private final String m_authorNameToEdit;
        private ValidatingTextWidget m_authorNameWidget;
        private String m_currentAuthorName;

        private AuthorDialog(Shell shell, String nameToEdit) {
            super(shell, nameToEdit == null ? "Add Author" : "Edit Author");
            assert (nameToEdit == null || !nameToEdit.isEmpty());
            this.m_authorNameToEdit = nameToEdit;
        }

        protected int getNumberOfColumns() {
            return 2;
        }

        protected void fillDialogArea(Composite composite) {
            ArrayList<String> existingNames = new ArrayList<String>(AuthorsPropertyPage.this.m_currentAuthors);
            if (this.m_authorNameToEdit != null) {
                existingNames.remove(this.m_authorNameToEdit);
            }
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText("Author:");
            this.m_authorNameWidget = new ValidatingTextWidget(composite, AuthorsPropertyPage.this.m_provider.getAuthorNameValidator(existingNames), new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                    AuthorDialog.this.m_currentAuthorName = text;
                    AuthorDialog.this.getButton(0).setEnabled(AuthorDialog.this.hasValidData());
                }
            }, this.m_authorNameToEdit, 0);
            this.m_authorNameWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.m_currentAuthorName = this.m_authorNameToEdit;
        }

        public boolean hasValidData() {
            return this.m_currentAuthorName != null && !this.m_currentAuthorName.isEmpty() && (this.m_authorNameToEdit == null || !this.m_authorNameToEdit.equals(this.m_currentAuthorName));
        }

        String getAuthorName() {
            assert (this.m_currentAuthorName != null && this.m_currentAuthorName.length() > 0) : "'m_currentAuthorName' of method 'getAuthorName' must not be empty";
            return this.m_currentAuthorName;
        }
    }

    private final class Delta
    implements ISettingsDelta {
        Delta() {
        }

        public boolean isModified() {
            if (!AuthorsPropertyPage.this.m_provider.getAuthors().equals(AuthorsPropertyPage.this.m_currentAuthors)) {
                return true;
            }
            return !AuthorsPropertyPage.this.m_currentAliasesToAuthors.equals(AuthorsPropertyPage.this.m_provider.getAliasMap());
        }

        public void reset() {
            AuthorsPropertyPage.this.cancel();
        }

        public void dispose() {
        }
    }

    private final class Interaction
    extends StandardCommandInteractionWithResult
    implements UpdateAuthorsCommand.IInteraction {
        Interaction() {
        }

        public boolean collect(UpdateAuthorsCommand.UpdateAuthorsData data) {
            data.setData(AuthorsPropertyPage.this.m_currentAliasesToAuthors, AuthorsPropertyPage.this.m_currentAuthors);
            return true;
        }

        @Override
        public void processResult(OperationResult result) {
            AuthorsPropertyPage.this.m_result = result;
            super.processResult(result);
        }
    }
}

