/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.searchview;

import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class SearchDialog<T>
extends StandardDialog
implements SelectionListener,
ModifyListener,
VerifyListener,
KeyListener,
ISelectionChangedListener,
IDoubleClickListener {
    private final ISoftwareSystemProvider m_softwareSystemProvider;
    private final List<T> m_selected = new ArrayList<T>();
    private CancellableWorkerContext m_currentWorkerContext = new CancellableWorkerContext();
    private SonargraphCommand m_currentCommand;

    public SearchDialog(Shell parentShell, String title, ISoftwareSystemProvider softwareSystemProvider) {
        super(parentShell, title);
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'SearchDialog' must not be null";
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x4F0);
        this.m_softwareSystemProvider = softwareSystemProvider;
    }

    protected final Point getPreferredSize() {
        return new Point(800, 600);
    }

    protected final ISoftwareSystemProvider getSoftwareSystemProvider() {
        return this.m_softwareSystemProvider;
    }

    protected abstract Text getSearchPatternText();

    protected abstract PropertyTableViewer<T> getMatchingElementsViewer();

    protected abstract void validateSearchPattern();

    protected final GridLayout createGridLayout() {
        GridLayout gridLayout = new GridLayout(this.getNumberOfColumns(), false);
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 4;
        return gridLayout;
    }

    protected final GridLayout createGridLayout(int columns) {
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public final void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        String pattern = this.getSearchPatternText().getText();
        if (pattern != null && pattern.length() > 0) {
            this.getSearchPatternText().setText(pattern);
        }
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public final void modifyText(ModifyEvent event) {
        this.validateSearchPattern();
    }

    protected final void cancelSearch() {
        if (this.m_currentWorkerContext != null) {
            this.m_currentWorkerContext.cancel();
            this.m_currentWorkerContext = new CancellableWorkerContext();
            this.m_currentCommand = null;
        }
    }

    protected final IWorkerContext getCurrentWorkerContext(SonargraphCommand command) {
        assert (command != null) : "Parameter 'command' of method 'getCurrentWorkerContext' must not be null";
        assert (this.m_currentWorkerContext != null) : "Parameter 'm_currentWorkerContext' of method 'getCurrentWorkerContext' must not be null";
        this.m_currentCommand = command;
        return this.m_currentWorkerContext;
    }

    protected final SonargraphCommand getCurrentCommand() {
        return this.m_currentCommand;
    }

    public final void verifyText(VerifyEvent event) {
        this.cancelSearch();
    }

    public final void keyPressed(KeyEvent event) {
        assert (event != null) : "Parameter 'event' of method 'keyPressed' must not be null";
        if (event.keyCode == 0x1000001) {
            Object first;
            IStructuredSelection selection;
            Object firstSelected;
            if (event.getSource() == this.getMatchingElementsViewer().getTable() && (firstSelected = (selection = this.getMatchingElementsViewer().getSelection()).getFirstElement()) != null && firstSelected == (first = this.getMatchingElementsViewer().getFirstVisibleEntry())) {
                int length = this.getSearchPatternText().getText().length();
                if (length > 0) {
                    this.getSearchPatternText().setSelection(length);
                }
                this.getSearchPatternText().setFocus();
            }
        } else if (event.keyCode == 0x1000002 && event.getSource() == this.getSearchPatternText()) {
            this.getMatchingElementsViewer().setFocus();
        }
    }

    public final void keyReleased(KeyEvent event) {
    }

    private void updateSelection(IStructuredSelection structuredSelection) {
        assert (structuredSelection != null) : "Parameter 'structuredSelection' of method 'updateSelection' must not be null";
        this.m_selected.clear();
        for (Object next : structuredSelection.toList()) {
            this.m_selected.add(next);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.updateSelection((IStructuredSelection)event.getSelection());
        this.getButton(0).setEnabled(!this.m_selected.isEmpty());
    }

    public final void doubleClick(DoubleClickEvent event) {
        assert (event != null) : "'event' must not be null";
        assert (!event.getSelection().isEmpty()) : "Selection must not be empty";
        this.updateSelection((IStructuredSelection)event.getSelection());
        if (this.m_selected.isEmpty()) {
            this.cancelPressed();
        } else {
            this.okPressed();
        }
    }

    public final List<T> getSelected() {
        return this.m_selected;
    }

    public final boolean hasValidData() {
        return true;
    }
}

