/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview.preview;

import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricIdNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricValueTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptNamedTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class PreviewMetricRecord {
    private final Number m_value;
    private final Element m_element;
    private final IScriptMetricId m_metricId;
    private final IMetricLevel m_level;

    public PreviewMetricRecord(IScriptMetricId metricId, IMetricLevel level, Element element, Number value) {
        assert (metricId != null) : "Parameter 'metricId' of method 'PreviewMetricRecord' must not be null";
        assert (level != null) : "Parameter 'level' of method 'PreviewMetricRecord' must not be null";
        assert (element != null) : "Parameter 'element' of method 'PreviewMetricRecord' must not be null";
        assert (value != null) : "Parameter 'value' of method 'PreviewMetricRecord' must not be null";
        this.m_metricId = metricId;
        this.m_level = level;
        this.m_element = element;
        this.m_value = value;
    }

    public Element getElement() {
        return this.m_element;
    }

    public IScriptMetricId getId() {
        return this.m_metricId;
    }

    public IMetricLevel getLevel() {
        return this.m_level;
    }

    public Number getValue() {
        return this.m_value;
    }

    public static List<PreviewMetricRecord> convertToList(ScriptNamedTreeNode metricRootNode) {
        assert (metricRootNode != null) : "Parameter 'metricRootNode' of method 'convertToList' must not be null";
        ArrayList<PreviewMetricRecord> records = new ArrayList<PreviewMetricRecord>();
        for (ScriptTreeNode nextId : metricRootNode.getChildren()) {
            assert (nextId instanceof ScriptMetricIdNode) : "Unexpected class " + nextId.getClass().getCanonicalName();
            ScriptMetricIdNode id = (ScriptMetricIdNode)nextId;
            for (ScriptTreeNode nextValue : id.getChildren()) {
                assert (nextValue instanceof ScriptMetricValueTreeNode) : "Unexpected class " + nextValue.getClass().getCanonicalName();
                ScriptMetricValueTreeNode value = (ScriptMetricValueTreeNode)nextValue;
                records.add(new PreviewMetricRecord(id.getId(), value.getLevel(), (Element)value.getElement(), value.getValue()));
            }
        }
        Collections.sort(records, new Comparator<PreviewMetricRecord>(){

            @Override
            public int compare(PreviewMetricRecord r1, PreviewMetricRecord r2) {
                int idCompare = r1.getId().getSorting().compareTo((Enum)r2.getId().getSorting());
                if (idCompare != 0) {
                    return idCompare;
                }
                int levelCompare = Integer.compare(r1.getLevel().getOrderNumber(), r2.getLevel().getOrderNumber());
                if (levelCompare != 0) {
                    return levelCompare;
                }
                int valueCompare = Float.compare(r1.getValue().floatValue(), r2.getValue().floatValue());
                if (valueCompare != 0) {
                    return valueCompare * -1;
                }
                return r1.getElement().getPresentationName(false).compareTo(r2.getElement().getPresentationName(false));
            }
        });
        return records;
    }
}

