/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.EditableModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.EditableSourceViewWidget;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class ScriptSourceViewWidget
extends EditableSourceViewWidget {
    public ScriptSourceViewWidget(Composite parent, boolean isReadOnly, IOriginator modificationTrigger) {
        super(parent, isReadOnly, modificationTrigger);
    }

    @Override
    protected void calculateStyleRangesForSyntaxHighlighting(String content, IFileType fileType) {
        assert (content != null) : "Parameter 'content' of method 'performSyntaxHighlighting' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'performSyntaxHighlighting' must not be null";
        ((IGroovyProvider)softwareSystem.getExtension(IGroovyProvider.class)).accept((ISourceFileRegionVisitor)this, content, fileType);
    }

    public Point getLocationAtOffset() {
        StyledText source = this.getSourceWidget();
        Point absolutePoint = this.getDisplay().map((Control)this, null, source.getLocation());
        Point relativePoint = source.getLocationAtOffset(source.getCaretOffset());
        return new Point(relativePoint.x + absolutePoint.x, relativePoint.y + absolutePoint.y);
    }

    @Override
    protected IFormatter getFormatter(FormatterOptions options) {
        assert (options != null) : "Parameter 'options' of method 'getFormatter' must not be null";
        SoftwareSystem system = this.getSoftwareSystem();
        assert (system != null) : "Parameter 'system' of method 'getFormatter' must not be null";
        return ((IGroovyProvider)system.getExtension(IGroovyProvider.class)).getFormatter(options);
    }

    @Override
    protected void modified(EditableModifiableFile sourceFile) {
        assert (sourceFile != null && sourceFile instanceof GroovyScript) : "Unexpected class in method 'modified': " + String.valueOf(sourceFile);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'calculateStyleRangesForSyntaxHighlighting' must not be null";
        ((IGroovyProvider)softwareSystem.getExtension(IGroovyProvider.class)).modifyScriptSource((GroovyScript)sourceFile, this.getText(), this.getOriginator());
    }

    @Override
    protected IUndoRedoEntry createUndoRedoEntry() {
        final FilePath sourceFile = this.getSourceFile();
        assert (sourceFile != null && sourceFile instanceof GroovyScript) : "Unexpected class in method 'createUndoRedoEntry': " + String.valueOf(sourceFile);
        return new IUndoRedoEntry(){

            public String getIdentifyingPath() {
                return sourceFile.getIdentifyingPath();
            }

            public String getCommandName() {
                return "Modify script source";
            }

            public Class<? extends IModifiableFile> getClazz() {
                return GroovyScript.class;
            }
        };
    }
}

