/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.programming.ConditionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.ResolutionBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.MatchingElementsBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ResolutionsView<T extends Resolution>
extends WorkbenchSlaveView
implements ISelectionChangedListener {
    private static final String MATCHING_ELEMENTS_FIRST_COLUMN = "Matching Element Type";
    private static final String SHOW_ALL_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showAll";
    private static final String SHOW_ONLY_WITH_MATCHING_ELEMETS_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyWithMatchingElements";
    private static final String SHOW_ONLY_WITHOUT_MATCHING_ELEMETS_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.showOnlyWithoutMatchingElements";
    private final Predicate<Resolution> m_ignoreCondition = resolution -> !this.getRelevantClassForResolutions().isAssignableFrom(resolution.getClass());
    private final Predicate<Resolution> m_allResolutionsCondition = resolution -> this.getRelevantClassForResolutions().isAssignableFrom(resolution.getClass());
    private final Predicate<Resolution> m_withMatchingElementsConditions = resolution -> this.getRelevantClassForResolutions().isAssignableFrom(resolution.getClass()) && resolution.getMatchingElementsCount() > 0;
    private final Predicate<Resolution> m_withoutMatchingElementsCondition = resolution -> this.getRelevantClassForResolutions().isAssignableFrom(resolution.getClass()) && resolution.getMatchingElementsCount() == 0;
    private PropertyTableViewer<Resolution> m_resolutionsTable;
    private PropertyTableViewer<IIssue> m_matchingElementsTable;
    private Component m_selectedComponent = Component.RESOLUTIONS;
    private PropertyTableViewerBasedTextSearchHandler m_resolutionsTextSearchHandler;
    private PropertyTableViewerBasedTextSearchHandler m_matchingElementsTextSearchHandler;
    private MHandledMenuItem m_showAllItem;
    private MHandledMenuItem m_showOnlyWithMatchingElementsItem;
    private MHandledMenuItem m_showOnlyWithoutMatchingElementsItem;
    private ConditionFilter<Resolution> m_filter;
    private FilterMode m_filterMode;

    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    public final boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_resolutionsTable != null && !this.m_resolutionsTable.isDisposed() && !this.m_resolutionsTable.getFilteredInputData().isEmpty();
    }

    protected final Collection<T> getResolutionsToExport() {
        return this.m_resolutionsTable.getFilteredInputData();
    }

    protected final void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.m_resolutionsTable = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new ResolutionBeanAdapter(), "dateForSort", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_resolutionsTable.addColumn("Model", "virtualModel", "virtualModel", "virtualModelImage", 20, PropertyTableViewer.ColumnType.TEXT);
        this.addResolutionTableColumns(this.m_resolutionsTable);
        this.m_matchingElementsTable = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new MatchingElementsBeanAdapter(), "element", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_matchingElementsTable.addColumn(MATCHING_ELEMENTS_FIRST_COLUMN, "elementType", "elementType", "elementTypeImage", 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElementsTable.addColumn("Element", "element", "element", "elementImage", 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElementsTable.addColumn("Element To", "elementTo", "elementTo", "elementToImage", 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_matchingElementsTable.addColumn("Description", "description", "description", null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_resolutionsTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_resolutionsTable, this.getViewId().getPresentationName());
        this.m_matchingElementsTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_matchingElementsTable, this.getViewId().getPresentationName());
        sashForm.setWeights(new int[]{75, 25});
        this.m_showAllItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)SHOW_ALL_TOOLITEM_ID, MHandledMenuItem.class);
        assert (this.m_showAllItem != null) : "'m_showAllItem' of method 'createViewContent' must not be null";
        this.m_showOnlyWithMatchingElementsItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)SHOW_ONLY_WITH_MATCHING_ELEMETS_TOOLITEM_ID, MHandledMenuItem.class);
        assert (this.m_showOnlyWithMatchingElementsItem != null) : "'m_showOnlyWithMatchingElementsItem' of method 'createViewContent' must not be null";
        this.m_showOnlyWithoutMatchingElementsItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)SHOW_ONLY_WITHOUT_MATCHING_ELEMETS_TOOLITEM_ID, MHandledMenuItem.class);
        assert (this.m_showOnlyWithoutMatchingElementsItem != null) : "'m_showOnlyWithoutMatchingElementsItem' of method 'createViewContent' must not be null";
        this.m_filter = new ConditionFilter();
        this.m_filter.addIgnore(this.m_ignoreCondition);
        this.updateViewOptions();
    }

    public final List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_resolutionsTable.getTable(), this.m_matchingElementsTable.getTable());
    }

    private void addListeners() {
        this.m_resolutionsTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElementsTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        this.m_resolutionsTable.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_matchingElementsTable.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public final List<Control> getViewComponents() {
        return Arrays.asList(this.m_resolutionsTable.getTable(), this.m_matchingElementsTable.getTable());
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_resolutionsTable.getTable()) {
            this.m_selectedComponent = Component.RESOLUTIONS;
            this.m_resolutionsTable.getTable().setFocus();
        } else if (component == this.m_matchingElementsTable.getTable()) {
            this.m_selectedComponent = Component.MATCHING_ELEMENTS;
            this.m_matchingElementsTable.setFocus();
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    public final Control getSelectedViewComponent() {
        switch (this.m_selectedComponent) {
            case RESOLUTIONS: {
                return this.m_resolutionsTable.getTable();
            }
            case MATCHING_ELEMENTS: {
                return this.m_matchingElementsTable.getTable();
            }
        }
        assert (false) : "Unhandled component: " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    public final void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        this.removeListeners();
        for (Element element : elements) {
            assert (element instanceof Resolution) : "Unexpected class in method 'finishShowInView': " + String.valueOf(element);
            if (this.m_filter.accept((Element)((Resolution)element))) continue;
            this.m_filter.clear(false);
            this.m_filter.add(this.m_allResolutionsCondition);
            this.show(false, false);
            break;
        }
        StructuredSelection selection = new StructuredSelection(elements);
        this.m_resolutionsTable.getTableViewer().setSelection((ISelection)selection, true);
        this.syncMatchingElements((IStructuredSelection)selection);
        this.addListeners();
        super.finishShowInView(sourceViewId, elements, options);
    }

    public final List<Element> getSelectedElements() {
        return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)(switch (this.m_selectedComponent) {
            case Component.RESOLUTIONS -> this.m_resolutionsTable.getSelection();
            case Component.MATCHING_ELEMENTS -> this.m_matchingElementsTable.getSelection();
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled section: " + String.valueOf((Object)this.m_selectedComponent)));
                }
                yield null;
            }
        }));
    }

    public final NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        return element instanceof Dependency ? ((Dependency)element).getUnderlyingFrom() : super.getLinkNamedElement(element);
    }

    public void viewOptionsChanged() {
        this.updateViewOptions();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.VIEW_OPTIONS_CHANGED);
        this.createNavigationState(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    private void updateViewOptions() {
        this.m_filter.clear(false);
        if (this.m_showAllItem.isSelected()) {
            this.m_filterMode = FilterMode.SHOW_ALL;
            this.m_filter.add(this.m_allResolutionsCondition);
        } else if (this.m_showOnlyWithMatchingElementsItem.isSelected()) {
            this.m_filterMode = FilterMode.ONLY_WITH_MATCHING_ELEMENTS;
            this.m_filter.add(this.m_withMatchingElementsConditions);
        } else {
            assert (this.m_showOnlyWithoutMatchingElementsItem.isSelected()) : "No handled item selected in radio button group";
            this.m_filterMode = FilterMode.ONLY_WITHOUT_MATCHING_ELEMENTS;
            this.m_filter.add(this.m_withoutMatchingElementsCondition);
        }
        if (this.getSoftwareSystemProvider().hasSoftwareSystem()) {
            this.removeListeners();
            this.show(true, false);
            this.addListeners();
        }
    }

    private void createNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        List<Element> selected = this.getSelectedElements();
        switch (this.m_selectedComponent) {
            case RESOLUTIONS: {
                state.addElementsInformation((IElementGroup)ElementGroup.SELECTION, NavigationState.getDescriptors(selected, (IElementResolver)this.getElementResolver()));
                break;
            }
            case MATCHING_ELEMENTS: {
                state.addElementsInformation((IElementGroup)ElementGroup.SELECTION, NavigationState.getDescriptors(selected, (IElementResolver)this.getElementResolver()));
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedComponent);
                break;
            }
        }
        state.addConstant((IStateData)ViewData.TAB, (Enum)this.m_selectedComponent);
        assert (this.m_filterMode != null) : "'m_filterMode' of method 'createNavigationState' must not be null";
        state.addConstant((IStateData)ViewData.FILTER_MODE, (Enum)this.m_filterMode);
    }

    private void updateFilterRadioButtonsInViewMenu(FilterMode filterMode) {
        assert (filterMode != null) : "Parameter 'filterMode' of method 'updateFilterRadioButtonsInViewMenu' must not be null";
        this.m_showAllItem.setSelected(filterMode == FilterMode.SHOW_ALL);
        this.m_showOnlyWithMatchingElementsItem.setSelected(filterMode == FilterMode.ONLY_WITH_MATCHING_ELEMENTS);
        this.m_showOnlyWithoutMatchingElementsItem.setSelected(filterMode == FilterMode.ONLY_WITHOUT_MATCHING_ELEMENTS);
    }

    private void restoreElementSelection(NavigationState state, boolean notifySelectionChange) {
        assert (state != null) : "Parameter 'state' of method 'restoreElementSelection' must not be null";
        this.m_selectedComponent = (Component)state.getConstant((IStateData)ViewData.TAB);
        assert (this.m_selectedComponent != null) : "'m_selectedComponent' of method 'restoreElementSelection' must not be null";
        List lastSelected = state.getElements((IElementGroup)ElementGroup.SELECTION, Element.class, this.getElementResolver());
        StructuredSelection selection = new StructuredSelection(lastSelected.toArray());
        switch (this.m_selectedComponent) {
            case RESOLUTIONS: {
                this.m_resolutionsTable.getTableViewer().setSelection((ISelection)selection, true);
                this.syncMatchingElements((IStructuredSelection)selection);
                break;
            }
            case MATCHING_ELEMENTS: {
                this.m_matchingElementsTable.getTableViewer().setSelection((ISelection)selection, true);
                break;
            }
            default: {
                assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedComponent);
                break;
            }
        }
        if (notifySelectionChange) {
            this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)selection);
        }
    }

    protected final void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.removeListeners();
        this.m_resolutionsTable.getTable().setRedraw(false);
        this.m_matchingElementsTable.getTable().setRedraw(false);
        FilterMode filterModeFromNavigation = (FilterMode)state.getConstant((IStateData)ViewData.FILTER_MODE);
        assert (filterModeFromNavigation != null) : "'filterModeFromNavigation' of method 'restoreNavigationState' must not be null";
        if (filterModeFromNavigation != this.m_filterMode) {
            this.updateFilterRadioButtonsInViewMenu(filterModeFromNavigation);
            this.updateViewOptions();
        }
        this.restoreElementSelection(state, false);
        this.m_resolutionsTable.getTable().setRedraw(true);
        this.m_matchingElementsTable.getTable().setRedraw(true);
        this.addListeners();
    }

    public final void completeViewNavigationState(NavigationState state) {
        this.createNavigationState(state);
    }

    private void syncMatchingElements(IStructuredSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'syncMatchingElements' must not be null";
        List associatedIssues = null;
        if (selection.size() == 1) {
            Object resolution = selection.getFirstElement();
            assert (resolution instanceof Resolution) : "Unexpected class: " + String.valueOf(resolution);
            associatedIssues = ((Resolution)resolution).getAssociatedIssues();
        } else {
            associatedIssues = Collections.emptyList();
        }
        this.m_matchingElementsTable.setRedraw(false);
        this.m_matchingElementsTable.showData((Collection)associatedIssues);
        this.m_matchingElementsTable.setRedraw(true);
    }

    private void show(boolean restoreNavigationState, boolean notifySelectionChange) {
        assert (this.m_resolutionsTable != null) : "'m_ignoredElementsTable' of method 'show' must not be null";
        this.m_resolutionsTable.setRedraw(false);
        this.m_matchingElementsTable.setRedraw(false);
        this.m_matchingElementsTable.showData(null);
        this.m_filter.resetHasFiltered();
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null) {
            NavigationState state;
            List resolutions = softwareSystem.getCurrentModel().getResolutions(this.getRelevantClassForResolutions());
            if (resolutions.isEmpty()) {
                this.m_resolutionsTable.showData((Collection)resolutions);
            } else {
                ArrayList<Resolution> filteredResolutions = new ArrayList<Resolution>();
                for (Resolution resolution : resolutions) {
                    if (!this.m_filter.accept((Element)resolution)) continue;
                    filteredResolutions.add(resolution);
                }
                this.m_resolutionsTable.showData(filteredResolutions);
            }
            if (restoreNavigationState && (state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
                this.restoreElementSelection(state, notifySelectionChange);
            }
        } else {
            this.m_resolutionsTable.showData(null);
        }
        if (this.m_filter.hasFiltered()) {
            this.m_resolutionsTable.getTable().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
        } else {
            this.m_resolutionsTable.getTable().setBackground(UiResourceManager.getInstance().getBackgroundColor());
        }
        this.m_resolutionsTable.setRedraw(true);
        this.m_matchingElementsTable.setRedraw(true);
    }

    protected final void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.removeListeners();
        this.show(mode == WorkbenchView.ShowMode.AWAKE, false);
        this.addListeners();
        super.softwareSystemShow(mode);
    }

    protected final void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED) || modification.contains(Modification.VIRTUAL_MODEL_MODIFIED)) {
            this.removeListeners();
            this.show(true, false);
            this.addListeners();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected final void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.ISSUE_MODIFIED)) {
            this.removeListeners();
            this.show(true, false);
            this.addListeners();
        }
        super.analyzerModification(modification, analyzerId);
    }

    protected final void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.m_resolutionsTable.setRedraw(false);
        this.m_matchingElementsTable.setRedraw(false);
        this.m_matchingElementsTable.showData(null);
        this.m_resolutionsTable.showData(null);
        this.m_filter.resetHasFiltered();
        this.m_resolutionsTable.setRedraw(true);
        this.m_matchingElementsTable.setRedraw(true);
        this.addListeners();
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        if (event.getSource() == this.m_resolutionsTable.getTableViewer()) {
            assert (this.m_selectedComponent == Component.RESOLUTIONS) : "Wrong section: " + String.valueOf((Object)this.m_selectedComponent);
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.syncMatchingElements(selection);
            this.getSelectionProviderAdapter().handleSelectionChanged(selection);
        } else if (event.getSource() == this.m_matchingElementsTable.getTableViewer()) {
            assert (this.m_selectedComponent == Component.MATCHING_ELEMENTS) : "Wrong section: " + String.valueOf((Object)this.m_selectedComponent);
            ArrayList<Element> selectElements = new ArrayList<Element>();
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            for (Object next : selection.toList()) {
                assert (next instanceof IIssue) : "Unexpected class: " + String.valueOf(next);
                IIssue nextIIssueAccessor = (IIssue)next;
                selectElements.add(nextIIssueAccessor.getAffectedElement());
            }
            this.getSelectionProviderAdapter().handleSelectionChanged(selectElements);
        } else assert (false) : "Unexpected source: " + String.valueOf(event.getSource());
        this.initializeTextSearchData();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.addListeners();
    }

    public final void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_resolutionsTable.getTable()) {
            this.m_resolutionsTable.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_matchingElementsTable.getTable()) {
            this.m_matchingElementsTable.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public final boolean supportsCopy() {
        return !this.getSelectedElements().isEmpty();
    }

    public final String copy() {
        switch (this.m_selectedComponent) {
            case RESOLUTIONS: {
                return this.m_resolutionsTable.getCopyToClipboardData();
            }
            case MATCHING_ELEMENTS: {
                return this.m_matchingElementsTable.getCopyToClipboardData();
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedComponent);
        return "";
    }

    public final Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected final ITextSearchHandler getTextSearchHandler() {
        switch (this.m_selectedComponent) {
            case RESOLUTIONS: {
                return this.m_resolutionsTextSearchHandler;
            }
            case MATCHING_ELEMENTS: {
                return this.m_matchingElementsTextSearchHandler;
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedComponent);
        return null;
    }

    protected abstract void addResolutionTableColumns(PropertyTableViewer<Resolution> var1);

    protected abstract Class<T> getRelevantClassForResolutions();

    private static enum Component implements IStandardEnumeration
    {
        RESOLUTIONS,
        MATCHING_ELEMENTS;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum FilterMode implements IStandardEnumeration
    {
        SHOW_ALL,
        ONLY_WITH_MATCHING_ELEMENTS,
        ONLY_WITHOUT_MATCHING_ELEMENTS;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ViewData implements IStateData
    {
        FILTER_MODE,
        TAB;

    }
}

