/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentIssueQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.ThresholdIssueQualityGateCondition;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.AbstractQualityGateIssueElementWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class CurrentConditionWizardPage
extends AbstractQualityGateIssueElementWizardPage {
    private ValidatingTextWidget m_limitText;
    private int m_limit = 0;
    private int m_originalLimit;
    private Operator m_operator = Operator.LESS_OR_EQUAL;
    private Operator m_originalOperator;

    public CurrentConditionWizardPage(String name, IQualityGateProvider qualityGateProvider, List<String> availableIssueTypes, List<String> availableMetricIds) {
        super(name, "Quality Gate Condition", qualityGateProvider, availableIssueTypes, availableMetricIds);
    }

    public CurrentConditionWizardPage(String name, IQualityGateProvider qualityGateProvider, List<String> availableIssueTypes, List<String> availableMetricIds, String issueType, List<String> severities, List<String> resolutions, Operator operator, int limit, String metricId) {
        super(name, "Quality Gate Condition", qualityGateProvider, availableIssueTypes, availableMetricIds, issueType, severities, resolutions, metricId);
        this.m_operator = operator;
        this.m_originalOperator = operator;
        this.m_limit = limit;
        this.m_originalLimit = limit;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.QUALITY_GATE_CURRENT_CONDITION_WIZARD_PAGE;
    }

    @Override
    protected boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        return this.m_operator != this.m_originalOperator || this.m_limit != this.m_originalLimit;
    }

    @Override
    protected void createContent(Composite composite) {
        this.createStandardInputWidgets(composite);
        Label countLabel = new Label(composite, 0);
        countLabel.setText("Upper Limit:");
        countLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final CountValidator validator = new CountValidator();
        this.m_limitText = new ValidatingTextWidget(composite, (ITextValidator)validator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                CurrentConditionWizardPage.this.m_limit = input != null && validator.getLastResult().isSuccess() ? Integer.parseInt(input) : -1;
                CurrentConditionWizardPage.this.validateInput();
            }
        }, "" + this.m_limit, 16384);
        this.m_limitText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createMetricIdWidgets(composite, "Metric ID:");
        this.createInfoWidget(composite);
        if (this.isEdit()) {
            this.triggerIssueTypeValidation();
        }
        this.finishCreateContent();
    }

    @Override
    protected boolean validateInputFields() {
        if (this.getIssueType() == null || this.m_limit < 0 || this.getMetricId().trim().length() == 0) {
            this.setInfoText("");
            return false;
        }
        ArrayList<String> infoLines = new ArrayList<String>();
        boolean isValid = this.validateSeverity(infoLines);
        boolean bl = isValid = this.validateResolution(infoLines) && isValid;
        if (!isValid) {
            this.setInfoText(infoLines.stream().collect(Collectors.joining("\n")));
        } else if (this.isThresholdCondition()) {
            this.setInfoText(ThresholdIssueQualityGateCondition.createPresentationNameLong((String)this.getIssueType(), this.getSeverities(), this.getResolutions(), (Operator)this.m_operator, (int)this.m_limit, (String)this.getMetricId()));
        } else {
            this.setInfoText(CurrentIssueQualityGateCondition.createPresentationNameLong((String)this.getIssueType(), this.getSeverities(), this.getResolutions(), (Operator)this.m_operator, (int)this.m_limit));
        }
        return isValid;
    }

    @Override
    boolean isThresholdCondition() {
        return CurrentIssueQualityGateCondition.isMetricInfoRelevant((String)this.getIssueType(), (String)this.getMetricId());
    }

    Operator getOperator() {
        return this.m_operator;
    }

    public int getLimit() {
        return this.m_limit;
    }

    private class CountValidator
    implements ITextValidator {
        private ValidationResult m_lastResult;

        private CountValidator() {
        }

        public ValidationResult isValid(String initialInput, String newInput) {
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
            try {
                int count = Integer.parseInt(newInput.trim());
                if (count < 0) {
                    result.addError("Upper limit must be >= 0");
                }
            }
            catch (NumberFormatException ex) {
                result.addError("Upper limit must be an integer value >= 0");
            }
            this.m_lastResult = result;
            return result;
        }

        public ValidationResult getLastResult() {
            return this.m_lastResult;
        }
    }
}

