/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.MetricValueDiffQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.Operator;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.MapBackedCombo;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.AbstractQualityGateElementWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class BaselineMetricConditionWizardPage
extends AbstractQualityGateElementWizardPage {
    private MapBackedCombo<Operator> m_operatorCombo;
    private Operator m_operator = Operator.LESS_OR_EQUAL;
    private Operator m_originalOperator;
    private Button m_absoluteThresholdButton;
    private ValidatingTextWidget m_absoluteThresholdText;
    private Float m_absoluteThreshold;
    private Float m_originalAbsoluteThreshold;
    private Button m_relativeThresholdButton;
    private ValidatingTextWidget m_relativeThresholdText;
    private Float m_relativeThreshold;
    private Float m_originalRelativeThreshold;

    public BaselineMetricConditionWizardPage(String pageName, IQualityGateProvider qualityGateProvider, List<String> availableMetricIds) {
        super(pageName, "Quality Gate Metric Condition", qualityGateProvider, availableMetricIds);
    }

    public BaselineMetricConditionWizardPage(String pageName, IQualityGateProvider qualityGateProvider, List<String> availableMetricIds, String metricId, Operator operator, Float diffThreshold, Float diffThresholdRelative) {
        super(pageName, "Quality Gate Metric Condition", qualityGateProvider, availableMetricIds, metricId);
        this.m_originalOperator = operator;
        this.m_operator = operator;
        this.m_originalAbsoluteThreshold = diffThreshold;
        this.m_absoluteThreshold = diffThreshold;
        this.m_originalRelativeThreshold = diffThresholdRelative;
        this.m_relativeThreshold = diffThresholdRelative;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.QUALITY_GATE_BASELINE_METRIC_CONDITION_WIZARD_PAGE;
    }

    Operator getOperator() {
        return this.m_operator;
    }

    Float getThresholdAbsolute() {
        return this.m_absoluteThresholdButton.getSelection() ? this.m_absoluteThreshold : null;
    }

    Float getThresholdRelative() {
        return this.m_relativeThresholdButton.getSelection() ? this.m_relativeThreshold : null;
    }

    @Override
    protected boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        if (this.m_operator != this.m_originalOperator) {
            return true;
        }
        return !NumberUtility.areEqual((Float)this.m_originalAbsoluteThreshold, (Float)this.m_absoluteThreshold) || !NumberUtility.areEqual((Float)this.m_originalRelativeThreshold, (Float)this.m_relativeThreshold);
    }

    protected void createContent(Composite composite) {
        this.createMetricIdWidgets(composite, "System Metric ID:");
        Label operatorLabel = new Label(composite, 0);
        operatorLabel.setText("Operator:");
        operatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_operatorCombo = new MapBackedCombo<Operator>(composite, 8, op -> op.getSymbol());
        this.m_operatorCombo.setLayoutData(new GridData(4, 4, false, false));
        this.m_operatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaselineMetricConditionWizardPage.this.m_operator = BaselineMetricConditionWizardPage.this.m_operatorCombo.getItemForLabel(BaselineMetricConditionWizardPage.this.m_operatorCombo.getText());
                BaselineMetricConditionWizardPage.this.validateInput();
            }
        });
        EnumSet<Operator> operators = EnumSet.allOf(Operator.class);
        operators.remove(Operator.N_A);
        this.m_operatorCombo.setInput(operators);
        this.m_operatorCombo.selectElement(this.m_operator);
        this.m_absoluteThresholdButton = new Button(composite, 32);
        this.m_absoluteThresholdButton.setText("Absolute Threshold:");
        this.m_absoluteThresholdButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_absoluteThresholdText = new ValidatingTextWidget(composite, this.createFloatValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                Number number;
                BaselineMetricConditionWizardPage.this.m_absoluteThreshold = input == null ? null : ((number = NumberUtility.parse((String)input.trim(), (boolean)false)) != null ? Float.valueOf(number.floatValue()) : null);
                BaselineMetricConditionWizardPage.this.validateInput();
            }
        }, this.m_absoluteThreshold != null ? NumberUtility.format((Number)this.m_absoluteThreshold) : "", 0);
        this.m_absoluteThresholdText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_absoluteThresholdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaselineMetricConditionWizardPage.this.m_absoluteThresholdButton.getSelection();
                BaselineMetricConditionWizardPage.this.m_absoluteThresholdText.setEnabled(enabled);
                if (enabled) {
                    BaselineMetricConditionWizardPage.this.m_absoluteThresholdText.validate(true);
                } else {
                    BaselineMetricConditionWizardPage.this.m_absoluteThresholdText.clearDecoration();
                    BaselineMetricConditionWizardPage.this.m_absoluteThreshold = null;
                    BaselineMetricConditionWizardPage.this.validateInput();
                }
            }
        });
        this.m_relativeThresholdButton = new Button(composite, 32);
        this.m_relativeThresholdButton.setText("Relative Threshold:");
        this.m_relativeThresholdButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_relativeThresholdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = BaselineMetricConditionWizardPage.this.m_relativeThresholdButton.getSelection();
                BaselineMetricConditionWizardPage.this.m_relativeThresholdText.setEnabled(enabled);
                if (enabled) {
                    BaselineMetricConditionWizardPage.this.m_relativeThresholdText.validate(true);
                } else {
                    BaselineMetricConditionWizardPage.this.m_relativeThresholdText.clearDecoration();
                    BaselineMetricConditionWizardPage.this.m_relativeThreshold = null;
                    BaselineMetricConditionWizardPage.this.validateInput();
                }
            }
        });
        this.m_relativeThresholdText = new ValidatingTextWidget(composite, this.createFloatValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                Number number;
                BaselineMetricConditionWizardPage.this.m_relativeThreshold = input == null ? null : ((number = NumberUtility.parse((String)input.trim(), (boolean)false)) != null ? Float.valueOf(number.floatValue()) : null);
                BaselineMetricConditionWizardPage.this.validateInput();
            }
        }, this.m_relativeThreshold != null ? NumberUtility.format((Number)this.m_relativeThreshold) : "", 0);
        this.m_relativeThresholdText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createInfoWidget(composite);
        if (!this.isEdit()) {
            this.m_absoluteThresholdButton.setSelection(true);
        } else {
            this.m_absoluteThresholdButton.setSelection(this.m_absoluteThreshold != null);
        }
        this.m_relativeThresholdButton.setSelection(this.m_relativeThreshold != null);
        this.m_relativeThresholdText.setEnabled(this.m_relativeThreshold != null);
        if (this.isEdit()) {
            this.setInfoText(MetricValueDiffQualityGateCondition.createPresentationNameLong((String)this.getMetricId(), (Operator)this.getOperator(), (Float)this.getThresholdAbsolute(), (Float)this.getThresholdRelative()));
        }
        this.validateInput();
    }

    @Override
    protected boolean validateInputFields() {
        if (this.getMetricId() == null || this.getMetricId().trim().isEmpty()) {
            this.setInfoText("Metric id must not be empty.");
            return false;
        }
        if (!this.m_absoluteThresholdButton.getSelection() && !this.m_relativeThresholdButton.getSelection()) {
            this.setInfoText("Either absolute and/or relative threshold value must be defined.");
            return false;
        }
        if (this.m_absoluteThresholdButton.getSelection() && this.m_absoluteThreshold == null && this.m_relativeThresholdButton.getSelection() && this.m_relativeThreshold == null) {
            this.setInfoText("Either absolute and/or relative threshold value must be defined.");
            return false;
        }
        if (this.m_absoluteThresholdButton.getSelection() && this.m_absoluteThreshold == null) {
            this.setInfoText("");
            return false;
        }
        if (this.m_relativeThresholdButton.getSelection() && this.m_relativeThreshold == null) {
            this.setInfoText("");
            return false;
        }
        if (this.m_absoluteThreshold != null && this.m_relativeThreshold != null) {
            float product = this.m_absoluteThreshold.floatValue() * this.m_relativeThreshold.floatValue();
            if (Float.compare(0.0f, product) > 0) {
                this.setInfoText("Absolute and relative thresholds must either be both < 0 or both > 0.");
                return false;
            }
            if (Float.compare(this.m_absoluteThreshold.floatValue(), 0.0f) == 0 && Float.compare(this.m_relativeThreshold.floatValue(), 0.0f) != 0) {
                this.setInfoText("If absolute threshold is set to 0, relative threshold cannot be != 0.");
                return false;
            }
            if (Float.compare(this.m_relativeThreshold.floatValue(), 0.0f) == 0 && Float.compare(this.m_absoluteThreshold.floatValue(), 0.0f) != 0) {
                this.setInfoText("If relative threshold is set to 0, absolute threshold cannot be != 0.");
                return false;
            }
        }
        this.setInfoText(MetricValueDiffQualityGateCondition.createPresentationNameLong((String)this.getMetricId(), (Operator)this.getOperator(), (Float)this.getThresholdAbsolute(), (Float)this.getThresholdRelative()));
        this.m_absoluteThresholdText.clearDecoration();
        this.m_relativeThresholdText.clearDecoration();
        return true;
    }
}

