/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractQualityGateElementWizard
extends NonLazySonargraphWizard {
    private final IQualityGateProvider m_qualityGateProvider;
    private final boolean m_isOnlySystemMetricsLevel;
    private final Set<IIssueId> m_issueIds;
    private final Set<IMetricDescriptor> m_metricDescriptors;

    public AbstractQualityGateElementWizard(String title, IQualityGateProvider qualityGateProvider, Set<IIssueId> issueIds, Set<IMetricDescriptor> metricDescriptors, boolean isOnlySystemMetricLevel) {
        super(title);
        assert (qualityGateProvider != null) : "Parameter 'qualityGateProvider' of method 'ExcludeFilterWizard' must not be null";
        assert (issueIds != null) : "Parameter 'issueIds' of method 'AbstractQualityGateElementWizard' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'AbstractQualityGateElementWizard' must not be null";
        this.m_qualityGateProvider = qualityGateProvider;
        this.m_isOnlySystemMetricsLevel = isOnlySystemMetricLevel;
        this.m_issueIds = issueIds;
        this.m_metricDescriptors = metricDescriptors;
    }

    protected final IQualityGateProvider getQualityGateProvider() {
        return this.m_qualityGateProvider;
    }

    protected List<String> getIssueTypes() {
        List<String> issueTypes = this.m_issueIds.stream().map(id -> id.getQualifiedName()).sorted().collect(Collectors.toList());
        issueTypes.add(0, "Any");
        return issueTypes;
    }

    protected List<String> getMetricIds() {
        Set<Object> metricDescriptors = this.m_isOnlySystemMetricsLevel ? this.m_metricDescriptors.stream().filter(m -> m.getLevel() == CoreMetricLevel.SYSTEM).collect(Collectors.toSet()) : this.m_metricDescriptors;
        ArrayList<String> result = new ArrayList<String>(metricDescriptors.size());
        for (IMetricDescriptor iMetricDescriptor : metricDescriptors) {
            result.add(iMetricDescriptor.getId());
        }
        Collections.sort(result);
        return result;
    }

    public final void addPages() {
        this.internalAddPages(this.getIssueTypes(), this.getMetricIds());
    }

    protected abstract void internalAddPages(List<String> var1, List<String> var2);
}

