/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.logicalnamespacesview.LogicalNamespacesViewContentAndLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class LogicalNamespacesViewComparator
extends ViewerComparator {
    private final LogicalNamespacesViewContentAndLabelProvider m_contentAndLabelProvider;
    private CategoryProvider m_categoryProvider;
    private SoftwareSystem m_softwareSystem;
    private PresentationMode m_presentationMode = PresentationMode.HIERARCHICAL;

    LogicalNamespacesViewComparator(LogicalNamespacesViewContentAndLabelProvider contentAndLabelProvider) {
        assert (contentAndLabelProvider != null) : "Parameter 'contentAndLabelProvider' of method 'LogicalNamespacesViewComparator' must not be null";
        this.m_contentAndLabelProvider = contentAndLabelProvider;
    }

    final void setCategoryProvider(CategoryProvider categoryProvider) {
        this.m_categoryProvider = categoryProvider;
    }

    void setPresentationMode(PresentationMode presentationMode) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setPresentationMode' must not be null";
        this.m_presentationMode = presentationMode;
    }

    void setSoftwareSystem(SoftwareSystem softwareSystem) {
        this.m_softwareSystem = softwareSystem;
    }

    private boolean areNamespaces(Object element1, Object element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'areDirectories' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'areDirectories' must not be null";
        return element1 instanceof LogicalNamespace && element2 instanceof LogicalNamespace;
    }

    private boolean elementsFlattend(Object element1, Object element2) {
        if (this.m_presentationMode == PresentationMode.FLAT) {
            return this.areNamespaces(element1, element2);
        }
        return false;
    }

    protected final boolean elementsFlattend(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'elementsFlattend' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'elementsFlattend' must not be null";
        return LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation(element1, this.m_presentationMode) && LogicalNamespacesViewContentAndLabelProvider.applyFlatPresentation(element2, this.m_presentationMode);
    }

    protected final boolean elementsInMixedMode(NamedElement element1, NamedElement element2) {
        assert (element1 != null) : "Parameter 'element1' of method 'elementsInMixedMode' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'elementsInMixedMode' must not be null";
        return LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation(element1, this.m_presentationMode) && LogicalNamespacesViewContentAndLabelProvider.applyMixedPresentation(element2, this.m_presentationMode);
    }

    public final int compare(Viewer viewer, Object element1, Object element2) {
        assert (this.m_softwareSystem != null) : "'m_softwareSystem' of method 'compare' must not be null";
        assert (element1 != null) : "Parameter 'element1' of method 'compare' must not be null";
        assert (element2 != null) : "Parameter 'element2' of method 'compare' must not be null";
        assert (element1 instanceof NamedElement) : "Not a named element: " + String.valueOf(element1);
        assert (element2 instanceof NamedElement) : "Not a named element: " + String.valueOf(element2);
        int compare = 0;
        if (!this.elementsFlattend(element1, element2) && this.m_categoryProvider != null) {
            Object n1 = (NamedElement)element1;
            Object n2 = (NamedElement)element2;
            n1 = n1 instanceof LogicalProgrammingElement ? ((LogicalProgrammingElement)n1).getPrimaryProgrammingElement() : n1.getElement();
            n2 = n2 instanceof LogicalProgrammingElement ? ((LogicalProgrammingElement)n2).getPrimaryProgrammingElement() : n2.getElement();
            compare = this.m_categoryProvider.getCategory(n1) - this.m_categoryProvider.getCategory(n2);
        }
        if (compare == 0) {
            boolean elementsFlattend = this.elementsFlattend(element1, element2);
            if (elementsFlattend) {
                assert (this.areNamespaces(element1, element2)) : "Namespaces expected";
                compare = ((NamedElement)element1).getPresentationName(false).toLowerCase().compareTo(((NamedElement)element2).getPresentationName(false).toLowerCase());
            } else {
                compare = this.elementsInMixedMode((NamedElement)element1, (NamedElement)element2) ? this.m_contentAndLabelProvider.getPresentationNameForMixedMode((NamedElement)element1).toLowerCase().compareTo(this.m_contentAndLabelProvider.getPresentationNameForMixedMode((NamedElement)element2).toLowerCase()) : ((NamedElement)element1).getPresentationName(true).toLowerCase().compareTo(((NamedElement)element2).getPresentationName(true).toLowerCase());
            }
        }
        return compare;
    }
}

