/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.issuesview;

import com.hello2morrow.sonargraph.core.command.system.workspace.IFixWorkspaceDependencyIssueInteraction;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Optional;

abstract class AbstractFixWorkspaceDependencyIssueCommandHandler<T extends Issue>
extends CommandHandlerWithCorrespondingCommand {
    private final String m_menuLabel;
    private final Class<T> m_issueClazz;

    public AbstractFixWorkspaceDependencyIssueCommandHandler(String menuLabel, Class<T> clazz) {
        assert (menuLabel != null && menuLabel.length() > 0) : "Parameter 'menuLabel' of method 'AbstractFixWorkspaceDependencyIssueCommandHandler' must not be empty";
        assert (clazz != null) : "Parameter 'clazz' of method 'AbstractFixWorkspaceDependencyIssueCommandHandler' must not be null";
        this.m_menuLabel = menuLabel;
        this.m_issueClazz = clazz;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                return AbstractFixWorkspaceDependencyIssueCommandHandler.this.m_menuLabel;
            }

            public IMenuGroup getMenuGroup() {
                return IContextMenuContributor.SpecialMenuGroup.FIRST;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        return !this.getIssuesFromSelection(selection).isEmpty();
    }

    private final List<T> getIssuesFromSelection(WorkbenchViewSelection selection) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (selection != null && !selection.getElements().isEmpty()) {
            for (Element next : selection.getElements()) {
                if (this.m_issueClazz.isAssignableFrom(next.getClass())) {
                    issues.add((Issue)next);
                    continue;
                }
                return Collections.emptyList();
            }
        }
        return issues;
    }

    protected final IFixWorkspaceDependencyIssueInteraction<T> createInteraction(WorkbenchViewSelection selection) {
        final List<T> issues = this.getIssuesFromSelection(selection);
        assert (issues != null && !issues.isEmpty()) : "Issues must not be null or empty!";
        return new IFixWorkspaceDependencyIssueInteraction<T>(){

            public boolean collect(IFixWorkspaceDependencyIssueInteraction.InteractionData<T> data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setIssues(issues);
                return true;
            }

            public void process(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        };
    }
}

