/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.help;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.commandhandler.SendFeedbackHandler;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.dialog.AboutDialog;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public final class WelcomeView
extends WorkbenchView {
    private static final Font FONT_HEADING = UiResourceManager.getInstance().getFontWithHeightDelta(2, 1);
    private static final Font FONT_TEXT = UiResourceManager.getInstance().getFont(0);
    private static final Font FONT_TEXT_BOLD = UiResourceManager.getInstance().getFont(1);

    public IViewId getViewId() {
        return ViewId.WELCOME_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.allOf(WorkbenchView.EventCategory.class);
    }

    protected boolean supportsSleep() {
        return false;
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }

    private void setBulletListStyle(StyledText styledText, int startLine, int lines) {
        assert (styledText != null) : "Parameter 'styledText' of method 'setBulletListStyle' must not be null";
        StyleRange styleRange = new StyleRange();
        styleRange.metrics = new GlyphMetrics(0, 0, 10);
        styleRange.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.BLACK);
        styledText.setLineBullet(startLine, lines, new Bullet(styleRange));
    }

    private void setIndentationStyle(StyledText styledText, int startLine, int lines) {
        assert (styledText != null) : "Parameter 'styledText' of method 'setIndentationStyle' must not be null";
        StyleRange styleRange = new StyleRange();
        styleRange.metrics = new GlyphMetrics(0, 0, 10);
        styleRange.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.BLACK);
        styledText.setLineBullet(startLine, lines, new Bullet(32, styleRange));
    }

    private void setHeaderStyle(StyledText styledText, int offset, int length) {
        assert (styledText != null) : "Parameter 'styledText' of method 'setHeaderStyle' must not be null";
        StyleRange styleRange = new StyleRange();
        styleRange.start = offset;
        styleRange.length = length;
        styleRange.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE);
        styleRange.font = FONT_HEADING;
        styledText.setStyleRange(styleRange);
    }

    private void setBoldStyle(StyledText styledText, int offset, int length) {
        assert (styledText != null) : "Parameter 'styledText' of method 'setBoldStyle' must not be null";
        StyleRange styleRange = new StyleRange();
        styleRange.start = offset;
        styleRange.length = length;
        styleRange.font = FONT_TEXT_BOLD;
        styledText.setStyleRange(styleRange);
    }

    private void setHRefStyle(StyledText styledText, int offset, int length, String href) {
        assert (styledText != null) : "Parameter 'styledText' of method 'setHRefStyle' must not be null";
        assert (href != null && href.length() > 0) : "Parameter 'href' of method 'setHRefStyle' must not be empty";
        StyleRange styleRange = new StyleRange();
        styleRange.start = offset;
        styleRange.length = length;
        styleRange.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE);
        styleRange.font = FONT_TEXT;
        styleRange.underline = true;
        styleRange.underlineStyle = 4;
        styleRange.data = href;
        styledText.setStyleRange(styleRange);
    }

    private void handleHRef(String href) {
        assert (href != null && href.length() > 0) : "Parameter 'href' of method 'handleHRef' must not be empty";
        if (href.startsWith("--") && href.endsWith("--")) {
            String action = href.substring(2, href.length() - 2);
            if (action.equals("releasenotes")) {
                new AboutDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), WelcomeView.class, 1).open();
            } else if (action.equals("feedback")) {
                new SendFeedbackHandler().execute();
            }
        } else {
            Program.launch((String)href);
        }
    }

    private StyledText createStyledText(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createStyledText' must not be null";
        final StyledText styledText = new StyledText(parent, 8);
        styledText.setFont(FONT_TEXT);
        styledText.setLineSpacing(4);
        styledText.setEditable(false);
        styledText.setDragDetect(false);
        styledText.setBlockSelection(false);
        styledText.setDoubleClickEnabled(false);
        styledText.setMouseNavigatorEnabled(false);
        styledText.setTouchEnabled(false);
        styledText.setCaret(null);
        styledText.setSelectionBackground(styledText.getBackground());
        styledText.setSelectionForeground(styledText.getForeground());
        styledText.setCursor(UiResourceManager.getInstance().getCursor(0));
        styledText.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                int offset = styledText.getOffsetAtPoint(new Point(event.x, event.y));
                if (offset != -1) {
                    Object data;
                    StyleRange styleRangeAtOffset = null;
                    try {
                        styleRangeAtOffset = styledText.getStyleRangeAtOffset(offset);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (styleRangeAtOffset != null && (data = styleRangeAtOffset.data) instanceof String) {
                        WelcomeView.this.handleHRef((String)data);
                    }
                }
            }
        });
        return styledText;
    }

    private Composite addVisualizationImage(String title, String href, String imageResourceName, Composite parent) {
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'addVisualizationImage' must not be empty";
        assert (href != null && href.length() > 0) : "Parameter 'href' of method 'addVisualizationImage' must not be empty";
        assert (imageResourceName != null && imageResourceName.length() > 0) : "Parameter 'imageResourceName' of method 'addVisualizationImage' must not be empty";
        assert (parent != null) : "Parameter 'parent' of method 'addVisualizationImage' must not be null";
        Composite composite = new Composite(parent, 0);
        composite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 4;
        composite.setLayout((Layout)gridLayout);
        StyledText styledText = this.createStyledText(composite);
        styledText.setLayoutData((Object)new GridData(1, 1, false, false));
        styledText.setText(title);
        this.setHRefStyle(styledText, 0, title.length(), href);
        Label image = new Label(composite, 0);
        image.setImage(UiResourceManager.getInstance().getImage(imageResourceName));
        image.setLayoutData((Object)new GridData(1, 1, false, false));
        return composite;
    }

    private void addGettingStartedInfo(StyledText styledText) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addGettingStartedInfo' must not be null";
        String GETTING_STARTED = "Getting Started";
        String SONARGRAPH = "Sonargraph";
        String MOTIVATION = "Motivation";
        String F1 = "F1";
        String RELEASE_NOTES = "release notes";
        String PROJECT_SETUP = "Setting up your project";
        String BLOG_ARTICLE = "Golden rules for Sonargraph newbies";
        StringBuilder text = new StringBuilder();
        text.append("Getting Started").append("\n");
        text.append("Welcome to ").append("Sonargraph").append("! The following resources are helpful to get you started:\n");
        text.append("Chapter ").append("Motivation").append(" in the user manual.\n");
        text.append("Chapter ").append("Getting Started").append(" in the user manual.\n");
        text.append("Open the context help for views via ").append("F1").append(".\n");
        text.append("Check the ").append("release notes").append(" for updates and bug fixes.\n");
        text.append("Blog article ").append("Setting up your project").append(".\n");
        text.append("Blog article ").append("Golden rules for Sonargraph newbies").append(".");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, "Getting Started".length());
        this.setBulletListStyle(styledText, 2, 6);
        int pos = text.indexOf("Sonargraph");
        this.setHRefStyle(styledText, pos, "Sonargraph".length(), "https://www.hello2morrow.com");
        pos = text.indexOf("Motivation", pos);
        this.setHRefStyle(styledText, pos, "Motivation".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("motivation.html"));
        pos = text.indexOf("Getting Started", pos);
        this.setHRefStyle(styledText, pos, "Getting Started".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("getting_started.html"));
        pos = text.indexOf("F1", pos);
        this.setBoldStyle(styledText, pos, "F1".length());
        pos = text.indexOf("release notes", pos);
        this.setHRefStyle(styledText, pos, "release notes".length(), "--releasenotes--");
        pos = text.indexOf("Setting up your project", pos);
        this.setHRefStyle(styledText, pos, "Setting up your project".length(), "https://blog.hello2morrow.com/2023/02/setting-up-sonargraph-on-your-project");
        pos = text.indexOf("Golden rules for Sonargraph newbies", pos);
        this.setHRefStyle(styledText, pos, "Golden rules for Sonargraph newbies".length(), "https://blog.hello2morrow.com/2020/01/golden-rules");
    }

    private void addSupportInfo(StyledText styledText) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addSupportInfo' must not be null";
        String SUPPORT = "Support";
        String SONARGRAPH = "Sonargraph";
        String SERVICES = "https://www.hello2morrow.com/services";
        String FEEDBACK = "feedback";
        String MAIL = "support@hello2morrow.com";
        StringBuilder text = new StringBuilder();
        text.append("Support").append("\n");
        text.append("Sonargraph").append(" is a powerful tool with a lot of functionality!\n");
        text.append("In case you get stuck, we are here to help:\n");
        text.append("We offer trainings and consulting.\n");
        text.append("More info at ").append("https://www.hello2morrow.com/services").append(".\n");
        text.append("Use the integrated ").append("feedback").append(" functionality.\n");
        text.append("Send an email to ").append("support@hello2morrow.com").append(".");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, "Support".length());
        this.setBulletListStyle(styledText, 3, 1);
        this.setIndentationStyle(styledText, 4, 1);
        this.setBulletListStyle(styledText, 5, 2);
        int pos = text.indexOf("Sonargraph");
        this.setHRefStyle(styledText, pos, "Sonargraph".length(), "https://www.hello2morrow.com");
        pos = text.indexOf("https://www.hello2morrow.com/services", pos);
        this.setHRefStyle(styledText, pos, "https://www.hello2morrow.com/services".length(), "https://www.hello2morrow.com/services");
        pos = text.indexOf("feedback", pos);
        this.setHRefStyle(styledText, pos, "feedback".length(), "--feedback--");
        pos = text.indexOf("support@hello2morrow.com", pos);
        this.setHRefStyle(styledText, pos, "support@hello2morrow.com".length(), "mailto:support@hello2morrow.com");
    }

    private void addVideosInfo(StyledText styledText) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addVideosInfo' must not be null";
        String VIDEOS = "Videos";
        String FIRST_STEPS = "First Steps";
        String C_CPLUSPLUS_PROJECT_SETUP = "C,C++ Project Setup";
        String MONOLITH = "Breaking up the Monolith";
        String WEBINAR = "Sonargraph Webinar Series";
        String MORE = "More...";
        StringBuilder text = new StringBuilder();
        text.append("Videos").append("\n");
        text.append("If you like to learn by watching videos:\n");
        text.append("First Steps").append("\n");
        text.append("C,C++ Project Setup").append("\n");
        text.append("Breaking up the Monolith").append("\n");
        text.append("Sonargraph Webinar Series").append("\n");
        text.append("More...");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, "Videos".length());
        this.setBulletListStyle(styledText, 2, 5);
        int pos = text.indexOf("First Steps");
        this.setHRefStyle(styledText, pos, "First Steps".length(), "https://www.hello2morrow.com/videos/intro");
        pos = text.indexOf("C,C++ Project Setup", pos);
        this.setHRefStyle(styledText, pos, "C,C++ Project Setup".length(), "https://www.hello2morrow.com/videos/cppsetup");
        pos = text.indexOf("Breaking up the Monolith", pos);
        this.setHRefStyle(styledText, pos, "Breaking up the Monolith".length(), "https://www.hello2morrow.com/videos/breakup");
        pos = text.indexOf("Sonargraph Webinar Series", pos);
        this.setHRefStyle(styledText, pos, "Sonargraph Webinar Series".length(), "https://www.youtube.com/playlist?list=PLUEg3Nsx-ADNkkln8JIoH3DVdrUxRIKVz");
        pos = text.indexOf("More...", pos);
        this.setHRefStyle(styledText, pos, "More...".length(), "https://www.hello2morrow.com/videos");
    }

    private void addArticlesInfo(StyledText styledText) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addArticlesInfo' must not be null";
        String ARTICLES = "Articles";
        String CHANGES_DASHBOARD = "Changes To The Dashboard (System View)";
        String USABILITY_IMPROVEMENTS = "Recently Added Usability Improvements";
        String ISSUES = "Identify the Most Relevant Issues to Fix";
        String QUALITY = "Efficiently Track the Quality of a Code Base";
        String MORE = "More...";
        StringBuilder text = new StringBuilder();
        text.append("Articles").append("\n");
        text.append("We regularly post articles on our blog about new features and interesting use cases:\n");
        text.append("Changes To The Dashboard (System View)").append("\n");
        text.append("Recently Added Usability Improvements").append("\n");
        text.append("Identify the Most Relevant Issues to Fix").append("\n");
        text.append("Efficiently Track the Quality of a Code Base").append("\n");
        text.append("More...");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, "Articles".length());
        this.setBulletListStyle(styledText, 2, 5);
        int pos = text.indexOf("Changes To The Dashboard (System View)");
        this.setHRefStyle(styledText, pos, "Changes To The Dashboard (System View)".length(), "https://blog.hello2morrow.com/2025/06/changes-to-the-sonargraph-dashboard");
        pos = text.indexOf("Recently Added Usability Improvements", pos);
        this.setHRefStyle(styledText, pos, "Recently Added Usability Improvements".length(), "https://blog.hello2morrow.com/2021/10/recently-added-usability-improvements");
        pos = text.indexOf("Identify the Most Relevant Issues to Fix", pos);
        this.setHRefStyle(styledText, pos, "Identify the Most Relevant Issues to Fix".length(), "https://blog.hello2morrow.com/2021/07/identify-the-most-relevant-issues-to-fix");
        pos = text.indexOf("Efficiently Track the Quality of a Code Base", pos);
        this.setHRefStyle(styledText, pos, "Efficiently Track the Quality of a Code Base".length(), "https://blog.hello2morrow.com/2021/07/efficiently-track-a-code-bases-qualit");
        pos = text.indexOf("More...", pos);
        this.setHRefStyle(styledText, pos, "More...".length(), "https://blog.hello2morrow.com");
    }

    private void addArchitectureInfo(StyledText styledText, String licenseRestrictionAddition) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addArchitectureInfo' must not be null";
        String ARCHITECTURE_DEFINITION = "Architecture Definition" + licenseRestrictionAddition;
        String ARCHITECTURAL_VIEW = "Architectural View";
        String ARCHITECTURE_DSL = "Architecture DSL";
        StringBuilder text = new StringBuilder();
        text.append(ARCHITECTURE_DEFINITION).append("\n");
        text.append("Validate the dependency structure against target architecture aspects.\n");
        text.append("Define architecture aspects:\n");
        text.append("Interactively using the ").append("Architectural View").append(".\n");
        text.append("Textual via the ").append("Architecture DSL").append(".");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, ARCHITECTURE_DEFINITION.length());
        this.setBulletListStyle(styledText, 3, 2);
        int pos = text.indexOf("Architectural View");
        this.setHRefStyle(styledText, pos, "Architectural View".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("architectural_view_interactive_restructuring_and_organizing.html"));
        pos = text.indexOf("Architecture DSL", pos);
        this.setHRefStyle(styledText, pos, "Architecture DSL".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("architecture_definition.html"));
    }

    private void addRestructuringInfo(StyledText styledText, String licenseRestrictionAddition) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addRestructuringInfo' must not be null";
        String SIMULATE = "Simulate Improvements" + licenseRestrictionAddition;
        String CYCLE_BREAKUP = "Cycle Breakup View";
        String REFACTORINGS = "Simulate Refactorings";
        String ECLIPSE = "Eclipse";
        String INTELLIJ = "IntelliJ";
        StringBuilder text = new StringBuilder();
        text.append(SIMULATE).append("\n");
        text.append("Simulate structural improvements which can be executed via IDE integrations:\n");
        text.append("Breaking up cycle groups using the ").append("Cycle Breakup View").append(".\n");
        text.append("Defining move, rename and delete refactorings as described in ").append("Simulate Refactorings").append(".\n");
        text.append("Executing refactorings via ").append("Eclipse");
        text.append(" or ").append("IntelliJ").append(" plugins.");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, SIMULATE.length());
        this.setBulletListStyle(styledText, 2, 3);
        int pos = text.indexOf("Cycle Breakup View");
        this.setHRefStyle(styledText, pos, "Cycle Breakup View".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("cycle_break_up.html"));
        pos = text.indexOf("Simulate Refactorings", pos);
        this.setHRefStyle(styledText, pos, "Simulate Refactorings".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("simulate_refactorings.html"));
        pos = text.indexOf("Eclipse", pos);
        this.setHRefStyle(styledText, pos, "Eclipse".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("ide_integrations_eclipse_execute_refactorings.html"));
        pos = text.indexOf("IntelliJ", pos);
        this.setHRefStyle(styledText, pos, "IntelliJ".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("ide_integrations_intellij_execute_refactorings.html"));
    }

    private void addExtensionsInfo(StyledText styledText, String licenseRestrictionAddition) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addExtensionsInfo' must not be null";
        String EXTENSIONS = "Extensions" + licenseRestrictionAddition;
        String SCRIPTS = "Scripts";
        String QUALITY_MODELS = "quality models";
        String PLUGINS = "plugins";
        String SPOTBUGS = "Spotbugs";
        String PMD = "PMD";
        String SPRING_MICROSERVICES = "Spring Microservices";
        String SWAGGER = "Swagger";
        StringBuilder text = new StringBuilder();
        text.append(EXTENSIONS).append("\n");
        text.append("You can extend the analysis to fit your needs:\n");
        text.append("Create custom issues, metrics and queries via ").append("Scripts").append(". We included some scripts\n");
        text.append("in the standard ").append("quality models").append(" that can be easily imported and used as templates.\n");
        text.append("Use external analyzers via ").append("plugins").append(", currently available are ").append("Spotbugs").append(" and ").append("PMD").append(".\n");
        text.append("Analyze dependencies between microservices using the ").append("Spring Microservices").append(" and\n");
        text.append("Swagger").append(" ").append("plugins").append(" .");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, EXTENSIONS.length());
        this.setBulletListStyle(styledText, 2, 1);
        this.setIndentationStyle(styledText, 3, 1);
        this.setBulletListStyle(styledText, 4, 2);
        this.setIndentationStyle(styledText, 6, 1);
        int pos = text.indexOf("Scripts");
        this.setHRefStyle(styledText, pos, "Scripts".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("extending_static_analysis.html"));
        pos = text.indexOf("quality models", pos);
        this.setHRefStyle(styledText, pos, "quality models".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("import_quality_model.html"));
        pos = text.indexOf("plugins", pos);
        this.setHRefStyle(styledText, pos, "plugins".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("plugin_infrastructure.html"));
        pos = text.indexOf("Spotbugs", pos);
        this.setHRefStyle(styledText, pos, "Spotbugs".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("spotbugs_plugin.html"));
        pos = text.indexOf("PMD", pos);
        this.setHRefStyle(styledText, pos, "PMD".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("pmd_plugin.html"));
        pos = text.indexOf("Spring Microservices", pos);
        this.setHRefStyle(styledText, pos, "Spring Microservices".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("spring_microservices_plugin.html"));
        pos = text.indexOf("Swagger", pos);
        this.setHRefStyle(styledText, pos, "Swagger".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("swagger_plugin.html"));
        pos = text.indexOf("plugins", pos);
        this.setHRefStyle(styledText, pos, "plugins".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("plugin_infrastructure.html"));
    }

    private void addBuildIntegrationsInfo(StyledText styledText) {
        assert (styledText != null) : "Parameter 'styledText' of method 'addBuildIntegrationsInfo' must not be null";
        String BUILD_INTEGRATIONS = "Build Integrations";
        String SONARGRAPH_BUILD = "Sonargraph-Build";
        String COMMAND_LINE = "command-line";
        String MAVEN = "Maven";
        String GRADLE = "Gradle";
        String ANT = "Ant";
        String SONARQUBE = "SonarQube";
        String JENKINS = "Jenkins";
        String SONARGRAPH_ENTERPRISE = "Sonargraph-Enterprise";
        String SONARGRAPH_INTEGRATION_ACCESS = "Sonargraph Integration Access";
        StringBuilder text = new StringBuilder();
        text.append("Build Integrations").append("\n");
        text.append("Use the ").append("Sonargraph-Build").append(" integrations to continuously monitor the quality:\n");
        text.append("Execute ").append("Sonargraph-Build").append(" via ").append("command-line").append(", ").append("Maven").append(", ").append("Gradle").append(" and ").append("Ant").append(".\n");
        text.append("Upload the results to ").append("SonarQube").append(".\n");
        text.append("Execute the checks in ").append("Jenkins").append(".\n");
        text.append("Use ").append("Sonargraph-Enterprise").append(" to monitor trends.\n");
        text.append("Build your own integration using the ").append("Sonargraph Integration Access").append(" library.");
        styledText.setText(text.toString());
        this.setHeaderStyle(styledText, 0, "Build Integrations".length());
        this.setBulletListStyle(styledText, 2, 5);
        int pos = text.indexOf("Sonargraph-Build");
        this.setHRefStyle(styledText, pos, "Sonargraph-Build".length(), "https://eclipse.hello2morrow.com/doc/build/content/index.html");
        pos = text.indexOf("command-line", pos);
        this.setHRefStyle(styledText, pos, "command-line".length(), "https://eclipse.hello2morrow.com/doc/build/content/integrating_with_shell.html");
        pos = text.indexOf("Maven", pos);
        this.setHRefStyle(styledText, pos, "Maven".length(), "https://eclipse.hello2morrow.com/doc/build/content/integrating_with_maven.html");
        pos = text.indexOf("Gradle", pos);
        this.setHRefStyle(styledText, pos, "Gradle".length(), "https://eclipse.hello2morrow.com/doc/build/content/integrating_with_gradle.html");
        pos = text.indexOf("Ant");
        this.setHRefStyle(styledText, pos, "Ant".length(), "https://eclipse.hello2morrow.com/doc/build/content/integrating_with_ant.html");
        pos = text.indexOf("SonarQube", pos);
        this.setHRefStyle(styledText, pos, "SonarQube".length(), "https://eclipse.hello2morrow.com/doc/build/content/sonarqube_integration.html");
        pos = text.indexOf("Jenkins", pos);
        this.setHRefStyle(styledText, pos, "Jenkins".length(), "https://eclipse.hello2morrow.com/doc/build/content/jenkins_integration.html");
        pos = text.indexOf("Sonargraph-Enterprise", pos);
        this.setHRefStyle(styledText, pos, "Sonargraph-Enterprise".length(), "https://www.hello2morrow.com/products/sonargraph/enterprise");
        pos = text.indexOf("Sonargraph Integration Access", pos);
        this.setHRefStyle(styledText, pos, "Sonargraph Integration Access".length(), "https://github.com/sonargraph/sonargraph-integration-access");
    }

    private Composite createVisualizationsInfoSection(Composite parent, String licenseRestrictionAddition) {
        assert (parent != null) : "Parameter 'parent' of method 'createVisualizationsInfoSection' must not be null";
        assert (licenseRestrictionAddition != null) : "Parameter 'licenseRestrictionAddition' of method 'createVisualizationsInfoSection' must not be null";
        Composite content = new Composite(parent, 0);
        content.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 4;
        gridLayout.horizontalSpacing = 40;
        content.setLayout((Layout)gridLayout);
        StyledText visualizations = this.createStyledText(content);
        String VISUALIZATIONS = "Visualizations";
        String EXPLORE = "explore dependency structures and highlight hotspots";
        StringBuilder text = new StringBuilder();
        text.append("Visualizations").append("\n");
        text.append("Sonargraph offers advanced visualizations to ").append("explore dependency structures and highlight hotspots").append(":");
        visualizations.setText(text.toString());
        this.setHeaderStyle(visualizations, 0, "Visualizations".length());
        int pos = text.indexOf("explore dependency structures and highlight hotspots");
        this.setHRefStyle(visualizations, pos, "explore dependency structures and highlight hotspots".length(), HelpRegistry.getInstance().getUrlForLocalHtmlFile("exploring_the_system.html"));
        visualizations.setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
        Composite image = this.addVisualizationImage("Exploration View", HelpRegistry.getInstance().getUrlForLocalHtmlFile("exploration_view.html"), UiResourceManager.getInstance().inDarkMode() ? "Welcome_Expo_DarkMode" : "Welcome_Expo", content);
        image.setLayoutData((Object)new GridData(1, 1, false, false));
        image = this.addVisualizationImage("Graph View", HelpRegistry.getInstance().getUrlForLocalHtmlFile("graph_based_system_exploration.html"), UiResourceManager.getInstance().inDarkMode() ? "Welcome_Graph_DarkMode" : "Welcome_Graph", content);
        image.setLayoutData((Object)new GridData(1, 1, false, false));
        image = this.addVisualizationImage("UML Component View" + licenseRestrictionAddition, HelpRegistry.getInstance().getUrlForLocalHtmlFile("visualizing_architecture_definition.html"), UiResourceManager.getInstance().inDarkMode() ? "Welcome_Uml_DarkMode" : "Welcome_Uml", content);
        image.setLayoutData((Object)new GridData(1, 1, false, false));
        image = this.addVisualizationImage("Treemaps" + licenseRestrictionAddition, HelpRegistry.getInstance().getUrlForLocalHtmlFile("treemap_based_system_exploration.html"), "Welcome_Treemap", content);
        image.setLayoutData((Object)new GridData(1, 1, false, false));
        return content;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        ScrolledComposite scrolledComposite = new ScrolledComposite(viewContentArea, 768);
        scrolledComposite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        Composite content = new Composite((Composite)scrolledComposite, 0);
        content.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.verticalSpacing = 4;
        gridLayout.horizontalSpacing = 16;
        content.setLayout((Layout)gridLayout);
        StyledText gettingStarted = this.createStyledText(content);
        this.addGettingStartedInfo(gettingStarted);
        gettingStarted.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText support = this.createStyledText(content);
        this.addSupportInfo(support);
        support.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText videos = this.createStyledText(content);
        this.addVideosInfo(videos);
        videos.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText articles = this.createStyledText(content);
        this.addArticlesInfo(articles);
        articles.setLayoutData((Object)new GridData(4, 1, false, false));
        String licenseRestrictionAddition = CommandRegistry.getInstance().getLicenseHandler().isFeatureAvailable(SonargraphFeature.ARCHITECTURE) ? "" : " (Commercial License Required)";
        Composite visualizations = this.createVisualizationsInfoSection(content, licenseRestrictionAddition);
        visualizations.setLayoutData((Object)new GridData(4, 1, false, false, 4, 1));
        StyledText architecture = this.createStyledText(content);
        this.addArchitectureInfo(architecture, licenseRestrictionAddition);
        architecture.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText restructuring = this.createStyledText(content);
        this.addRestructuringInfo(restructuring, licenseRestrictionAddition);
        restructuring.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText extensions = this.createStyledText(content);
        this.addExtensionsInfo(extensions, licenseRestrictionAddition);
        extensions.pack(true);
        extensions.setLayoutData((Object)new GridData(4, 1, false, false));
        StyledText buildIntegrations = this.createStyledText(content);
        this.addBuildIntegrationsInfo(buildIntegrations);
        buildIntegrations.setLayoutData((Object)new GridData(4, 1, false, false));
        content.pack();
        scrolledComposite.setContent((Control)content);
        scrolledComposite.setMinSize(content.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
    }
}

