/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.duplicateview;

import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.MatchingLinesOfTwoStrings;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LanguageBasedSourceViewWidget;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceViewWidgetBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.MapBackedCombo;
import com.hello2morrow.sonargraph.ui.standalone.duplicateview.DuplicateSourceViewWidget;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.SourceBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public final class DuplicatesSourceView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
MapBackedCombo.ILabelProvider<DuplicateCodeBlockOccurrence>,
IViewWithZoom {
    private final List<Element> m_elementsForRestore = new ArrayList<Element>();
    private Composite m_compositeLeft;
    private Composite m_compositeRight;
    private MapBackedCombo<DuplicateCodeBlockOccurrence> m_comboLeft;
    private MapBackedCombo<DuplicateCodeBlockOccurrence> m_comboRight;
    private DuplicateSourceViewWidget m_duplicateSourceViewWidgetLeft;
    private DuplicateSourceViewWidget m_duplicateSourceViewWidgetRight;
    private SelectionAdapter m_selectionAdapterScrollBarLeft;
    private SelectionAdapter m_selectionAdapterScrollBarRight;
    private SelectionAdapter m_selectionAdapterComboLeft;
    private SelectionAdapter m_selectionAdapterComboRight;
    private Set<Integer> m_matchingLinesLeft;
    private Set<Integer> m_matchingLinesRight;
    private List<DuplicateCodeBlockOccurrence> m_items;
    private DuplicateCodeBlockOccurrence m_currentlyShownLeft;
    private DuplicateCodeBlockOccurrence m_currentlyShownRight;
    private Point m_currentLocationLeft;
    private Point m_currentLocationRight;
    private SelectedBlock m_selectedBlock;
    private SourceViewWidgetBasedTextSearchHandler m_leftTextSearchProvider;
    private SourceBasedTextSearchHandler m_rightTextSearchProvider;

    public IViewId getViewId() {
        return ViewId.DUPLICATES_SOURCE_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected boolean supportsSleep() {
        return false;
    }

    public List<Control> getControlsForInteraction() {
        ArrayList<Control> controlsForInteraction = new ArrayList<Control>(2);
        controlsForInteraction.add(this.m_duplicateSourceViewWidgetLeft.getMainControl());
        controlsForInteraction.add(this.m_duplicateSourceViewWidgetRight.getMainControl());
        return controlsForInteraction;
    }

    protected EnumSet<Gesture> getDisabledGestures() {
        return EnumSet.of(Gesture.DOUBLE_CLICK);
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.WORKSPACE_MODIFIED)) {
            this.hideView();
        }
        super.softwareSystemModified(modification, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        super.analyzerModification(modification, analyzerId);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.m_duplicateSourceViewWidgetLeft.clear();
        this.m_duplicateSourceViewWidgetRight.clear();
        this.m_elementsForRestore.clear();
        this.hideView();
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 256);
        this.m_compositeLeft = new Composite((Composite)sashForm, 2048);
        this.m_compositeLeft.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_compositeRight = new Composite((Composite)sashForm, 2048);
        this.m_compositeRight.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_comboLeft = new MapBackedCombo<DuplicateCodeBlockOccurrence>(this.m_compositeLeft, 8, this, true);
        this.m_comboLeft.setLayoutData(new GridData(4, 1, true, false));
        this.m_comboRight = new MapBackedCombo<DuplicateCodeBlockOccurrence>(this.m_compositeRight, 8, this, true);
        this.m_comboRight.setLayoutData(new GridData(4, 1, true, false));
        this.m_duplicateSourceViewWidgetLeft = new DuplicateSourceViewWidget(this.m_compositeLeft, (IWorkbenchView)this);
        this.m_duplicateSourceViewWidgetLeft.setLayoutData(new GridData(4, 4, true, true));
        this.m_duplicateSourceViewWidgetLeft.setFocus();
        this.m_duplicateSourceViewWidgetRight = new DuplicateSourceViewWidget(this.m_compositeRight, (IWorkbenchView)this);
        this.m_duplicateSourceViewWidgetRight.setLayoutData(new GridData(4, 4, true, true));
        this.m_leftTextSearchProvider = new SourceViewWidgetBasedTextSearchHandler(this.m_duplicateSourceViewWidgetLeft, false, this.getViewId().getPresentationName());
        this.m_rightTextSearchProvider = new SourceViewWidgetBasedTextSearchHandler(this.m_duplicateSourceViewWidgetRight, false, this.getViewId().getPresentationName());
        this.m_selectionAdapterScrollBarLeft = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point newLocationLeft = DuplicatesSourceView.this.m_duplicateSourceViewWidgetLeft.getSourceWidgetPosition();
                Point deltaPoint = new Point(newLocationLeft.x - DuplicatesSourceView.this.m_currentLocationLeft.x, newLocationLeft.y - DuplicatesSourceView.this.m_currentLocationLeft.y);
                DuplicatesSourceView.this.m_currentLocationLeft = newLocationLeft;
                DuplicatesSourceView.this.m_currentLocationRight = DuplicatesSourceView.this.m_duplicateSourceViewWidgetRight.adaptSourceWidgetLocation(deltaPoint);
            }
        };
        this.m_selectionAdapterScrollBarRight = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point newLocationRight = DuplicatesSourceView.this.m_duplicateSourceViewWidgetRight.getSourceWidgetPosition();
                Point deltaPoint = new Point(newLocationRight.x - DuplicatesSourceView.this.m_currentLocationRight.x, newLocationRight.y - DuplicatesSourceView.this.m_currentLocationRight.y);
                DuplicatesSourceView.this.m_currentLocationRight = newLocationRight;
                DuplicatesSourceView.this.m_currentLocationLeft = DuplicatesSourceView.this.m_duplicateSourceViewWidgetLeft.adaptSourceWidgetLocation(deltaPoint);
            }
        };
        this.m_selectionAdapterComboRight = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'widgetSelected' must not be null");
                }
                DuplicatesSourceView.this.syncBothDuplicateSourceViewWidgets(event, DuplicatesSourceView.this.m_duplicateSourceViewWidgetLeft, DuplicatesSourceView.this.m_duplicateSourceViewWidgetRight);
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(DuplicatesSourceView.this.getViewId(), DuplicatesSourceView.this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
                DuplicatesSourceView.this.completeViewNavigationState(state);
                ViewNavigationManager.getInstance().addNavigationState(state);
            }
        };
        this.m_selectionAdapterComboLeft = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'widgetSelected' must not be null");
                }
                DuplicatesSourceView.this.syncBothDuplicateSourceViewWidgets(event, DuplicatesSourceView.this.m_duplicateSourceViewWidgetLeft, DuplicatesSourceView.this.m_duplicateSourceViewWidgetRight);
                NavigationState state = ViewNavigationManager.getInstance().createNavigationState(DuplicatesSourceView.this.getViewId(), DuplicatesSourceView.this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
                DuplicatesSourceView.this.completeViewNavigationState(state);
                ViewNavigationManager.getInstance().addNavigationState(state);
            }
        };
        this.m_selectedBlock = SelectedBlock.LEFT;
        this.addListeners();
    }

    protected void destroyViewContent() {
        if (this.m_duplicateSourceViewWidgetLeft != null) {
            this.m_duplicateSourceViewWidgetLeft.dispose();
            this.m_duplicateSourceViewWidgetLeft = null;
        }
        if (this.m_duplicateSourceViewWidgetRight != null) {
            this.m_duplicateSourceViewWidgetRight.dispose();
            this.m_duplicateSourceViewWidgetRight = null;
        }
        super.destroyViewContent();
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        this.updateViewContent(elements, Collections.emptyMap());
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        this.m_selectedBlock = SelectedBlock.LEFT;
        assert (this.m_currentlyShownLeft != null) : "'m_currentlyShownLeft' of method 'selectElementsInView' must not be null";
        this.getSelectionProviderAdapter().handleSelectionChanged((Element)this.m_currentlyShownLeft.getParent());
        LanguageBasedSourceViewWidget.performOutOfDateCheck(this.getSoftwareSystem(), this.m_duplicateSourceViewWidgetLeft, this.m_duplicateSourceViewWidgetRight);
        WorkbenchRegistry.getInstance().selectView((IWorkbenchView)this);
    }

    private void updateViewContent(List<Element> elements, Map<IStateData, Object> stateData) {
        Element firstElement;
        assert (elements != null && elements.size() > 0) : "Parameter 'elements' of method 'updateViewContent' must not be empty";
        this.removeListeners();
        if (elements.get(0) instanceof Issue) {
            Element affectedElement = ((Issue)elements.get(0)).getAffectedElement();
            assert (affectedElement != null && affectedElement instanceof DuplicateCodeBlock) : "Unexpected class in method 'getPartName': " + String.valueOf(affectedElement);
            firstElement = affectedElement;
        } else {
            firstElement = elements.get(0);
        }
        this.m_items = new ArrayList<DuplicateCodeBlockOccurrence>();
        if (firstElement instanceof DuplicateCodeBlock) {
            DuplicateCodeBlock duplicateCodeBlock = (DuplicateCodeBlock)firstElement;
            this.m_items.addAll(duplicateCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class));
            this.m_currentlyShownLeft = this.m_items.get(0);
            this.m_currentlyShownRight = this.m_items.get(1);
        } else {
            assert (firstElement instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'getPartName': " + String.valueOf(firstElement);
            DuplicateCodeBlockOccurrence firstOccurrence = (DuplicateCodeBlockOccurrence)firstElement;
            this.m_items.addAll(((DuplicateCodeBlock)firstOccurrence.getParent(DuplicateCodeBlock.class, new Class[0])).getChildren(DuplicateCodeBlockOccurrence.class));
            this.m_currentlyShownLeft = firstOccurrence;
            if (elements.size() == 1) {
                int index = this.m_items.indexOf(firstOccurrence);
                ArrayList<DuplicateCodeBlockOccurrence> rotated = new ArrayList<DuplicateCodeBlockOccurrence>(this.m_items);
                Collections.rotate(rotated, rotated.size() - index);
                this.m_currentlyShownRight = (DuplicateCodeBlockOccurrence)rotated.get(1);
            } else {
                Element secondElement = elements.get(1);
                assert (elements.get(1) instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'getPartName': " + String.valueOf(secondElement);
                this.m_currentlyShownRight = (DuplicateCodeBlockOccurrence)secondElement;
            }
        }
        assert (this.m_items.size() > 1) : "At least two occurrences expected";
        String partName = ((DuplicateCodeBlock)this.m_items.get(0).getParent(DuplicateCodeBlock.class, new Class[0])).getName();
        assert (partName != null && partName.length() > 0) : "'partName' of method 'showInView' must not be empty";
        this.setPartName(partName);
        this.m_elementsForRestore.clear();
        for (Element element : elements) {
            this.m_elementsForRestore.add(element);
        }
        this.updateComboWidgetWithModelItems(this.m_comboLeft, this.m_items, this.m_currentlyShownLeft);
        this.updateComboWidgetWithModelItems(this.m_comboRight, this.m_items, this.m_currentlyShownRight);
        this.m_duplicateSourceViewWidgetLeft.setRedraw(false);
        this.m_duplicateSourceViewWidgetRight.setRedraw(false);
        int lineNumberLeft = stateData.get((Object)ViewData.LEFT_LINE_NUMBER) != null ? ((Integer)stateData.get((Object)ViewData.LEFT_LINE_NUMBER)).intValue() : this.m_currentlyShownLeft.getLineNumber();
        int lineNumberRight = stateData.get((Object)ViewData.RIGHT_LINE_NUMBER) != null ? ((Integer)stateData.get((Object)ViewData.RIGHT_LINE_NUMBER)).intValue() : this.m_currentlyShownRight.getLineNumber();
        this.updateDuplicateSourceViewWidgetWithModelItem(this.m_duplicateSourceViewWidgetLeft, this.m_currentlyShownLeft, lineNumberLeft);
        this.updateDuplicateSourceViewWidgetWithModelItem(this.m_duplicateSourceViewWidgetRight, this.m_currentlyShownRight, lineNumberRight);
        this.enquireMatchingLines(this.m_currentlyShownLeft, this.m_currentlyShownRight);
        this.m_duplicateSourceViewWidgetLeft.highlightDuplicateBlock(this.m_currentlyShownLeft.getBlockBegin(), this.m_currentlyShownLeft.getBlockBegin() + this.m_currentlyShownLeft.getBlockSize(), this.m_matchingLinesLeft);
        this.m_duplicateSourceViewWidgetRight.highlightDuplicateBlock(this.m_currentlyShownRight.getBlockBegin(), this.m_currentlyShownRight.getBlockBegin() + this.m_currentlyShownRight.getBlockSize(), this.m_matchingLinesRight);
        this.m_duplicateSourceViewWidgetLeft.setRedraw(true);
        this.m_duplicateSourceViewWidgetRight.setRedraw(true);
        this.m_currentLocationLeft = this.m_duplicateSourceViewWidgetLeft.getSourceWidgetPosition();
        this.m_currentLocationRight = this.m_duplicateSourceViewWidgetRight.getSourceWidgetPosition();
        this.addListeners();
    }

    private void syncBothDuplicateSourceViewWidgets(SelectionEvent event, DuplicateSourceViewWidget left, DuplicateSourceViewWidget right) {
        Combo combo;
        assert (event != null) : "Parameter 'event' of method 'syncBothDuplicateSourceViewWidgets' must not be null";
        assert (left != null) : "Parameter 'left' of method 'syncBothDuplicateSourceViewWidgets' must not be null";
        assert (right != null) : "Parameter 'right' of method 'syncBothDuplicateSourceViewWidgets' must not be null";
        Object sourceWidget = event.getSource();
        if (sourceWidget == null) {
            return;
        }
        if (sourceWidget instanceof Combo) {
            combo = (Combo)sourceWidget;
        } else if (sourceWidget instanceof MapBackedCombo) {
            combo = ((MapBackedCombo)((Object)sourceWidget)).getCombo();
        } else {
            return;
        }
        DuplicateCodeBlockOccurrence target = this.getItemDescribedAs(combo.getText(), this.m_items);
        if (target == null) {
            return;
        }
        this.removeListeners();
        if (combo.equals(this.m_comboRight.getCombo()) && !target.equals(this.m_currentlyShownRight)) {
            this.m_currentlyShownRight = target;
        } else if (combo.equals(this.m_comboLeft.getCombo()) && !target.equals(this.m_currentlyShownLeft)) {
            this.m_currentlyShownLeft = target;
        }
        this.updateDuplicateSourceViewWidgetWithModelItem(left, this.m_currentlyShownLeft, this.m_currentlyShownLeft.getLineNumber());
        this.updateDuplicateSourceViewWidgetWithModelItem(right, this.m_currentlyShownRight, this.m_currentlyShownRight.getLineNumber());
        this.clearMatchingLines();
        this.enquireMatchingLines(this.m_currentlyShownLeft, this.m_currentlyShownRight);
        this.m_duplicateSourceViewWidgetLeft.highlightDuplicateBlock(this.m_currentlyShownLeft.getBlockBegin(), this.m_currentlyShownLeft.getBlockBegin() + this.m_currentlyShownLeft.getBlockSize(), this.m_matchingLinesLeft);
        this.m_duplicateSourceViewWidgetRight.highlightDuplicateBlock(this.m_currentlyShownRight.getBlockBegin(), this.m_currentlyShownRight.getBlockBegin() + this.m_currentlyShownRight.getBlockSize(), this.m_matchingLinesRight);
        this.updateComboWidgetWithModelItems(this.m_comboLeft, this.m_items, this.m_currentlyShownLeft);
        this.updateComboWidgetWithModelItems(this.m_comboRight, this.m_items, this.m_currentlyShownRight);
        this.m_currentLocationLeft = this.m_duplicateSourceViewWidgetLeft.getSourceWidgetPosition();
        this.m_currentLocationRight = this.m_duplicateSourceViewWidgetRight.getSourceWidgetPosition();
        this.addListeners();
    }

    private void clearMatchingLines() {
        this.m_duplicateSourceViewWidgetLeft.clearDuplicateBlock();
        this.m_duplicateSourceViewWidgetRight.clearDuplicateBlock();
    }

    private void updateDuplicateSourceViewWidgetWithModelItem(DuplicateSourceViewWidget duplicateSourceViewWidget, DuplicateCodeBlockOccurrence currentlyShown, int lineNumber) {
        int targetLineNumber;
        int offset;
        assert (duplicateSourceViewWidget != null) : "Parameter 'duplicateSourceViewWidget' of method 'updateDuplicateSourceViewWidgetWithModelItem' must not be null";
        assert (currentlyShown != null) : "Parameter 'currentlyShown' of method 'updateDuplicateSourceViewWidgetWithModelItem' must not be null";
        duplicateSourceViewWidget.showSource((FilePath)currentlyShown.getSourceFile(), lineNumber, false, false, null);
        if (duplicateSourceViewWidget.isSourceAvailable() && (offset = duplicateSourceViewWidget.getOffsetAtLine(targetLineNumber = Math.min(lineNumber - 1, duplicateSourceViewWidget.getLineCount() - 1))) != -1) {
            duplicateSourceViewWidget.setSelection(offset, offset);
        }
    }

    private void updateComboWidgetWithModelItems(MapBackedCombo<DuplicateCodeBlockOccurrence> combo, List<DuplicateCodeBlockOccurrence> items, DuplicateCodeBlockOccurrence currentlyShownInThisDuplicateSourceViewWidget) {
        assert (combo != null) : "Parameter 'combo' of method 'updateComboWidgetWithModelItems' must not be null";
        assert (items != null && items.size() > 0) : "Parameter 'items' of method 'updateComboWidgetWithModelItems' must not be empty";
        assert (currentlyShownInThisDuplicateSourceViewWidget != null) : "Parameter 'currentlyShownInThisDuplicateSourceViewWidget' of method 'updateComboWidgetWithModelItems' must not be null";
        combo.removeAll();
        combo.setInput(items);
        SwtUtility.selectElementOfCombo((Combo)combo.getCombo(), (String)currentlyShownInThisDuplicateSourceViewWidget.composeDescription());
    }

    private void enquireMatchingLines(DuplicateCodeBlockOccurrence currentlyShownLeft, DuplicateCodeBlockOccurrence currentlyShownRight) {
        assert (currentlyShownLeft != null) : "Parameter 'currentlyShownLeft' of method 'enquireToleratedLines' must not be null";
        assert (currentlyShownRight != null) : "Parameter 'occurrence2' of method 'enquireToleratedLines' must not be null";
        if (this.sameParent(currentlyShownLeft, currentlyShownRight)) {
            int beginBlockLeft = currentlyShownLeft.getBlockBegin();
            int beginBlockRight = currentlyShownRight.getBlockBegin();
            List<String> subsetLeft = this.m_duplicateSourceViewWidgetLeft.getLinesSubsetWithEndTrim(beginBlockLeft, beginBlockLeft + currentlyShownLeft.getBlockSize());
            List<String> subsetRight = this.m_duplicateSourceViewWidgetRight.getLinesSubsetWithEndTrim(beginBlockRight, beginBlockRight + currentlyShownRight.getBlockSize());
            MatchingLinesOfTwoStrings matchingLinesOfTwoStrings = new MatchingLinesOfTwoStrings(subsetLeft, subsetRight);
            matchingLinesOfTwoStrings.computeMatchingLines();
            this.m_matchingLinesLeft = matchingLinesOfTwoStrings.getMatchingLinesLeft();
            this.m_matchingLinesRight = matchingLinesOfTwoStrings.getMatchingLinesRight();
        }
    }

    private void removeListeners() {
        this.m_duplicateSourceViewWidgetLeft.getVerticalScrollBar().removeSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarLeft);
        this.m_duplicateSourceViewWidgetLeft.getHorizontalScrollBar().removeSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarLeft);
        this.m_duplicateSourceViewWidgetRight.getVerticalScrollBar().removeSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarRight);
        this.m_duplicateSourceViewWidgetRight.getHorizontalScrollBar().removeSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarRight);
        this.m_comboLeft.removeSelectionListener((SelectionListener)this.m_selectionAdapterComboLeft);
        this.m_comboRight.removeSelectionListener((SelectionListener)this.m_selectionAdapterComboRight);
    }

    private void addListeners() {
        this.m_comboLeft.addSelectionListener((SelectionListener)this.m_selectionAdapterComboLeft);
        this.m_comboRight.addSelectionListener((SelectionListener)this.m_selectionAdapterComboRight);
        this.m_duplicateSourceViewWidgetLeft.getVerticalScrollBar().addSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarLeft);
        this.m_duplicateSourceViewWidgetLeft.getHorizontalScrollBar().addSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarLeft);
        this.m_duplicateSourceViewWidgetRight.getVerticalScrollBar().addSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarRight);
        this.m_duplicateSourceViewWidgetRight.getHorizontalScrollBar().addSelectionListener((SelectionListener)this.m_selectionAdapterScrollBarRight);
    }

    private DuplicateSourceViewWidget getSelectedWidget() {
        DuplicateSourceViewWidget widget = null;
        switch (this.m_selectedBlock) {
            case LEFT: {
                widget = this.m_duplicateSourceViewWidgetLeft;
                break;
            }
            case RIGHT: {
                widget = this.m_duplicateSourceViewWidgetRight;
                break;
            }
            default: {
                assert (false) : "Unhandled: " + String.valueOf((Object)this.m_selectedBlock);
                break;
            }
        }
        return widget;
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        DuplicateSourceViewWidget selectedWidget = this.getSelectedWidget();
        if (this.m_duplicateSourceViewWidgetLeft == selectedWidget) {
            return this.m_leftTextSearchProvider;
        }
        if (this.m_duplicateSourceViewWidgetRight == selectedWidget) {
            return this.m_rightTextSearchProvider;
        }
        assert (false) : "No source view widget selected";
        return null;
    }

    private final DuplicateCodeBlockOccurrence getItemDescribedAs(String selectedItemDescription, List<DuplicateCodeBlockOccurrence> items) {
        if (selectedItemDescription != null && selectedItemDescription.length() > 0 && items != null && items.size() > 0) {
            for (DuplicateCodeBlockOccurrence nextItem : items) {
                if (nextItem.composeDescription().compareTo(selectedItemDescription) != 0) continue;
                return nextItem;
            }
        }
        return null;
    }

    public List<Element> getSelectedElements() {
        if (this.m_currentlyShownLeft == null && this.m_currentlyShownRight == null) {
            return Collections.emptyList();
        }
        switch (this.m_selectedBlock) {
            case LEFT: {
                return this.getSelectionProviderAdapter().getElementList((Element)this.m_currentlyShownLeft.getParent());
            }
            case RIGHT: {
                return this.getSelectionProviderAdapter().getElementList((Element)this.m_currentlyShownRight.getParent());
            }
        }
        assert (false) : "Unhandled: " + String.valueOf((Object)this.m_selectedBlock);
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        if (event.getSource() == this.m_comboLeft) {
            this.m_selectedBlock = SelectedBlock.LEFT;
        } else if (event.getSource() == this.m_comboRight) {
            this.m_selectedBlock = SelectedBlock.RIGHT;
        } else assert (false) : "Unexpected source: " + String.valueOf(event.getSource());
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof DuplicateCodeBlockOccurrence) {
            return ((DuplicateCodeBlockOccurrence)element).getSourceFile();
        }
        return null;
    }

    private final boolean sameParent(DuplicateCodeBlockOccurrence firstOccurrence, DuplicateCodeBlockOccurrence secondOccurrence) {
        DuplicateCodeBlock parentBlockOfFirstOccurrence = (DuplicateCodeBlock)firstOccurrence.getParent();
        DuplicateCodeBlock parentBlockOfSecondOccurrence = (DuplicateCodeBlock)secondOccurrence.getParent();
        if (parentBlockOfFirstOccurrence != null && parentBlockOfSecondOccurrence != null) {
            return parentBlockOfFirstOccurrence.getSimpleId() == parentBlockOfSecondOccurrence.getSimpleId();
        }
        return false;
    }

    public List<Control> getViewComponents() {
        ArrayList<Control> components = new ArrayList<Control>(4);
        components.add((Control)this.m_comboLeft.getCombo());
        components.add((Control)this.m_comboRight.getCombo());
        components.addAll(this.m_duplicateSourceViewWidgetLeft.getControls());
        components.addAll(this.m_duplicateSourceViewWidgetRight.getControls());
        return components;
    }

    public Control getSelectedViewComponent() {
        if (this.m_selectedBlock == SelectedBlock.LEFT) {
            return this.m_duplicateSourceViewWidgetLeft.getMainControl();
        }
        return this.m_duplicateSourceViewWidgetRight.getMainControl();
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        SelectedBlock currentlySelectedBlock = this.m_selectedBlock;
        this.m_selectedBlock = null;
        if (this.m_comboLeft.getCombo() == component) {
            this.m_selectedBlock = SelectedBlock.LEFT;
        } else if (this.m_comboRight.getCombo() == component) {
            this.m_selectedBlock = SelectedBlock.RIGHT;
        } else if (this.m_duplicateSourceViewWidgetLeft.getControls().contains(component)) {
            this.m_selectedBlock = SelectedBlock.LEFT;
        } else if (this.m_duplicateSourceViewWidgetRight.getControls().contains(component)) {
            this.m_selectedBlock = SelectedBlock.RIGHT;
        }
        if (this.m_selectedBlock == null) {
            this.m_selectedBlock = currentlySelectedBlock;
        }
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.removeListeners();
        Iterator leftIterator = state.getElements((IElementGroup)ElementsInView.LEFT_ELEMENT, DuplicateCodeBlockOccurrence.class, this.getElementResolver()).iterator();
        Iterator rightIterator = state.getElements((IElementGroup)ElementsInView.RIGHT_ELEMENT, DuplicateCodeBlockOccurrence.class, this.getElementResolver()).iterator();
        if (leftIterator.hasNext() && rightIterator.hasNext()) {
            DuplicateCodeBlockOccurrence right;
            int leftLine = state.getInt((IStateData)ViewData.LEFT_LINE_NUMBER);
            int rightLine = state.getInt((IStateData)ViewData.RIGHT_LINE_NUMBER);
            DuplicateCodeBlockOccurrence left = (DuplicateCodeBlockOccurrence)leftIterator.next();
            if (left != this.m_currentlyShownLeft) {
                SwtUtility.selectElementOfCombo((Combo)this.m_comboLeft.getCombo(), (String)left.composeDescription());
                Event e = new Event();
                e.widget = this.m_comboLeft;
                e.data = Boolean.FALSE;
                SelectionEvent event = new SelectionEvent(e);
                this.m_selectionAdapterComboLeft.widgetSelected(event);
            }
            if ((right = (DuplicateCodeBlockOccurrence)rightIterator.next()) != this.m_currentlyShownRight) {
                SwtUtility.selectElementOfCombo((Combo)this.m_comboRight.getCombo(), (String)right.composeDescription());
                Event e = new Event();
                e.widget = this.m_comboRight;
                e.data = Boolean.FALSE;
                SelectionEvent event = new SelectionEvent(e);
                this.m_selectionAdapterComboRight.widgetSelected(event);
            }
            this.m_duplicateSourceViewWidgetLeft.gotoLine(leftLine, false);
            this.m_duplicateSourceViewWidgetRight.gotoLine(rightLine, false);
            SelectedBlock selectedBlock = (SelectedBlock)state.getConstant((IStateData)ViewData.SELECTED_BLOCK);
            if (selectedBlock != null) {
                int selectionStartOffset = state.getInt((IStateData)ViewData.SELECTION_START_OFFSET);
                int selectionEndOffset = state.getInt((IStateData)ViewData.SELECTION_END_OFFSET);
                DuplicateSourceViewWidget currentWidget = selectedBlock == SelectedBlock.LEFT ? this.m_duplicateSourceViewWidgetLeft : this.m_duplicateSourceViewWidgetRight;
                currentWidget.setFocus();
                currentWidget.setSelection(selectionStartOffset, selectionEndOffset);
            }
        }
        this.addListeners();
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        state.addElementsInformation((IElementGroup)ElementGroup.ELEMENTS_FOR_VIEW, NavigationState.getDescriptors(this.m_elementsForRestore, (IElementResolver)this.getElementResolver()));
        state.addElementsInformation((IElementGroup)ElementsInView.LEFT_ELEMENT, NavigationState.getDescriptors(Arrays.asList(this.m_currentlyShownLeft), (IElementResolver)this.getElementResolver()));
        state.addElementsInformation((IElementGroup)ElementsInView.RIGHT_ELEMENT, NavigationState.getDescriptors(Arrays.asList(this.m_currentlyShownRight), (IElementResolver)this.getElementResolver()));
        state.addInt((IStateData)ViewData.LEFT_LINE_NUMBER, this.m_duplicateSourceViewWidgetLeft.getFirstVisibleLineNumber());
        state.addInt((IStateData)ViewData.RIGHT_LINE_NUMBER, this.m_duplicateSourceViewWidgetRight.getFirstVisibleLineNumber());
        state.addConstant((IStateData)ViewData.SELECTED_BLOCK, (Enum)this.m_selectedBlock);
        if (this.m_selectedBlock != null) {
            DuplicateSourceViewWidget currentWidget = this.m_selectedBlock == SelectedBlock.LEFT ? this.m_duplicateSourceViewWidgetLeft : this.m_duplicateSourceViewWidgetRight;
            state.addInt((IStateData)ViewData.SELECTION_START_OFFSET, currentWidget.getOffsetsForSelection().x);
            state.addInt((IStateData)ViewData.SELECTION_END_OFFSET, currentWidget.getOffsetsForSelection().y);
        }
    }

    @Override
    public String getText(DuplicateCodeBlockOccurrence item) {
        assert (item != null) : "Parameter 'item' of method 'getText' must not be null";
        return item.composeDescription();
    }

    public void zoomIn(Point location) {
        this.m_duplicateSourceViewWidgetLeft.zoomIn();
        this.m_duplicateSourceViewWidgetRight.zoomIn();
    }

    public void zoomOut(Point location) {
        this.m_duplicateSourceViewWidgetLeft.zoomOut();
        this.m_duplicateSourceViewWidgetRight.zoomOut();
    }

    private static enum ElementsInView implements IElementGroup
    {
        LEFT_ELEMENT,
        RIGHT_ELEMENT;

    }

    private static enum SelectedBlock implements IStandardEnumeration
    {
        LEFT,
        RIGHT;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ViewData implements IStateData
    {
        LEFT_LINE_NUMBER,
        RIGHT_LINE_NUMBER,
        SELECTED_BLOCK,
        SELECTION_END_OFFSET,
        SELECTION_START_OFFSET;

    }
}

