/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Date;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class SelectBaselineTypePage
extends StandardWizardPage {
    public static final String GENERAL_INFO = "A baseline is used to track and report changes of a software system. Changes are visualized in the System view (dashboard) via trends and in the System Diff view in more detail. Using a baseline also allows you to define quality gate conditions with respect to that baseline.";
    public static final String SYSTEM_BASELINE_INFO = "A system baseline is meant to be useful for all Sonargraph users and clients and is usually located within the software system's baselines directory and committed into the version control system.";
    public static final String LOCAL_BASELINE_INFO = "A local baseline is normally only useful for this machine. It is not necessarily located within the software system's baselines directory and not necessarily committed into the version control system.";
    private static final IDialogId ID = CoreDialogId.SELECT_BASELINE_TYPE;
    private final Mode m_mode;
    private final String m_baselinePath;
    private final BaselineInfo m_baselineInfo;
    private BaselineType m_baselineType = BaselineType.SYSTEM;

    SelectBaselineTypePage(Mode mode) {
        super(ID.getStandardName(), ID.getPresentationName());
        assert (mode != null) : "Parameter 'mode' of method 'SelectBaselineTypePage' must not be null";
        this.m_mode = mode;
        this.m_baselinePath = null;
        this.m_baselineInfo = null;
    }

    SelectBaselineTypePage(Mode mode, String baselinePath, BaselineInfo baselineInfo) {
        super(ID.getStandardName(), ID.getPresentationName());
        assert (mode != null) : "Parameter 'mode' of method 'SelectBaselineTypePage' must not be null";
        assert (baselinePath != null && baselinePath.length() > 0) : "Parameter 'baselinePath' of method 'SelectBaselineTypePage' must not be empty";
        assert (baselineInfo != null) : "Parameter 'baselineInfo' of method 'SelectBaselineTypePage' must not be null";
        this.m_mode = mode;
        this.m_baselinePath = baselinePath;
        this.m_baselineInfo = baselineInfo;
    }

    public IDialogId getDialogId() {
        return ID;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        if (this.m_baselinePath != null) {
            Label pathLabel = new Label(composite, 0);
            pathLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            pathLabel.setText("Baseline:");
            Label path = new Label(composite, 0);
            path.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            path.setText(this.m_baselinePath);
            if (this.m_baselineInfo != null) {
                Label creationLabel = new Label(composite, 0);
                creationLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                creationLabel.setText("Creation:");
                Label creation = new Label(composite, 0);
                creation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                creation.setText(Iso8601DateFormat.formatDate((Date)this.m_baselineInfo.getCreationTime()));
                Label descriptionLabel = new Label(composite, 0);
                descriptionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                descriptionLabel.setText("Description:");
                Label description = new Label(composite, 0);
                description.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                description.setText(this.m_baselineInfo.getDescription());
            }
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        if (this.m_mode == Mode.CREATE) {
            Label genaralInfo = new Label(composite, 64);
            genaralInfo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            genaralInfo.setText(GENERAL_INFO);
        }
        Label systemBaselineInfo = new Label(composite, 64);
        systemBaselineInfo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        systemBaselineInfo.setText(SYSTEM_BASELINE_INFO);
        Label localBaselineInfo = new Label(composite, 64);
        localBaselineInfo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        localBaselineInfo.setText(LOCAL_BASELINE_INFO);
        final Button system = new Button(composite, 16);
        system.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        system.setText("System");
        Button local = new Button(composite, 16);
        local.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        local.setText("Local");
        system.setSelection(true);
        system.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectBaselineTypePage.this.m_baselineType = system.getSelection() ? BaselineType.SYSTEM : BaselineType.LOCAL;
            }
        });
    }

    public boolean canFlipToNextPage() {
        return this.m_baselineType != null;
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public BaselineType getBaselineType() {
        return this.m_baselineType;
    }

    public static enum Mode {
        CREATE,
        OPEN;

    }
}

