/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.consoleview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.script.BufferedOutputStream;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.StandaloneOutputStreamProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.StyledTextBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsoleView
extends WorkbenchView
implements StandaloneOutputStreamProvider.IOutputStreamLifecycleListener,
BufferedOutputStream.IContentChangedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleView.class);
    private final Set<BufferedOutputStream> m_buffersForManuallyExecuted = new HashSet<BufferedOutputStream>();
    private BufferedOutputStream m_current;
    private StyledText m_text;
    private StyledTextBasedTextSearchHandler m_textSearchHandler;

    public IViewId getViewId() {
        return ViewId.CONSOLE_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected boolean supportsSleep() {
        return false;
    }

    public List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_text);
    }

    public boolean supportsCopy() {
        String selection = this.m_text.getSelectionText();
        return selection != null && !selection.isEmpty();
    }

    public String copy() {
        String selection = this.m_text.getSelectionText();
        assert (selection != null && selection.length() > 0) : "'selection' of method 'getCopyToClipBoardData' must not be empty";
        return selection;
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_text = new StyledText(viewContentArea, 776);
        this.m_text.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_textSearchHandler = new StyledTextBasedTextSearchHandler(this.m_text, false, this.getViewId().getPresentationName());
        List<BufferedOutputStream> streams = StandaloneOutputStreamProvider.getInstance().getBufferedOutputStreams();
        int i = 0;
        while (i < streams.size()) {
            BufferedOutputStream nextStream = streams.get(i);
            if (i == 0) {
                this.m_current = nextStream;
                this.m_text.setText(this.m_current.getContent());
                this.setPartName(this.m_current.getId());
                this.m_current.addContentListener((BufferedOutputStream.IContentChangedListener)this);
            }
            if (!nextStream.isAutomated()) {
                this.m_buffersForManuallyExecuted.add(nextStream);
                if (i > 0) {
                    nextStream.addContentListener((BufferedOutputStream.IContentChangedListener)this);
                }
            }
            ++i;
        }
        StandaloneOutputStreamProvider.getInstance().addLifecycleListener(this);
    }

    public boolean clearConsolePossible() {
        return this.isActive() && !this.m_text.getText().isEmpty();
    }

    public void clearConsole() {
        this.updateText("");
        if (this.m_current != null) {
            this.m_current.reset();
        }
    }

    private void updateText(String input) {
        assert (input != null) : "Parameter 'input' of method 'updateText' must not be null";
        if (this.isActive()) {
            this.m_text.setRedraw(false);
            this.m_text.setText(input);
            this.m_text.setRedraw(true);
        }
    }

    public void showConsole(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'showConsole' must not be empty";
        if (this.m_current != null && this.m_current.getId().equals(id)) {
            return;
        }
        if (this.m_current != null && this.m_current.isAutomated()) {
            this.m_current.removeContentListener((BufferedOutputStream.IContentChangedListener)this);
        }
        this.m_current = StandaloneOutputStreamProvider.getInstance().getBufferedOutputStream(id);
        assert (this.m_current != null) : "'m_current' of method 'showConsole' must not be null";
        this.updateText(this.m_current.getContent());
        if (this.m_current.isAutomated()) {
            this.m_current.addContentListener((BufferedOutputStream.IContentChangedListener)this);
        }
        this.setPartName(id);
    }

    protected synchronized void destroyViewContent() {
        for (BufferedOutputStream next : this.m_buffersForManuallyExecuted) {
            next.removeContentListener((BufferedOutputStream.IContentChangedListener)this);
        }
        this.m_buffersForManuallyExecuted.clear();
        if (this.m_current != null) {
            if (this.m_current.isAutomated()) {
                this.m_current.removeContentListener((BufferedOutputStream.IContentChangedListener)this);
            }
            this.m_current = null;
            this.resetPartName();
        }
        StandaloneOutputStreamProvider.getInstance().removeLifecycleListener(this);
        super.destroyViewContent();
    }

    @Override
    public void added(List<BufferedOutputStream> all, BufferedOutputStream added, boolean isAutomated) {
        assert (all != null) : "Parameter 'all' of method 'added' must not be null";
        assert (added != null) : "Parameter 'added' of method 'added' must not be null";
        if (!isAutomated) {
            boolean addedNew = this.m_buffersForManuallyExecuted.add(added);
            if (this.m_current != null) {
                if (this.m_current.isAutomated()) {
                    this.m_current.removeContentListener((BufferedOutputStream.IContentChangedListener)this);
                }
                this.m_current = null;
            }
            this.m_current = added;
            this.updateText(this.m_current.getContent());
            if (addedNew) {
                this.m_current.addContentListener((BufferedOutputStream.IContentChangedListener)this);
            }
            this.setPartName(this.m_current.getId());
        } else if (this.m_current == null && !all.isEmpty()) {
            this.m_current = all.get(0);
            this.updateText(this.m_current.getContent());
            this.m_current.addContentListener((BufferedOutputStream.IContentChangedListener)this);
            this.setPartName(this.m_current.getId());
        }
    }

    @Override
    public synchronized void removed(List<BufferedOutputStream> all, BufferedOutputStream ... removed) {
        assert (all != null) : "Parameter 'all' of method 'removed' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'removed' must not be null";
        if (!this.isActive()) {
            LOGGER.info("View has already been destroyed");
            return;
        }
        BufferedOutputStream[] bufferedOutputStreamArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            BufferedOutputStream next = bufferedOutputStreamArray[n2];
            if (this.m_current == next) {
                this.updateText("");
                this.m_current.removeContentListener((BufferedOutputStream.IContentChangedListener)this);
                this.m_current = null;
                this.resetPartName();
            }
            if (!next.isAutomated()) {
                assert (this.m_buffersForManuallyExecuted.contains(next)) : "Buffer '" + next.getId() + "' not contained in set for manually executed scripts";
                this.m_buffersForManuallyExecuted.remove(next);
            }
            ++n2;
        }
        if (this.m_current == null && !all.isEmpty()) {
            this.m_current = all.get(0);
            this.updateText(this.m_current.getContent());
            if (this.m_current.isAutomated()) {
                this.m_current.addContentListener((BufferedOutputStream.IContentChangedListener)this);
            }
            if (!this.m_current.isAutomated() && !this.m_buffersForManuallyExecuted.contains(this.m_current)) {
                this.m_buffersForManuallyExecuted.add(this.m_current);
            }
            this.setPartName(this.m_current.getId());
        }
    }

    @Override
    public void pathModified(final Map<BufferedOutputStream, BufferedOutputStream> previousToNewBufferMap, final List<BufferedOutputStream> allBuffers) {
        assert (previousToNewBufferMap != null) : "Parameter 'previousToNewBufferMap' of method 'pathModified' must not be null";
        if (this.m_current != null && previousToNewBufferMap.containsKey(this.m_current)) {
            BufferedOutputStream newCurrent = previousToNewBufferMap.get(this.m_current);
            allBuffers.remove(newCurrent);
            allBuffers.add(0, newCurrent);
        }
        for (Map.Entry<BufferedOutputStream, BufferedOutputStream> next : previousToNewBufferMap.entrySet()) {
            BufferedOutputStream moved = next.getValue();
            if (moved.isAutomated()) continue;
            this.m_buffersForManuallyExecuted.add(moved);
            moved.addContentListener((BufferedOutputStream.IContentChangedListener)this);
        }
        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

            @Override
            public void run() {
                ConsoleView.this.removed(allBuffers, previousToNewBufferMap.keySet().toArray(new BufferedOutputStream[0]));
            }
        });
    }

    public void outputAdded(final BufferedOutputStream consoleOutputStream, final String newContent) {
        assert (newContent != null) : "Parameter 'newContent' of method 'outputAdded' must not be null";
        if (this.m_current == consoleOutputStream) {
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    if (ConsoleView.this.m_text != null && !ConsoleView.this.m_text.isDisposed()) {
                        ConsoleView.this.m_text.append(newContent);
                        ConsoleView.this.m_text.setTopIndex(ConsoleView.this.m_text.getLineCount() - 1);
                    }
                }
            });
        } else if (!consoleOutputStream.isAutomated()) {
            assert (this.m_buffersForManuallyExecuted.contains(consoleOutputStream)) : "buffer not contained in set for manually executed scripts";
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    ConsoleView.this.showConsole(consoleOutputStream.getId());
                }
            });
        }
    }

    public void outputCleared(BufferedOutputStream consoleOutputStream) {
        if (this.m_current == consoleOutputStream) {
            UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                @Override
                public void run() {
                    ConsoleView.this.updateText("");
                }
            });
        }
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchHandler;
    }

    public List<Element> getSelectedElements() {
        return Collections.emptyList();
    }
}

