/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.event.NotificationAddedEvent;
import com.hello2morrow.sonargraph.core.model.event.NotificationsRemovedEvent;
import com.hello2morrow.sonargraph.core.model.system.INotificationProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.Notification;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class NotificationWidget
implements MouseListener,
ISonargraphUIContribution {
    private static final int DISPLAY_TIME = 5000;
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int FINAL_ALPHA = 225;
    private final List<Shell> m_activeShells = new ArrayList<Shell>();
    private Label m_notificationLabel;
    private boolean m_firstNotification = true;

    private void fadeIn(final Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'fadeIn' must not be null";
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                int currentAlpha = shell.getAlpha();
                if ((currentAlpha += 30) > 225) {
                    shell.setAlpha(225);
                    NotificationWidget.this.startTimer(shell);
                    return;
                }
                shell.setAlpha(currentAlpha);
                shell.getDisplay().timerExec(50, (Runnable)this);
            }
        };
        shell.getDisplay().timerExec(50, run);
    }

    private void startTimer(final Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'startTimer' must not be null";
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                NotificationWidget.this.fadeOut(shell);
            }
        };
        shell.getDisplay().timerExec(5000, run);
    }

    private void fadeOut(final Shell shell) {
        assert (shell != null) : "Parameter 'shell' of method 'fadeOut' must not be null";
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                int currentAlpha = shell.getAlpha();
                if ((currentAlpha -= 8) <= 0) {
                    shell.setAlpha(0);
                    shell.dispose();
                    return;
                }
                shell.setAlpha(currentAlpha);
                shell.getDisplay().timerExec(50, (Runnable)this);
            }
        };
        shell.getDisplay().timerExec(50, run);
    }

    private Image getImage(Severity severity) {
        assert (severity != null) : "Parameter 'severity' of method 'getImage' must not be null";
        switch (severity) {
            case ERROR: {
                return UiResourceManager.getInstance().getImage("Error");
            }
            case INFO: {
                return UiResourceManager.getInstance().getImage("Info");
            }
            case WARNING: {
                return UiResourceManager.getInstance().getImage("Warning");
            }
            case NONE: {
                return UiResourceManager.getInstance().getImage("None");
            }
        }
        assert (false) : "Unhandled severity: " + String.valueOf(severity);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void show(Shell parentShell, Notification notification, int anchorX, int anchorY) {
        assert (parentShell != null) : "Parameter 'parentShell' of method 'show' must not be null";
        assert (notification != null) : "Parameter 'notification' of method 'show' must not be null";
        List<Shell> list = this.m_activeShells;
        synchronized (list) {
            final Shell shell = new Shell(parentShell, 8);
            shell.setBackground(UiResourceManager.getInstance().getForegroundColor());
            GridLayout shellGridLayout = new GridLayout(1, true);
            shellGridLayout.marginBottom = 1;
            shellGridLayout.marginHeight = 0;
            shellGridLayout.marginLeft = 1;
            shellGridLayout.marginRight = 1;
            shellGridLayout.marginTop = 1;
            shellGridLayout.marginWidth = 0;
            shellGridLayout.verticalSpacing = 0;
            shellGridLayout.horizontalSpacing = 0;
            shell.setLayout((Layout)shellGridLayout);
            Composite composite = new Composite((Composite)shell, 0);
            composite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout compositeGridLayout = new GridLayout(1, true);
            compositeGridLayout.marginBottom = 5;
            compositeGridLayout.marginHeight = 0;
            compositeGridLayout.marginLeft = 1;
            compositeGridLayout.marginRight = 1;
            compositeGridLayout.marginTop = 5;
            compositeGridLayout.marginWidth = 0;
            compositeGridLayout.verticalSpacing = 1;
            compositeGridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)compositeGridLayout);
            CLabel imageAndText = new CLabel(composite, 0);
            imageAndText.setImage(this.getImage(notification.getSeverity()));
            imageAndText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            imageAndText.setForeground(UiResourceManager.getInstance().getForegroundColor());
            imageAndText.setBackground(UiResourceManager.getInstance().getBackgroundColor());
            imageAndText.setText(notification.getText());
            Point shellSize = shell.computeSize(-1, -1);
            int width = shellSize.x;
            int height = shellSize.y;
            if (!this.m_activeShells.isEmpty()) {
                ListIterator<Shell> listIterator = this.m_activeShells.listIterator(this.m_activeShells.size());
                while (listIterator.hasPrevious()) {
                    Shell nextShell = listIterator.previous();
                    Point curLoc = nextShell.getLocation();
                    nextShell.setLocation(curLoc.x, curLoc.y - height + 1);
                    if (curLoc.y - height >= 0) continue;
                    nextShell.dispose();
                }
            }
            shell.setLocation(anchorX - width, anchorY - height);
            shell.setAlpha(0);
            shell.pack();
            shell.setVisible(true);
            shell.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    Image backgroundImage = shell.getBackgroundImage();
                    if (backgroundImage != null) {
                        backgroundImage.dispose();
                    }
                    NotificationWidget.this.m_activeShells.remove(shell);
                }
            });
            parentShell.addControlListener((ControlListener)new ResizeListener(parentShell, shell));
            this.m_activeShells.add(shell);
            this.fadeIn(shell);
        }
    }

    private int getAnchorYOffset() {
        if (Platform.isMac()) {
            return 0;
        }
        if (Platform.isLinux()) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(List<Notification> notifications) {
        assert (notifications != null && !notifications.isEmpty()) : "Parameter 'notifications' of method 'notify' must not be empty";
        List<Shell> list = this.m_activeShells;
        synchronized (list) {
            new ArrayList<Shell>(this.m_activeShells).forEach(s -> s.dispose());
        }
        Shell parentShell = WorkbenchRegistry.getInstance().getMainApplicationWindowShell();
        Rectangle widgetBounds = WorkbenchRegistry.getInstance().getDisplay().map((Control)this.m_notificationLabel, null, this.m_notificationLabel.getBounds());
        int x = widgetBounds.x + widgetBounds.width;
        int y = widgetBounds.y - this.getAnchorYOffset();
        notifications.forEach(n3 -> this.show(parentShell, (Notification)n3, x, y));
    }

    private void setNumberOfNotifications(List<Notification> notifications) {
        assert (notifications != null) : "Parameter 'notifications' of method 'setNumberOfNotifications' must not be null";
        String notificationImage = "NoNotifications";
        if (notifications.size() > 0) {
            boolean hasErrors = false;
            boolean hasWarnings = false;
            for (Notification nextNotification : notifications) {
                if (nextNotification.getSeverity() == Severity.ERROR) {
                    hasErrors = true;
                    break;
                }
                if (nextNotification.getSeverity() != Severity.WARNING) continue;
                hasWarnings = true;
            }
            notificationImage = hasErrors ? "ErrorNotifications" : (hasWarnings ? "WarningNotifications" : "InfoNotifications");
        }
        this.m_notificationLabel.setImage(UiResourceManager.getInstance().getImage(notificationImage));
    }

    @PostConstruct
    public void createWidget(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createWidget' must not be null";
        this.m_notificationLabel = new Label(parent, 0);
        EventManager.getInstance().attach((EventHandler)new EventHandler<NotificationAddedEvent>(NotificationAddedEvent.class, (Object)this){

            public void handleEvent(NotificationAddedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                NotificationWidget.this.handleNotificationsModified(event.getProvider().getInstallation(), event.getNotification());
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<NotificationsRemovedEvent>(NotificationsRemovedEvent.class, (Object)this){

            public void handleEvent(NotificationsRemovedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                NotificationWidget.this.handleNotificationsModified(event.getProvider().getInstallation(), null);
            }
        });
        this.setNumberOfNotifications(Collections.emptyList());
        this.m_notificationLabel.addMouseListener((MouseListener)this);
    }

    private void handleNotificationsModified(Installation installation, Notification addedNotification) {
        assert (installation != null) : "Parameter 'installation' of method 'handleMessagesModified' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            if (this.m_firstNotification) {
                this.notifiyExistingNotifications();
            } else {
                this.setNumberOfNotifications(installation.getAllNotifications());
                if (addedNotification != null) {
                    this.notify(Collections.singletonList(addedNotification));
                }
            }
        }
    }

    private void notifiyExistingNotifications() {
        if (WorkbenchRegistry.isRunning()) {
            Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
            List notifications = installation.getAllNotifications();
            this.setNumberOfNotifications(notifications);
            if (!notifications.isEmpty()) {
                this.notify(notifications);
                if (!this.m_firstNotification) {
                    ((INotificationProvider)installation.getExtension(INotificationProvider.class)).notificationsConsumed();
                }
            }
            this.m_firstNotification = false;
        }
    }

    public void mouseDown(MouseEvent event) {
        this.notifiyExistingNotifications();
    }

    public void mouseDoubleClick(MouseEvent event) {
        this.notifiyExistingNotifications();
    }

    public void mouseUp(MouseEvent event) {
    }

    @PreDestroy
    public void dispose() {
        EventManager.getInstance().detach(NotificationAddedEvent.class, (Object)this);
        EventManager.getInstance().detach(NotificationsRemovedEvent.class, (Object)this);
    }

    private static class ResizeListener
    implements ControlListener,
    DisposeListener {
        private final Shell m_parentShell;
        private final Shell m_notificationShell;
        private Rectangle m_currentBoundsOfParentShell;

        ResizeListener(Shell parentShell, Shell notificationShell) {
            assert (parentShell != null) : "Parameter 'parentShell' of method 'ResizeListener' must not be null";
            assert (notificationShell != null) : "Parameter 'notificationShell' of method 'ResizeListener' must not be null";
            this.m_parentShell = parentShell;
            this.m_notificationShell = notificationShell;
            this.m_currentBoundsOfParentShell = parentShell.getBounds();
            this.m_notificationShell.addDisposeListener((DisposeListener)this);
        }

        private void updateLocation() {
            Rectangle newBoundsOfParentShell = this.m_parentShell.getBounds();
            int dx = newBoundsOfParentShell.x - this.m_currentBoundsOfParentShell.x + newBoundsOfParentShell.width - this.m_currentBoundsOfParentShell.width;
            int dy = newBoundsOfParentShell.y - this.m_currentBoundsOfParentShell.y + newBoundsOfParentShell.height - this.m_currentBoundsOfParentShell.height;
            Point currentLocation = this.m_notificationShell.getLocation();
            this.m_notificationShell.setLocation(currentLocation.x + dx, currentLocation.y + dy);
            this.m_currentBoundsOfParentShell = newBoundsOfParentShell;
        }

        public void controlResized(ControlEvent event) {
            this.updateLocation();
        }

        public void controlMoved(ControlEvent event) {
            this.updateLocation();
        }

        public void widgetDisposed(DisposeEvent event) {
            if (this.m_parentShell != null && !this.m_parentShell.isDisposed()) {
                this.m_parentShell.removeControlListener((ControlListener)this);
            }
        }
    }
}

