/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Translatable;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElement;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import java.util.Set;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

public final class DrawableWidgetDragAndDropAdapter<T extends RepresentationElement>
extends DropTargetAdapter
implements DragSourceListener {
    private final DragSource m_dragSource;
    private final DropTarget m_dropTarget;
    private final IDrawableWidgetDragAndDropActionHandler<T> m_listener;
    private DrawableWidget m_widget;
    private Set<T> m_selection;
    private T m_target;
    private final DrawableSlaveView m_drawableSlaveView;

    public DrawableWidgetDragAndDropAdapter(DrawableSlaveView drawableSlaveView, IDrawableWidgetDragAndDropActionHandler<T> listener) {
        assert (drawableSlaveView != null) : "Parameter 'drawableSlaveView' of method 'DrawableWidgetDragAndDropAdapter' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'DrawableWidgetDragAndDropAdapter' must not be null";
        this.m_drawableSlaveView = drawableSlaveView;
        this.m_widget = drawableSlaveView.getDrawableWidget();
        this.m_dragSource = new DragSource((Control)this.m_widget, 2);
        this.m_dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        this.m_dragSource.addDragListener((DragSourceListener)this);
        this.m_dropTarget = new DropTarget((Control)this.m_widget, 2);
        this.m_dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        this.m_dropTarget.addDropListener((DropTargetListener)this);
        this.m_listener = listener;
    }

    public void dragStart(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragStart' must not be null";
        if (this.m_drawableSlaveView.getElementInteractor().dragAndDropStarted()) {
            Set selection = this.m_widget.getSelectedElements();
            if (selection.isEmpty() || !this.m_listener.validateDrag(selection)) {
                event.doit = false;
                this.m_drawableSlaveView.getElementInteractor().dragAndDropFinished();
            } else {
                this.m_selection = selection;
            }
        } else {
            event.doit = false;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragSetData' must not be null";
        this.m_selection = this.m_widget.getSelectedElements();
        event.data = this.m_selection;
    }

    public void dragOver(DropTargetEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dropAccept' must not be null";
        org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(event.x, event.y);
        Layer nodesLayer = this.m_widget.getNodesLayer();
        point = this.m_widget.toControl(point);
        Point draw2DPoint = new Point(point);
        nodesLayer.translateToRelative((Translatable)draw2DPoint);
        IFigure nodesLayerFigure = nodesLayer.findFigureAt(draw2DPoint.x, draw2DPoint.y);
        this.m_target = null;
        if (nodesLayerFigure != null && nodesLayerFigure instanceof DrawableNode) {
            DrawableNode targetNode = (DrawableNode)nodesLayerFigure;
            this.m_target = targetNode.getRepresentationElement();
        }
        if (this.m_target == null || this.m_selection == null || !this.m_listener.validateDrop(this.m_target)) {
            event.detail = 0;
            this.m_drawableSlaveView.getElementInteractor().dragAndDropFinished();
        } else {
            event.detail = 2;
        }
    }

    public void drop(DropTargetEvent event) {
        assert (event != null) : "Parameter 'event' of method 'drop' must not be null";
        if (this.m_target == null || this.m_selection == null || !this.m_listener.perform(this.m_target, this.m_selection, this.m_widget)) {
            event.detail = 0;
            this.m_drawableSlaveView.getElementInteractor().dragAndDropFinished();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        assert (event != null) : "Parameter 'event' of method 'dragFinished' must not be null";
        this.m_target = null;
        this.m_selection = null;
        this.m_listener.cleanUpDrag();
        this.m_drawableSlaveView.getElementInteractor().dragAndDropFinished();
    }

    public void clear() {
        this.m_dragSource.removeDragListener((DragSourceListener)this);
        this.m_dropTarget.removeDropListener((DropTargetListener)this);
        this.m_widget = null;
        this.m_selection = null;
    }

    public static interface IDrawableWidgetDragAndDropActionHandler<T> {
        public boolean validateDrag(Set<T> var1);

        public boolean validateDrop(T var1);

        public boolean perform(T var1, Set<T> var2, DrawableWidget var3);

        public void cleanUpDrag();
    }
}

