/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultClearedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultStateChangedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzersStartedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AnalyzersStatusLineWidget
implements ISonargraphUIContribution {
    private Composite m_composite;
    private Label m_imageLabel;
    private Composite m_canvas;
    private PaintListener m_paintListener;
    private Label m_statusLabel;
    private String m_statusText = "";
    private static final String DEFAULT_TOOLTIP_TEXT = "Analyzer Status";
    private String m_tooltipText = "Analyzer Status";
    private int m_toRun;
    private int m_finished;
    private boolean m_showProgress = false;
    private GridData m_canvasGridData;
    private GridData m_statusLabelGridData;

    @PostConstruct
    public void createWidget(Composite parent) {
        this.m_composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        this.m_composite.setLayout((Layout)gridLayout);
        this.m_imageLabel = new Label(this.m_composite, 16384);
        this.m_imageLabel.setImage(UiResourceManager.getInstance().getImage("AnalyzersView"));
        GridData imageGridData = new GridData(0, 0x1000000, false, false);
        imageGridData.widthHint = 16;
        this.m_imageLabel.setLayoutData((Object)imageGridData);
        this.m_imageLabel.setToolTipText(this.m_tooltipText);
        this.m_statusLabel = new Label(this.m_composite, 16384);
        this.m_statusLabelGridData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.m_statusLabelGridData.widthHint = 180;
        this.m_statusLabel.setLayoutData((Object)this.m_statusLabelGridData);
        this.m_canvas = new Composite(this.m_composite, 0);
        this.m_canvasGridData = new GridData(1, 0x1000000, true, true);
        this.m_canvasGridData.widthHint = 180;
        this.m_canvasGridData.exclude = true;
        this.m_canvas.setLayoutData((Object)this.m_canvasGridData);
        this.m_paintListener = event -> this.redrawStatus(event);
        this.m_canvas.addPaintListener(this.m_paintListener);
        this.m_canvas.setToolTipText(this.m_tooltipText);
        this.m_canvas.setVisible(false);
        Label separator = new Label(this.m_composite, 514);
        separator.setLayoutData((Object)new GridData(0, 4, false, true));
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemOpenedEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.OPENED);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemClosedEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.CLOSED);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersStartedEvent>(AnalyzersStartedEvent.class, (Object)this){

            public void handleEvent(AnalyzersStartedEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.STARTED);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzersFinishedEvent>(AnalyzersFinishedEvent.class, (Object)this){

            public void handleEvent(AnalyzersFinishedEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.FINISHED);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.RUNNING);
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultClearedEvent>(AnalyzerResultClearedEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultClearedEvent event) {
                AnalyzersStatusLineWidget.this.update(EventType.CLEARED);
            }
        });
    }

    private boolean analyzerStatusChanged(EventType eventType) {
        String statusText;
        assert (eventType != null) : "Parameter 'eventType' of method 'analyzerStatusChanged' must not be null";
        this.m_showProgress = false;
        this.m_toRun = 0;
        this.m_finished = 0;
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (!provider.hasSoftwareSystem() || provider.getSoftwareSystem().getState() == SoftwareSystemState.CLOSED) {
            String statusText2 = "";
            if (!"".equals(this.m_statusText)) {
                this.m_statusText = "";
                this.m_tooltipText = DEFAULT_TOOLTIP_TEXT;
                return true;
            }
            return false;
        }
        if (provider.getSoftwareSystem().getState() == SoftwareSystemState.OPENED) {
            String statusText3 = "Have Not Been Run";
            if (!"Have Not Been Run".equals(this.m_statusText)) {
                this.m_statusText = "Have Not Been Run";
                this.m_tooltipText = DEFAULT_TOOLTIP_TEXT;
                return true;
            }
            return false;
        }
        List results = ((Files)provider.getSoftwareSystem().getUniqueExistingChild(Files.class)).getAnalyzers().getCurrentAnalyzerResults();
        int haveNotBeenRun = 0;
        for (AnalyzerResult next : results) {
            switch (next.getState()) {
                case HAS_NOT_BEEN_RUN: {
                    ++haveNotBeenRun;
                    break;
                }
                case INACTIVE: {
                    break;
                }
                case RUNNING: {
                    ++this.m_toRun;
                    break;
                }
                case FINISHED: 
                case ERROR: 
                case CANCELLED: {
                    ++this.m_toRun;
                    ++this.m_finished;
                }
            }
        }
        if (this.m_toRun == 0 && haveNotBeenRun > 0) {
            if (eventType == EventType.STARTED) {
                statusText = "Running";
                this.m_toRun = haveNotBeenRun;
                this.m_finished = 0;
            } else {
                statusText = "Have Not Been Run";
            }
        } else if (this.m_toRun + this.m_finished > 0) {
            if (this.m_toRun == this.m_finished) {
                statusText = "Finished";
            } else {
                statusText = String.format("%d of %d Finished", this.m_finished, this.m_toRun);
                this.m_showProgress = true;
            }
        } else {
            statusText = "Not Running";
        }
        if (!statusText.equals(this.m_statusText)) {
            this.m_statusText = statusText;
            this.m_tooltipText = String.format("Analyzer Execution Level '%s'", WorkbenchRegistry.getInstance().getProvider().getAnalyzerExecutionLevel().getPresentationName());
            return true;
        }
        return false;
    }

    private void update(EventType eventType) {
        if (this.analyzerStatusChanged(eventType)) {
            if (this.m_canvas != null && !this.m_canvas.isDisposed()) {
                this.m_composite.setRedraw(false);
                if (this.m_showProgress) {
                    this.m_canvasGridData.exclude = false;
                    this.m_canvasGridData.horizontalSpan = 2;
                    this.m_canvas.setVisible(true);
                    this.m_statusLabelGridData.exclude = true;
                    this.m_statusLabel.setVisible(false);
                    this.m_canvas.setToolTipText(this.m_tooltipText);
                } else {
                    this.m_statusLabelGridData.exclude = false;
                    this.m_statusLabelGridData.horizontalSpan = 2;
                    this.m_statusLabel.setVisible(true);
                    this.m_canvasGridData.exclude = true;
                    this.m_canvas.setVisible(false);
                    this.m_statusLabel.setText(this.m_statusText);
                    this.m_statusLabel.setToolTipText(this.m_tooltipText);
                }
                this.m_composite.setRedraw(true);
                this.m_composite.requestLayout();
            }
            if (this.m_imageLabel != null && !this.m_imageLabel.isDisposed()) {
                this.m_imageLabel.setToolTipText(this.m_tooltipText);
            }
        }
    }

    private void redrawStatus(PaintEvent event) {
        assert (event != null) : "Parameter 'event' of method 'redrawStatus' must not be null";
        if (this.m_toRun == 0) {
            return;
        }
        float progress = (float)this.m_finished / (float)this.m_toRun;
        if (progress > 0.0f) {
            int width = (int)(progress * (float)event.width);
            event.gc.setBackground(UiResourceManager.getInstance().getColor(UiResourceManager.GREEN));
            event.gc.fillRectangle(event.x + 2, event.y + 2, width - 4, event.height - 4);
        }
    }

    @PreDestroy
    public void dispose() {
        EventManager.getInstance().detach(AnalyzersStartedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzersFinishedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultStateChangedEvent.class, (Object)this);
        EventManager.getInstance().detach(AnalyzerResultClearedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)this);
        if (this.m_canvas != null) {
            this.m_canvas.removePaintListener(this.m_paintListener);
        }
    }

    private static enum EventType {
        STARTED,
        RUNNING,
        FINISHED,
        CLEARED,
        CLOSED,
        OPENED;

    }
}

