/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.swt;

import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class MapBackedCombo<T>
extends Composite {
    private final List<SelectionListener> m_listeners = new ArrayList<SelectionListener>();
    private final ILabelProvider<T> m_labelProvider;
    private final Combo m_combo;
    private final boolean m_sortInput;
    private Map<String, T> m_map;

    public MapBackedCombo(Composite parent, int style, ILabelProvider<T> labelProvider, boolean sortInput) {
        super(parent, 0);
        assert (labelProvider != null) : "Parameter 'labelProvider' of method 'MapBackedCombo' must not be null";
        this.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        this.m_labelProvider = labelProvider;
        this.m_combo = new Combo((Composite)this, style);
        this.m_combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (SelectionListener listener : MapBackedCombo.this.m_listeners) {
                    listener.widgetSelected(event);
                }
            }
        });
        this.m_sortInput = sortInput;
    }

    public MapBackedCombo(Composite parent, int style, ILabelProvider<T> labelProvider) {
        this(parent, style, labelProvider, false);
    }

    public void setInput(Collection<T> items) {
        assert (items != null) : "Parameter 'items' of method 'setInput' must not be null";
        assert (this.m_labelProvider != null) : "LabelProvider must not be null!";
        this.m_map = new LinkedHashMap<String, T>(items.size());
        for (T item : items) {
            this.m_map.put(this.m_labelProvider.getText(item), item);
        }
        ArrayList<String> labels = new ArrayList<String>(this.m_map.keySet());
        if (this.m_sortInput) {
            Collections.sort(labels);
        }
        for (String label : labels) {
            this.m_combo.add(label);
        }
    }

    public void setInput(Collection<T> items, boolean refresh) {
        if (refresh) {
            this.m_combo.removeAll();
        }
        this.setInput(items);
    }

    public T getItemForLabel(String label) {
        return this.m_map.get(label);
    }

    public boolean addSelectionListener(SelectionListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addSelectionListener' must not be null";
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
            return true;
        }
        return false;
    }

    public boolean removeSelectionListener(SelectionListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'removeSelectionListener' must not be null";
        return this.m_listeners.remove(listener);
    }

    public void selectElement(T element) {
        for (Map.Entry<String, T> entry : this.m_map.entrySet()) {
            if (!entry.getValue().equals(element)) continue;
            SwtUtility.selectElementOfCombo((Combo)this.m_combo, (String)entry.getKey());
            break;
        }
    }

    public void removeAll() {
        this.m_combo.removeAll();
    }

    public void dispose() {
        this.m_map.clear();
        for (SelectionListener listener : this.m_listeners) {
            this.m_combo.removeSelectionListener(listener);
        }
        super.dispose();
    }

    public void select(int i) {
        this.m_combo.select(i);
    }

    public String getText() {
        return this.m_combo.getText();
    }

    public void setText(String text) {
        this.m_combo.setEnabled(true);
        this.m_combo.add(text);
        this.m_combo.setText(text);
    }

    public Combo getCombo() {
        return this.m_combo;
    }

    @FunctionalInterface
    public static interface ILabelProvider<T> {
        public String getText(T var1);
    }
}

