/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LineNumberPaintListener
implements PaintListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineNumberPaintListener.class);
    private static final int RIGHT_MARGIN = 4;
    private final StyledText m_styledText;
    private int m_widthHint;

    LineNumberPaintListener(StyledText styledText, int widthHint) {
        assert (styledText != null) : "Parameter 'styledText' of method 'MarkerPaintListener' must not be null";
        assert (styledText.getParent() != null) : "Parameter 'styledText' of method 'MarkerPaintListener' must have a parent";
        this.m_styledText = styledText;
        this.m_widthHint = widthHint;
    }

    public void setWidthHint(int widthHint) {
        this.m_widthHint = widthHint;
    }

    public void paintControl(PaintEvent event) {
        assert (event != null) : "Parameter 'event' of method 'paintControl' must not be null";
        assert (this.m_styledText.getText() != null) : "StyledText.getText() must not return null";
        int firstVisibleLine = this.m_styledText.getTopIndex() + 1;
        int lastVisibleLine = JFaceTextUtil.getPartialBottomIndex((StyledText)this.m_styledText) + 1;
        event.gc.setFont(this.m_styledText.getFont());
        int nextLine = Math.max(1, firstVisibleLine - 1);
        while (nextLine <= lastVisibleLine) {
            try {
                int nextLineOffset = this.m_styledText.getOffsetAtLine(nextLine - 1);
                Point nextLineLocation = this.m_styledText.getLocationAtOffset(nextLineOffset);
                String extentString = StringUtility.concat((String)"0", (int)Integer.toString(nextLine).length());
                Point stringExtent = event.gc.stringExtent(extentString);
                event.gc.drawString(Integer.toString(nextLine), this.m_widthHint - stringExtent.x - 4, nextLineLocation.y);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Error painting line number. Failed to get offset at widget line: {}; firstVisibleLine = {}, lastVisibleLine = {}", new Object[]{nextLine, firstVisibleLine, lastVisibleLine});
            }
            ++nextLine;
        }
        this.m_styledText.getParent().layout();
    }
}

