/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.sourceview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.SourceMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyToClipboardHandler
extends CommandHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyToClipboardHandler.class);
    private static final String COPY = "Copy";

    private static String getLabel(IWorkbenchView workbenchView) {
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'getLabel must not be null";
        if (workbenchView.supportsCopy()) {
            String labelAddition = workbenchView.getCopyLabelAddition();
            if (labelAddition != null && !labelAddition.isEmpty()) {
                return "Copy " + labelAddition;
            }
        } else {
            LOGGER.warn("Workbench view '" + String.valueOf(workbenchView.getViewId()) + "' does not support copy");
        }
        return COPY;
    }

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'showInContextMenu' must not be null");
                }
                return workbenchView.supportsCopy();
            }

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'getLabel' must not be null");
                }
                return CopyToClipboardHandler.getLabel(workbenchView);
            }

            public IMenuGroup getMenuGroup() {
                return SourceMenuGroup.SOURCE;
            }
        };
    }

    @CanExecute
    public boolean canExecute(MPart part, @Optional MMenuItem menuItem) {
        IWorkbenchView workbenchView;
        assert (part != null) : "Parameter 'part' of method 'canExecute' must not be null";
        if (menuItem != null) {
            menuItem.setLabel(COPY);
        }
        if ((workbenchView = RcpUtility.getWorkbenchView((MPart)part, IWorkbenchView.class)) != null && workbenchView.isActive() && workbenchView.isReady() && workbenchView.supportsCopy() && !UiResourceManager.getInstance().getClipboard().isDisposed()) {
            if (menuItem != null) {
                menuItem.setLabel(CopyToClipboardHandler.getLabel(workbenchView));
            }
            return true;
        }
        return false;
    }

    @Execute
    public void execute(MPart part) {
        String data;
        assert (part != null) : "Parameter 'part' of method 'execute' must not be null";
        IWorkbenchView workbenchView = RcpUtility.getWorkbenchView((MPart)part, IWorkbenchView.class);
        if (workbenchView != null && workbenchView.isActive() && workbenchView.isReady() && workbenchView.supportsCopy() && !UiResourceManager.getInstance().getClipboard().isDisposed() && (data = workbenchView.copy()) != null && !data.isEmpty()) {
            Clipboard clipboard = UiResourceManager.getInstance().getClipboard();
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{data}, new Transfer[]{textTransfer});
        }
    }
}

