/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpRegistry;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.ISonargraphPreferencePage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.help.HelpAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class StandardPreferencePage
extends PreferencePage
implements ISonargraphPreferencePage {
    public static final int WIDTH_HINT = 600;
    public static final int HEIGTH_HINT = 400;
    private static HelpAdapter s_helpAdapter;
    private Button m_buttonApply;
    private Button m_buttonCancel;
    private Button m_buttonRestoreDefaults;

    public StandardPreferencePage() {
    }

    public StandardPreferencePage(String title) {
        super(title);
    }

    public StandardPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public static final void setHelpAdapter(HelpAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'setHelpAdapter' must not be null";
        s_helpAdapter = adapter;
    }

    public static final void resetHelpAdapter() {
        s_helpAdapter = null;
    }

    protected final int getWidth() {
        return 600;
    }

    protected final int getHeight() {
        return 400;
    }

    public Button getApplyButton() {
        return this.m_buttonApply;
    }

    public Button getCancelButton() {
        return this.m_buttonCancel;
    }

    public Button getRestoreDefaultsButton() {
        return this.m_buttonRestoreDefaults;
    }

    protected final Control createContents(Composite parent) {
        this.getShell().setImage(UiResourceManager.getInstance().getImage("icon_64x64"));
        Composite createPageContents = this.createPageContents(parent);
        if (this.getDialogId() != null) {
            HelpRegistry.getInstance().register((Object)this, this.getDialogId().getId());
            Control[] controlArray = createPageContents.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control next = controlArray[n2];
                next.addHelpListener(e -> this.performHelp());
                ++n2;
            }
        }
        return createPageContents;
    }

    protected abstract Composite createPageContents(Composite var1);

    protected Composite createButtonsPart(Composite container, boolean includeDefaultsButton) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)(includeDefaultsButton ? 3 : 2), (boolean)false));
        composite.setLayoutData((Object)new GridData(3, 3, false, false, 2, 1));
        if (includeDefaultsButton) {
            this.m_buttonRestoreDefaults = new Button(composite, 8);
            this.m_buttonRestoreDefaults.setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.restoredefaults", new Object[0]));
            this.m_buttonRestoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StandardPreferencePage.this.performDefaults();
                }
            });
        }
        this.m_buttonApply = SwtUtility.createButtonForGridLayoutStandardSize((Composite)composite, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.apply", new Object[0]));
        this.m_buttonApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandardPreferencePage.this.performApply();
            }
        });
        this.m_buttonCancel = SwtUtility.createButtonForGridLayoutStandardSize((Composite)composite, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.cancel", new Object[0]));
        this.m_buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StandardPreferencePage.this.cancel();
            }
        });
        return composite;
    }

    protected abstract ISettingsDelta getDelta();

    protected abstract OperationResult getOperationResult();

    protected abstract void cancel();

    @Override
    public IDialogId getDialogId() {
        return null;
    }

    public void performHelp() {
        IPreferencePageContainer container;
        if (this.getDialogId() != null && (container = this.getContainer()) instanceof TrayDialog) {
            TrayDialog trayDialog = (TrayDialog)container;
            if (trayDialog.getTray() == null) {
                s_helpAdapter.showHelp(trayDialog, (Object)this);
            } else {
                trayDialog.closeTray();
            }
        }
    }

    public boolean okToLeave() {
        if (this.getDelta() != null && this.getDelta().isModified()) {
            UserInterfaceAdapter.Feedback feedback;
            if (this.standardIsValid()) {
                UserInterfaceAdapter.Feedback feedback2 = UserInterfaceAdapter.getInstance().question("Page '" + this.getTitle() + "' contains unsaved changes." + StringUtility.LINE_SEPARATOR + "Do you want to save before leaving the page? Selecting 'no' will discard the changes.", false);
                if (feedback2 == UserInterfaceAdapter.Feedback.DISAGREED) {
                    this.cancel();
                    return true;
                }
                this.performApply();
                if (this.getOperationResult() != null && this.getOperationResult().isFailure()) {
                    return false;
                }
            } else if (this.okToLeavePageWithErrors() && (feedback = UserInterfaceAdapter.getInstance().question("Page '" + this.getTitle() + "' contains unsaved changes and errors." + StringUtility.LINE_SEPARATOR + "Do you want to keep the modifications?" + StringUtility.LINE_SEPARATOR + "Selecting 'yes' will keep the changes and allows to correct them by switching back to the page before closing the dialog." + StringUtility.LINE_SEPARATOR + "Selecting 'no' will discard the changes.", false)) == UserInterfaceAdapter.Feedback.DISAGREED) {
                this.cancel();
                return true;
            }
        }
        return true;
    }

    protected boolean standardIsValid() {
        return super.isValid();
    }

    public boolean isValid() {
        return this.standardIsValid() || this.okToLeavePageWithErrors();
    }

    protected boolean okToLeavePageWithErrors() {
        return false;
    }

    public boolean performCancel() {
        if (this.getDelta() == null || !this.getDelta().isModified() || !this.isValid()) {
            return true;
        }
        UserInterfaceAdapter.Feedback feedback = UserInterfaceAdapter.getInstance().question("Changes have been made that have not yet been persisted. Do you want to save these changes?", false);
        if (feedback == UserInterfaceAdapter.Feedback.CONFIRMED) {
            this.performApply();
        }
        return true;
    }

    public void dispose() {
        if (this.getDialogId() != null) {
            HelpRegistry.getInstance().unregister((Object)this);
        }
        super.dispose();
    }

    protected final void performApply() {
        super.performApply();
    }

    protected abstract void internPerformOk();

    public final boolean performOk() {
        this.internPerformOk();
        if (this.getOperationResult() != null && this.getOperationResult().isFailure()) {
            return false;
        }
        return super.performOk();
    }
}

