/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.preferencepage;

import com.hello2morrow.sonargraph.core.model.plugin.IPluginProvider;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.PreferencePageRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;

public final class ConfigurationDialogHelper {
    private ConfigurationDialogHelper() {
    }

    private static int openInternal(PreferenceManager preferenceManager, String pageId) {
        assert (preferenceManager != null) : "Parameter 'preferenceManager' of method 'openInternal' must not be null";
        PreferenceDialog dialog = new PreferenceDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), preferenceManager);
        if (pageId != null) {
            assert (pageId.length() > 0) : "Parameter 'pageId' of method 'openInternal' must not be empty";
            dialog.setSelectedNode(pageId);
        }
        dialog.setHelpAvailable(true);
        dialog.create();
        dialog.getShell().setText(StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.application.name", new Object[0]) + " - " + StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.settings", new Object[0]));
        dialog.getShell().setImage(UiResourceManager.getInstance().getImage("icon_64x64"));
        return dialog.open();
    }

    public static int openOnlyInstallationPreferencePage(String pageId) {
        assert (pageId != null && pageId.length() > 0) : "Parameter 'pageId' of method 'openPreferenceDialog' must not be empty";
        PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getInstallationPreferenceManager();
        IPreferenceNode node = ConfigurationDialogHelper.findRootNode(preferenceManager, pageId);
        if (node != null) {
            PreferenceManager filtered = new PreferenceManager();
            filtered.addToRoot(node);
            return ConfigurationDialogHelper.openInternal(filtered, pageId);
        }
        return 1;
    }

    private static IPreferenceNode findRootNode(PreferenceManager preferenceManager, String pageId) {
        IPreferenceNode[] iPreferenceNodeArray = preferenceManager.getRootSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode next = iPreferenceNodeArray[n2];
            IPreferenceNode match = ConfigurationDialogHelper.findNode(next, pageId);
            if (match != null) {
                return match;
            }
            ++n2;
        }
        return null;
    }

    private static IPreferenceNode findNode(IPreferenceNode node, String pageId) {
        assert (node != null) : "Parameter 'node' of method 'findNode' must not be null";
        assert (pageId != null && pageId.length() > 0) : "Parameter 'pageId' of method 'findNode' must not be empty";
        if (node.getId().equals(pageId)) {
            return node;
        }
        IPreferenceNode[] iPreferenceNodeArray = node.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode next = iPreferenceNodeArray[n2];
            IPreferenceNode match = ConfigurationDialogHelper.findNode(next, pageId);
            if (match != null) {
                return match;
            }
            ++n2;
        }
        return null;
    }

    public static int openPreferencePage(PreferenceManager preferenceManager, String pageId) {
        assert (preferenceManager != null) : "Parameter 'preferenceManager' of method 'openPreferenceDialog' must not be null";
        assert (pageId != null && pageId.length() > 0) : "Parameter 'pageId' of method 'openPreferenceDialog' must not be empty";
        return ConfigurationDialogHelper.openInternal(preferenceManager, pageId);
    }

    public static int openSystemPropertiesDialog() {
        assert (WorkbenchRegistry.getInstance().getSoftwareSystem() != null) : "No software system available";
        PreferenceManager preferenceManager = PreferencePageRegistry.getInstance().getSoftwareSystemPreferenceManager(WorkbenchRegistry.getInstance().getSoftwareSystem().getUsedLanguages(), ((IPluginProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IPluginProvider.class)).getPlugins());
        return ConfigurationDialogHelper.openInternal(preferenceManager, null);
    }
}

