/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Control;

public final class ValidationControlDecorator {
    private Control m_control;
    private ControlDecoration m_decoration;

    public ValidationControlDecorator(Control control) {
        assert (control != null) : "Parameter 'control' of method 'ValidationControlDecorator' must not be null";
        this.m_control = control;
    }

    private final String getDecorationDescriptionText(ValidationResult result) {
        assert (result != null) : "Parameter 'result' of method 'getDecorationTooltip' must not be null";
        return result.toFormattedString();
    }

    public void updateDecoration(ValidationResult result) {
        String decorationDescriptionText = this.getDecorationDescriptionText(result);
        if (decorationDescriptionText != null) {
            if (this.m_control != null && !this.m_control.isDisposed()) {
                if (this.m_decoration == null) {
                    this.m_decoration = new ControlDecoration(this.m_control, 16512);
                }
                if (result.isSuccess()) {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("WarningMarker"));
                } else {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
                }
                this.m_decoration.setDescriptionText(decorationDescriptionText);
                this.m_decoration.show();
            }
        } else {
            this.clearDecoration();
        }
    }

    private final void clearDecoration() {
        if (this.m_control != null && !this.m_control.isDisposed() && this.m_decoration != null) {
            this.m_decoration.setDescriptionText("");
            this.m_decoration.hide();
        }
    }
}

