/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingWidget;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public final class ValidatingPathComboWidget
extends ValidatingWidget {
    private final IConsumer m_consumer;
    private final IPathValidator m_validator;
    private final TFile m_originalInput;
    private TFile m_currentFile;
    private TFile m_basePath;
    private Combo m_fileField;
    private SelectionAdapter m_fileFieldSelectionAdapter;
    private KeyAdapter m_fileFieldKeyAdapter;
    private Button m_browseButton;
    private String[] m_filterExtensions;
    private SelectionAdapter m_browseSelectionListener;
    private boolean m_isFileFieldEditable;

    private ValidatingPathComboWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile originalInput) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ValidatingPathWidget' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'ValidatingPathWidget' must not be null";
        assert (validator != null) : "Parameter 'validator' of method 'ValidatingPathWidget' must not be null";
        this.m_consumer = consumer;
        this.m_validator = validator;
        this.m_originalInput = originalInput;
        this.m_currentFile = originalInput;
        GridLayout layout = new GridLayout(spacing > 0 ? 2 : 1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = spacing;
        this.setLayout((Layout)layout);
    }

    private void addBrowseButton() {
        this.m_browseButton = new Button((Composite)this, 0x800000);
        String browseImage = null;
        switch (this.m_validator.getType()) {
            case ARCHIVE_OR_DIRECTORY: {
                browseImage = "ArchiveOrDirectoryPath";
                break;
            }
            case DIRECTORY: {
                browseImage = "DirectoryPath";
                break;
            }
            case FILE: {
                browseImage = "FilePath";
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf(this.m_validator.getType());
                break;
            }
        }
        this.m_browseButton.setImage(UiResourceManager.getInstance().getImage(browseImage));
        this.m_browseButton.setToolTipText("Browse");
        GridData browseButtonLayoutData = new GridData(4, 0x1000000, false, false);
        this.m_browseButton.setLayoutData((Object)browseButtonLayoutData);
        this.m_browseSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = null;
                if (ValidatingPathComboWidget.this.m_validator.getType() == IPathValidator.PathType.FILE) {
                    FileDialog fileDialog = new FileDialog(ValidatingPathComboWidget.this.getShell(), 4096);
                    if (ValidatingPathComboWidget.this.m_currentFile != null) {
                        TFile parentFile = ValidatingPathComboWidget.this.m_currentFile.getParentFile();
                        fileDialog.setFilterPath(parentFile != null ? parentFile.getAbsolutePath() : "");
                    } else if (ValidatingPathComboWidget.this.m_basePath != null) {
                        fileDialog.setFilterPath(ValidatingPathComboWidget.this.m_basePath.getAbsolutePath());
                    }
                    if (ValidatingPathComboWidget.this.m_filterExtensions != null && ValidatingPathComboWidget.this.m_filterExtensions.length > 0) {
                        fileDialog.setFilterExtensions(ValidatingPathComboWidget.this.m_filterExtensions);
                    }
                    path = fileDialog.open();
                } else {
                    DirectoryDialog directoryDialog = new DirectoryDialog(ValidatingPathComboWidget.this.getShell(), 0);
                    if (ValidatingPathComboWidget.this.m_currentFile != null) {
                        directoryDialog.setFilterPath(ValidatingPathComboWidget.this.m_currentFile.getAbsolutePath());
                    } else if (ValidatingPathComboWidget.this.m_basePath != null) {
                        directoryDialog.setFilterPath(ValidatingPathComboWidget.this.m_basePath.getAbsolutePath());
                    }
                    path = directoryDialog.open();
                }
                if (path != null && path.length() > 0) {
                    ValidatingPathComboWidget.this.validate(path, true, true);
                }
            }
        };
        this.m_browseButton.addSelectionListener((SelectionListener)this.m_browseSelectionListener);
    }

    private void addPathField(TFile initialPath, boolean editable) {
        this.m_isFileFieldEditable = editable;
        this.m_fileField = new Combo((Composite)this, 2048);
        this.m_fileField.setEnabled(editable);
        this.m_fileField.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        GridData fileFieldLayoutData = new GridData(4, 0x1000000, true, false);
        this.m_fileField.setLayoutData((Object)fileFieldLayoutData);
        if (initialPath != null) {
            this.m_fileField.setText(this.m_basePath != null ? FileUtility.calculateRelativePath((TFile)initialPath, (TFile)this.m_basePath) : initialPath.getPath());
        }
        this.validate(initialPath, null, false);
        this.m_fileFieldSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidatingPathComboWidget.this.validate(ValidatingPathComboWidget.this.m_fileField.getText(), false, true);
            }
        };
        this.m_fileField.addSelectionListener((SelectionListener)this.m_fileFieldSelectionAdapter);
        this.m_fileFieldKeyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ValidatingPathComboWidget.this.validate(ValidatingPathComboWidget.this.m_fileField.getText(), false, true);
            }
        };
        this.m_fileField.addKeyListener((KeyListener)this.m_fileFieldKeyAdapter);
    }

    public ValidatingPathComboWidget(Composite parent, IConsumer consumer, IPathValidator validator) {
        this(parent, consumer, validator, 0, null);
        this.addBrowseButton();
    }

    public ValidatingPathComboWidget(Composite parent, IConsumer consumer, IPathValidator validator, TFile currentInput) {
        this(parent, consumer, validator, 0, currentInput);
        this.addBrowseButton();
    }

    public ValidatingPathComboWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable) {
        this(parent, consumer, validator, spacing, currentInput);
        assert (spacing > 0) : "'spacing' must be greater than 0";
        this.addPathField(currentInput, pathFieldEditable);
        this.addBrowseButton();
    }

    public ValidatingPathComboWidget(Composite parent, IConsumer consumer, IPathValidator validator, int spacing, TFile currentInput, boolean pathFieldEditable, TFile basePath) {
        this(parent, consumer, validator, spacing, currentInput);
        assert (spacing > 0) : "'spacing' must be greater than 0";
        this.m_basePath = basePath;
        this.addPathField(currentInput, pathFieldEditable);
        this.addBrowseButton();
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.m_filterExtensions = filterExtensions;
    }

    public Button getBrowseButton() {
        return this.m_browseButton;
    }

    private void validate(String path, boolean updateFileField, boolean notifyConsumer) {
        assert (path != null) : "Parameter 'path' of method 'validate' must not be null";
        String normalizedPath = path.trim();
        if (FileUtility.isAbsolutePath((String)path) && this.m_basePath != null) {
            normalizedPath = FileUtility.calculateRelativePath((TFile)new TFile(normalizedPath), (TFile)this.m_basePath);
        }
        TFile newPath = null;
        newPath = this.m_basePath == null || FileUtility.isAbsolutePath((String)normalizedPath) ? new TFile(normalizedPath) : new TFile((File)this.m_basePath, normalizedPath);
        this.validate(newPath, updateFileField ? normalizedPath : null, notifyConsumer);
    }

    public void setModifiable(boolean isModifiable) {
        if (isModifiable) {
            this.m_browseButton.setEnabled(true);
            this.m_fileField.setEnabled(this.m_isFileFieldEditable);
        } else {
            this.m_browseButton.setEnabled(false);
            this.m_fileField.setEnabled(false);
        }
    }

    private void validate(TFile file, String fileFieldText, boolean notifyConsumer) {
        this.m_currentFile = file;
        if (this.m_fileField != null && fileFieldText != null) {
            this.m_fileField.removeKeyListener((KeyListener)this.m_fileFieldKeyAdapter);
            this.m_fileField.removeSelectionListener((SelectionListener)this.m_fileFieldSelectionAdapter);
            this.m_fileField.setText(fileFieldText);
            this.m_fileField.addSelectionListener((SelectionListener)this.m_fileFieldSelectionAdapter);
            this.m_fileField.addKeyListener((KeyListener)this.m_fileFieldKeyAdapter);
        }
        ValidationResult result = this.m_validator.isValid(this.m_originalInput, file);
        if (this.m_fileField != null) {
            this.updateDecoration((Control)this.m_fileField, result);
        }
        if (notifyConsumer) {
            this.m_consumer.setPath((TFile)(result.isSuccess() ? file : null), result.inputModified());
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.m_fileField != null) {
            this.m_fileField.setEnabled(enabled);
        }
        this.m_browseButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void dispose() {
        this.m_fileField.removeKeyListener((KeyListener)this.m_fileFieldKeyAdapter);
        this.m_fileField.removeSelectionListener((SelectionListener)this.m_fileFieldSelectionAdapter);
        this.m_browseButton.removeSelectionListener((SelectionListener)this.m_browseSelectionListener);
        super.dispose();
    }

    public void setPath(String path) {
        this.validate(path, true, false);
    }

    public void setBasePath(TFile baseDir) {
        this.m_basePath = baseDir;
    }

    public void clearDecoration() {
        if (this.m_fileField != null) {
            this.clearDecoration((Control)this.m_fileField);
        }
    }

    public void setItems(String[] items) {
        assert (items != null) : "Parameter 'items' of method 'setItems' must not be null";
        this.m_fileField.setItems(items);
    }

    public void setSelectedItem(int index) {
        this.m_fileField.select(index);
    }

    public static interface IConsumer {
        public void setPath(TFile var1, boolean var2);
    }
}

