/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.model.path.ExportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDirectoryDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class ExportQualityModelDialog
extends NameAndDirectoryDialog {
    private final ExportQualityModel m_exportQualityModel;
    private TableViewer m_tableViewer;
    private TableViewerColumn m_fileColumn;
    private TableViewerColumn m_checkColumn;
    private Text m_infoText;
    private Object m_lastHoveredItem;

    public ExportQualityModelDialog(Shell parent, String name, ExportQualityModel exportQualityModel) {
        super(parent, "Export Quality Model", "Name of Quality Model", name);
        assert (exportQualityModel != null) : "Parameter 'exportQualityModel' of method 'ExportQualityModelDialog' must not be null";
        this.m_exportQualityModel = exportQualityModel;
    }

    protected void applyData() {
        super.applyData();
        this.validate();
    }

    @Override
    protected TFile getLocation() {
        String location = WorkbenchRegistry.getInstance().getProvider().getLocation("ExportQualityModel");
        return location != null ? new TFile(location) : null;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        super.addWidgetsToDialogAreaAfter(composite);
        SashForm sash = new SashForm(composite, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sash);
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Composite upper = new Composite((Composite)sash, 0);
        upper.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)3));
        this.m_tableViewer = new TableViewer(upper, 68354);
        this.m_tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_fileColumn = new TableViewerColumn(this.m_tableViewer, 0);
        this.m_fileColumn.getColumn().setResizable(true);
        this.m_fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'getText' must not be null");
                }
                if (!$assertionsDisabled && !(element instanceof ExportQualityModel.ExportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(element)));
                }
                ExportQualityModel.ExportQualityModelCandidate candidate = (ExportQualityModel.ExportQualityModelCandidate)element;
                return candidate.getIdentifyingPath();
            }

            public Image getImage(Object element) {
                if (!$assertionsDisabled && element == null) {
                    throw new AssertionError((Object)"Parameter 'element' of method 'getImage' must not be null");
                }
                if (!$assertionsDisabled && !(element instanceof ExportQualityModel.ExportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class: " + String.valueOf(element)));
                }
                ExportQualityModel.ExportQualityModelCandidate candidate = (ExportQualityModel.ExportQualityModelCandidate)element;
                return UiResourceManager.getInstance().getImage(candidate.getModifiableFile().getImageResourceName());
            }

            public String getToolTipText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof ExportQualityModel.ExportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getToolTipText': " + String.valueOf(element)));
                }
                ExportQualityModel.ExportQualityModelCandidate candidate = (ExportQualityModel.ExportQualityModelCandidate)element;
                return candidate.getModifiableFile().getAbsolutePath();
            }
        });
        this.m_checkColumn = new TableViewerColumn(this.m_tableViewer, 0x1000000);
        this.m_checkColumn.getColumn().setResizable(false);
        this.m_checkColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!$assertionsDisabled && cell == null) {
                    throw new AssertionError((Object)"Parameter 'cell' of method 'update' must not be null");
                }
                if (!($assertionsDisabled || cell.getElement() != null && cell.getElement() instanceof ExportQualityModel.ExportQualityModelCandidate)) {
                    throw new AssertionError((Object)("Unexpected class in method 'update': " + String.valueOf(cell.getElement())));
                }
                if (((ExportQualityModel.ExportQualityModelCandidate)cell.getElement()).isIncluded()) {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxChecked"));
                } else {
                    cell.setImage(UiResourceManager.getInstance().getImage("CheckBoxUnchecked"));
                }
            }

            public String getToolTipText(Object element) {
                return null;
            }
        });
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_tableViewer.setInput((Object)this.m_exportQualityModel.getCandidates());
        this.m_checkColumn.getColumn().pack();
        this.m_fileColumn.getColumn().pack();
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object firstElement = selection.getFirstElement();
                    if (!($assertionsDisabled || firstElement != null && firstElement instanceof ExportQualityModel.ExportQualityModelCandidate)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement)));
                    }
                    ((ExportQualityModel.ExportQualityModelCandidate)firstElement).toggleIncludedState();
                }
                ExportQualityModelDialog.this.refreshTable();
                ExportQualityModelDialog.this.validate();
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        SwtUtility.packAllColumnsAndRightAlignLast((TableViewer)this.m_tableViewer);
        Composite buttonComposite = new Composite(upper, 0);
        buttonComposite.setLayout((Layout)new FillLayout());
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 3, 1));
        Button selectAll = new Button(buttonComposite, 8);
        selectAll.setText("Select All");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportQualityModelDialog.this.m_exportQualityModel.getCandidates().stream().forEach(c -> c.setIncluded(true));
                ExportQualityModelDialog.this.refreshTable();
                ExportQualityModelDialog.this.validate();
            }
        });
        Button deselectAll = new Button(buttonComposite, 8);
        deselectAll.setText("Deselect All");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportQualityModelDialog.this.m_exportQualityModel.getCandidates().stream().forEach(c -> c.setIncluded(false));
                ExportQualityModelDialog.this.refreshTable();
                ExportQualityModelDialog.this.validate();
            }
        });
        this.m_infoText = new Text((Composite)sash, 578);
        this.m_infoText.setText("");
        this.m_infoText.setEditable(false);
        sash.setWeights(new int[]{85, 15});
        this.m_tableViewer.getTable().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                TableItem item = ExportQualityModelDialog.this.m_tableViewer.getTable().getItem(new Point(event.x, event.y));
                if (item != null && item.getData() != ExportQualityModelDialog.this.m_lastHoveredItem) {
                    ExportQualityModelDialog.this.m_lastHoveredItem = item.getData();
                    if (ExportQualityModelDialog.this.m_lastHoveredItem instanceof ExportQualityModel.ExportQualityModelCandidate) {
                        ExportQualityModel.ExportQualityModelCandidate candidate = (ExportQualityModel.ExportQualityModelCandidate)ExportQualityModelDialog.this.m_lastHoveredItem;
                        IModifiableFile modifiableFile = candidate.getModifiableFile();
                        StringBuilder info = new StringBuilder(modifiableFile.getFile().getName());
                        info.append(" (").append(modifiableFile.getFileType().getPresentationName()).append(")");
                        String description = candidate.getDescription();
                        if (description != null && description.trim().length() > 0) {
                            info.append("\nDescription: ").append(description);
                        }
                        ExportQualityModelDialog.this.m_infoText.setText(info.toString());
                    }
                }
            }
        });
    }

    @Override
    protected boolean validateAdditionalWidgets() {
        if (super.validateAdditionalWidgets() && this.m_exportQualityModel.hasContent()) {
            WorkbenchRegistry.getInstance().getProvider().setLocation("ExportQualityModel", this.getDirectory() == null ? null : this.getDirectory().getAbsolutePath());
            return true;
        }
        return false;
    }

    private void refreshTable() {
        this.m_tableViewer.getTable().setRedraw(false);
        this.m_tableViewer.refresh();
        this.m_tableViewer.getTable().setRedraw(true);
    }

    @Override
    protected boolean additionalWidgetsModified() {
        return true;
    }

    protected Point getMinimumSize() {
        return new Point(600, 500);
    }

    protected Point getPreferredSize() {
        return new Point(600, 500);
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.EXPORT_QUALITY_MODEL_DIALOG;
    }
}

