/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.base.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class EditSystemDialog
extends NameAndDescriptionDialog {
    private final Map<String, String> m_currentMetaData = new HashMap<String, String>();
    private boolean m_modified = false;

    public EditSystemDialog(Shell parentShell, String title, ITextValidator nameValidator, String name, String description, Map<String, String> metaData) {
        super(parentShell, title, nameValidator, name, description);
        assert (metaData != null) : "Parameter 'metaData' of method 'EditSystemDialog' must not be null";
        for (Map.Entry<String, String> entry : metaData.entrySet()) {
            this.m_currentMetaData.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        ISoftwareSystem.KnownMetaDataKeys[] knownMetaDataKeysArray = ISoftwareSystem.KnownMetaDataKeys.values();
        int n = knownMetaDataKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ISoftwareSystem.KnownMetaDataKeys key = knownMetaDataKeysArray[n2];
            Label label = new Label(composite, 0);
            label.setText(key.getLabel() + ":");
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            ValidatingTextWidget widget = new ValidatingTextWidget(composite, new ITextValidator(){

                public ValidationResult isValid(String currentInput, String newInput) {
                    return new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                }
            }, new ValidatingTextOrComboWidget.IConsumer(){

                public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                    EditSystemDialog.this.m_currentMetaData.put(key.name(), text);
                    if (inputModified) {
                        EditSystemDialog.this.m_modified = true;
                    }
                    EditSystemDialog.this.validate();
                }
            }, this.m_currentMetaData.getOrDefault(key.name(), ""), 0);
            GridData gridDataDescription = new GridData(4, 0, true, false, 2, 1);
            widget.setLayoutData((Object)gridDataDescription);
            ++n2;
        }
    }

    @Override
    protected boolean additionalWidgetsModified() {
        return this.m_modified;
    }

    public String getMetaData(ISoftwareSystem.KnownMetaDataKeys key) {
        return this.m_currentMetaData.get(key.name());
    }
}

