/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

final class ArchitectureViewFilter
extends ViewerFilter {
    private final IArchitecturalModelProvider.ArchitectureModel m_model;
    private Set<NamedElement> m_visibleCollector;
    private NamedElement m_firstCollected;
    private boolean m_hasFiltered;

    ArchitectureViewFilter(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'ArchitectureViewFilter' must not be null";
        this.m_model = model;
    }

    void update(Architecture architecture, String text) {
        assert (architecture != null) : "Parameter 'architecture' of method 'update' must not be null";
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'update' must not be empty";
        this.m_visibleCollector = new THashSet();
        Visitor visitor = new Visitor(this.m_visibleCollector, text);
        for (NamedElement nextChild : architecture.getAllChildren()) {
            if (nextChild instanceof ArchitectureFile) {
                ArchitectureFile nextArchitectureFile = (ArchitectureFile)nextChild;
                if (!nextArchitectureFile.isChecked() || !nextArchitectureFile.getModel().equals((Object)this.m_model)) continue;
                nextArchitectureFile.accept((NamedElement.INamedElementVisitor)visitor);
                continue;
            }
            if (!(nextChild instanceof UnassignedElements)) continue;
            nextChild.accept((NamedElement.INamedElementVisitor)visitor);
        }
        this.m_hasFiltered = visitor.hasFiltered();
        if (this.m_hasFiltered) {
            this.m_firstCollected = visitor.firstCollected();
        }
    }

    void reset() {
        this.m_visibleCollector = null;
        this.m_hasFiltered = false;
        this.m_firstCollected = null;
    }

    boolean hasFiltered() {
        return this.m_hasFiltered;
    }

    NamedElement getFirstCollected() {
        return this.m_firstCollected;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.m_visibleCollector == null ? true : this.m_visibleCollector.contains(element);
    }

    static final class Visitor
    implements AssignedElement.IVisitor {
        private final ArrayDeque<NamedElement> m_parentStack = new ArrayDeque();
        private final Set<NamedElement> m_collector;
        private final String m_text;
        private NamedElement m_firstCollected;
        private boolean m_hasFiltered;

        Visitor(Set<NamedElement> collector, String text) {
            assert (collector != null) : "Parameter 'collector' of method 'Visitor' must not be null";
            assert (text != null && text.length() > 0) : "Parameter 'text' of method 'Visitor' must not be empty";
            this.m_collector = collector;
            this.m_text = text.toLowerCase();
        }

        public final void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            this.m_parentStack.push(element);
            this.visitChildrenOf(element);
            this.m_parentStack.pop();
        }

        public final void visitChildrenOf(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
            for (NamedElement next : element.getAllChildren()) {
                next.accept((NamedElement.INamedElementVisitor)this);
            }
        }

        public void visitAssignedElement(AssignedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignedElement' must not be null";
            String presentationName = element.getPresentationName(true);
            if (presentationName.toLowerCase().contains(this.m_text)) {
                for (NamedElement nextParent : this.m_parentStack) {
                    if (!this.m_collector.add(nextParent)) break;
                }
                if (this.m_firstCollected == null) {
                    this.m_firstCollected = element;
                }
                this.m_collector.add((NamedElement)element);
            } else {
                this.m_hasFiltered = true;
            }
        }

        boolean hasFiltered() {
            return this.m_hasFiltered;
        }

        NamedElement firstCollected() {
            return this.m_firstCollected;
        }
    }
}

