/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.view.PresentationModeBasedViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.TextStyle;

abstract class ArchitectureViewContentAndLabelProvider
extends PresentationModeBasedViewContentAndLabelProvider {
    ArchitectureViewContentAndLabelProvider() {
    }

    private String getState(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getState' must not be null";
        if (namedElement instanceof IModifiableFile && ((IModifiableFile)namedElement).needsSave()) {
            return " (*)";
        }
        return "";
    }

    @Override
    public final StyledString getStyledText(Object obj) {
        assert (obj instanceof NamedElement) : "Not of class named element: " + String.valueOf(obj);
        Object presentationName = null;
        String info = null;
        if (obj instanceof ArchitectureBaseElement) {
            element = (ArchitectureBaseElement)obj;
            if (element.checked()) {
                presentationName = element.getPresentationName(this.getParent(obj) != null);
                info = NumberUtility.format((Number)element.getNumberOfAssignedElements());
            } else {
                presentationName = element.getPresentationName(this.getParent(obj) != null);
            }
        } else if (obj instanceof ArchitectureFile) {
            element = (ArchitectureFile)obj;
            presentationName = element.getPresentationName(this.getParent(obj) != null) + this.getState((NamedElement)obj);
            info = element.getInformation();
        }
        if (presentationName != null) {
            StyledString styledString = new StyledString(presentationName);
            if (info != null) {
                assert (!info.isEmpty()) : "Parameter 'info' of method 'update' must not be empty";
                styledString.append("  [" + info + "]", new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        if (!$assertionsDisabled && textStyle == null) {
                            throw new AssertionError((Object)"Parameter 'textStyle' of method 'applyStyles' must not be null");
                        }
                        textStyle.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE);
                    }
                });
            }
            return styledString;
        }
        return super.getStyledText(obj);
    }
}

