/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architectureview;

import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedDependencyDeprecation;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedDependencyViolation;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedDeprecationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.AggregatedViolationInfo;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementsInfo;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViewContext;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.DirectoryFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureAssignmentElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.NamespaceFragmentComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.architecture.WorkspaceRootComponentContainer;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableDirectoryPathModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreDirectoryType;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.IPathType;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureViewComparator;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ArchitectureViewFilter;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.DeprecationBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.LogicalArchitectureViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.PhysicalArchitectureViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.UncheckedArchitectureViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.architectureview.ViolationBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.view.PresentationModeBasedViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.CreateMoveRenameRefactoringHandler;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithTree;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.view.TextFilterWidget;
import com.hello2morrow.sonargraph.ui.swt.base.view.TreeBasedViewNavigationStateUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ArchitectureViewShowInViewRequest;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.ElementGroup;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public final class ArchitectureView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
IViewWithTree,
DropTargetAdapter.IDropTargetActionHandler<NamedElement>,
DragSourceAdapter.IDragActionHandler<NamedElement> {
    private static final String FLAT_PRESENTATION_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.view.architecture.handledmenuitem.flat";
    private static final String HIERARCHICAL_PRESENATION_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.view.architecture.handledmenuitem.hierarchical";
    private static final String MIXED_PRESENTATION_TOOLITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.mixed";
    private static final String TAB_UNCHECKED_TEXT = "Unchecked";
    private static final String TAB_CHECKED_LOGICAL_TEXT = "Checked 'Logical'";
    private static final String TAB_CHECKED_PHYSICAL_TEXT = "Checked 'Physical'";
    private final ITreeViewerListener m_treeViewListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
            ArchitectureView.this.createAndAddNavigationState(NavigationState.Type.CONTENT_COLLAPSED, event, TreeBasedViewNavigationStateUtility.TreeOperation.COLLAPSE);
        }

        public void treeExpanded(TreeExpansionEvent event) {
            ArchitectureView.this.createAndAddNavigationState(NavigationState.Type.CONTENT_EXPANDED, event, TreeBasedViewNavigationStateUtility.TreeOperation.EXPAND);
        }
    };
    private final List<NamedElement> m_selectedRoots = new ArrayList<NamedElement>();
    private SelectedSection m_selectedSection = SelectedSection.CHECKED_PHYSICAL;
    private ArchitectureViewComparator m_comparator;
    private MoveRenameRefactoringInfo m_moveRenameDragAndDropInfo = null;
    private List<NamedElement> m_dragSelection = null;
    private TreeViewer m_uncheckedArchitectureFiles;
    private ArchitectureViewFilter m_physicalFilter;
    private TextFilterWidget m_physicalFilterWidget;
    private TreeViewer m_checkedPhysicalArchitectureFiles;
    private ArchitectureViewFilter m_logicalFilter;
    private TextFilterWidget m_logicalFilterWidget;
    private TreeViewer m_checkedLogicalArchitectureFiles;
    private CTabFolder m_tabFolder;
    private CTabItem m_tabCheckedPhysical;
    private CTabItem m_tabCheckedLogical;
    private CTabItem m_tabUnchecked;
    private PropertyTableViewer<AggregatedDependencyViolation> m_violations;
    private PropertyTableViewer<AggregatedDependencyDeprecation> m_deprecations;

    public IViewId getViewId() {
        return ViewId.ARCHITECTURE_VIEW;
    }

    protected EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    private TreeViewer getTreeViewer() {
        switch (this.m_selectedSection) {
            case CHECKED_PHYSICAL: {
                return this.m_checkedPhysicalArchitectureFiles;
            }
            case CHECKED_LOGICAL: {
                return this.m_checkedLogicalArchitectureFiles;
            }
            case UNCHECKED: {
                return this.m_uncheckedArchitectureFiles;
            }
            case VIOLATIONS: {
                return null;
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedSection);
        return null;
    }

    public void collapseAll() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            treeViewer.collapseAll();
            this.m_treeViewListener.treeCollapsed(null);
        }
    }

    public void expandAll() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            treeViewer.expandToLevel(2);
            this.m_treeViewListener.treeExpanded(null);
        }
    }

    private void updateTreeViewer(CTabItem tabItem, String text, TreeViewer viewer, boolean refreshOnly) {
        assert (tabItem != null) : "Parameter 'tabItem' of method 'updateTreeViewer' must not be null";
        assert (text != null) : "Parameter 'text' of method 'updateTreeViewer' must not be null";
        assert (viewer != null) : "Parameter 'viewer' of method 'updateTreeViewer' must not be null";
        Architecture architecture = (Architecture)viewer.getInput();
        if (architecture == null || !architecture.isValid() || !refreshOnly) {
            viewer.setInput((Object)((Files)this.getSoftwareSystem().getUniqueChild(Files.class)).getArchitecture());
            int numberOFArchitectureFiles = 0;
            TreeItem[] treeItemArray = viewer.getTree().getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem next = treeItemArray[n2];
                if (next.getData() instanceof ArchitectureFile) {
                    ++numberOFArchitectureFiles;
                }
                ++n2;
            }
            tabItem.setText(text + " (" + numberOFArchitectureFiles + ")");
        } else {
            viewer.refresh();
        }
    }

    private void updateArchitecture(boolean refreshOnly) {
        this.removeListeners();
        this.updateTreeViewer(this.m_tabCheckedPhysical, TAB_CHECKED_PHYSICAL_TEXT, this.m_checkedPhysicalArchitectureFiles, refreshOnly);
        this.updateTreeViewer(this.m_tabCheckedLogical, TAB_CHECKED_LOGICAL_TEXT, this.m_checkedLogicalArchitectureFiles, refreshOnly);
        this.updateTreeViewer(this.m_tabUnchecked, TAB_UNCHECKED_TEXT, this.m_uncheckedArchitectureFiles, refreshOnly);
        this.updateViolationsAndDeprecations();
        if (!refreshOnly) {
            this.applyFilter(this.m_physicalFilter, this.m_checkedPhysicalArchitectureFiles, this.m_physicalFilterWidget.getFilterTextInput());
            this.applyFilter(this.m_logicalFilter, this.m_checkedLogicalArchitectureFiles, this.m_logicalFilterWidget.getFilterTextInput());
            NavigationState state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId());
            if (state != null) {
                this.restore(state);
            }
        }
        this.addListeners();
    }

    private TreeViewer createTreeViewer(Composite parent, ArchitectureViewContentAndLabelProvider cp) {
        assert (parent != null) : "Parameter 'parent' of method 'createTreeViewer' must not be null";
        assert (cp != null) : "Parameter 'cp' of method 'createTreeViewer' must not be null";
        TreeViewer viewer = new TreeViewer(parent, 66306);
        viewer.setContentProvider((IContentProvider)cp);
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)cp));
        viewer.setComparator((ViewerComparator)this.m_comparator);
        return viewer;
    }

    private void applyFilter(ArchitectureViewFilter filter, TreeViewer viewer, String text) {
        assert (filter != null) : "Parameter 'filter' of method 'applyFilter' must not be null";
        assert (viewer != null) : "Parameter 'viewer' of method 'applyFilter' must not be null";
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null) {
            if (text != null && !text.isEmpty()) {
                filter.update(((Files)softwareSystem.getUniqueChild(Files.class)).getArchitecture(), text);
            } else {
                filter.reset();
            }
            viewer.refresh();
            if (filter.hasFiltered()) {
                viewer.getTree().setBackground(UiResourceManager.getInstance().getViewHasFilteredElementsColor());
                NamedElement firstCollected = filter.getFirstCollected();
                if (firstCollected != null) {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)firstCollected), true);
                }
            } else {
                viewer.getTree().setBackground(UiResourceManager.getInstance().getBackgroundColor());
            }
        }
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        CategoryProvider categoryProvider = new CategoryProvider();
        categoryProvider.setCategory(Interface.class, 1);
        categoryProvider.setCategory(Connector.class, 2);
        categoryProvider.setCategory(ConnectionScheme.class, 3);
        categoryProvider.setCategory(DirectoryFragmentComponentContainer.class, 4);
        categoryProvider.setCategory(NamespaceFragmentComponentContainer.class, 4);
        categoryProvider.setCategory(WorkspaceRootComponentContainer.class, 4);
        categoryProvider.setCategory(AssignedElement.class, 5);
        categoryProvider.setCategory(UnassignedInternal.class, 6);
        categoryProvider.setCategory(UnassignedExternal.class, 7);
        this.m_comparator = new ArchitectureViewComparator(categoryProvider);
        SashForm sashForm = new SashForm(viewContentArea, 512);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.m_tabFolder = SwtUtility.createTabFolder((Composite)sashForm);
        this.m_tabCheckedPhysical = new CTabItem(this.m_tabFolder, 0);
        this.m_tabCheckedPhysical.setText(TAB_CHECKED_PHYSICAL_TEXT);
        this.m_tabCheckedLogical = new CTabItem(this.m_tabFolder, 0);
        this.m_tabCheckedLogical.setText(TAB_CHECKED_LOGICAL_TEXT);
        this.m_tabUnchecked = new CTabItem(this.m_tabFolder, 0);
        this.m_tabUnchecked.setText(TAB_UNCHECKED_TEXT);
        this.m_uncheckedArchitectureFiles = this.createTreeViewer((Composite)this.m_tabFolder, new UncheckedArchitectureViewContentAndLabelProvider());
        this.m_tabUnchecked.setControl((Control)this.m_uncheckedArchitectureFiles.getTree());
        Composite physical = new Composite((Composite)this.m_tabFolder, 0);
        this.m_tabCheckedPhysical.setControl((Control)physical);
        physical.setLayout((Layout)new GridLayout(1, false));
        this.m_physicalFilter = new ArchitectureViewFilter(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
        this.m_physicalFilterWidget = new TextFilterWidget(physical, new TextFilterWidget.ITextFilterCallback(){

            public void applyTextFilter(String text) {
                ArchitectureView.this.applyFilter(ArchitectureView.this.m_physicalFilter, ArchitectureView.this.m_checkedPhysicalArchitectureFiles, text);
            }
        });
        GridData physicalFilterLayoutData = new GridData(4, 0x1000000, true, false);
        this.m_physicalFilterWidget.setLayoutData((Object)physicalFilterLayoutData);
        this.m_checkedPhysicalArchitectureFiles = this.createTreeViewer(physical, new PhysicalArchitectureViewContentAndLabelProvider());
        this.m_checkedPhysicalArchitectureFiles.setFilters(new ViewerFilter[]{this.m_physicalFilter});
        this.m_checkedPhysicalArchitectureFiles.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite logical = new Composite((Composite)this.m_tabFolder, 0);
        this.m_tabCheckedLogical.setControl((Control)logical);
        logical.setLayout((Layout)new GridLayout(1, false));
        this.m_logicalFilter = new ArchitectureViewFilter(IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
        this.m_logicalFilterWidget = new TextFilterWidget(logical, new TextFilterWidget.ITextFilterCallback(){

            public void applyTextFilter(String text) {
                ArchitectureView.this.applyFilter(ArchitectureView.this.m_logicalFilter, ArchitectureView.this.m_checkedLogicalArchitectureFiles, text);
            }
        });
        GridData logicalFilterLayoutData = new GridData(4, 0x1000000, true, false);
        this.m_logicalFilterWidget.setLayoutData((Object)logicalFilterLayoutData);
        this.m_checkedLogicalArchitectureFiles = this.createTreeViewer(logical, new LogicalArchitectureViewContentAndLabelProvider());
        this.m_checkedLogicalArchitectureFiles.setFilters(new ViewerFilter[]{this.m_logicalFilter});
        this.m_checkedLogicalArchitectureFiles.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_violations = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new ViolationBeanAdapter(), "dependencyCount", false, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_violations.addColumn("Violations", "file", "file", "fileImage", 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_violations.addColumn("From Artifact", "from", "from", "fromImage", 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_violations.addColumn("To Artifact", "to", "to", "toImage", 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_violations.addColumn("Restriction", "restriction", "restriction", null, 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_violations.addColumn("Parser Dependencies", "dependencyCount", "dependencyCount", null, 14, PropertyTableViewer.ColumnType.NUMBER);
        this.m_violations.addColumn("Ignored", "ignoredDependencyCount", "ignoredDependencyCount", null, 6, PropertyTableViewer.ColumnType.NUMBER);
        this.m_deprecations = new PropertyTableViewer((Composite)sashForm, (BeanPropertyReader.BeanAdapter)new DeprecationBeanAdapter(), "dependencyCount", false, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_deprecations.addColumn("Deprecations", "file", "file", "fileImage", 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_deprecations.addColumn("From Artifact", "from", "from", "fromImage", 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_deprecations.addColumn("To Artifact", "to", "to", "toImage", 18, PropertyTableViewer.ColumnType.TEXT);
        this.m_deprecations.addColumn("Restriction", "restriction", "restriction", null, 22, PropertyTableViewer.ColumnType.TEXT);
        this.m_deprecations.addColumn("Parser Dependencies", "dependencyCount", "dependencyCount", null, 14, PropertyTableViewer.ColumnType.NUMBER);
        this.m_deprecations.addColumn("Ignored", "ignoredDependencyCount", "ignoredDependencyCount", null, 6, PropertyTableViewer.ColumnType.NUMBER);
        sashForm.setWeights(new int[]{60, 20, 20});
        this.m_selectedSection = SelectedSection.CHECKED_PHYSICAL;
        this.m_tabFolder.setSelection(0);
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter((StructuredViewer)this.m_uncheckedArchitectureFiles, this, Collections.singletonList(NamedElement.class), false);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.m_uncheckedArchitectureFiles, 2, Collections.singletonList(dropTargetAdapter), Collections.singletonList(NamedElement.class), this);
        dropTargetAdapter = new DropTargetAdapter((StructuredViewer)this.m_checkedPhysicalArchitectureFiles, this, Collections.singletonList(NamedElement.class), false);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.m_checkedPhysicalArchitectureFiles, 2, Collections.singletonList(dropTargetAdapter), Collections.singletonList(NamedElement.class), this);
        dropTargetAdapter = new DropTargetAdapter((StructuredViewer)this.m_checkedLogicalArchitectureFiles, this, Collections.singletonList(NamedElement.class), false);
        new DragSourceAdapter<NamedElement>((StructuredViewer)this.m_checkedLogicalArchitectureFiles, 2, Collections.singletonList(dropTargetAdapter), Collections.singletonList(NamedElement.class), this);
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE, CoreDirectoryType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE, CoreDirectoryType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathCreatedEvent>(ModifiableDirectoryPathCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathCreatedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE, CoreDirectoryType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathDeletedEvent>(ModifiableDirectoryPathDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE, CoreDirectoryType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(false);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(true);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableDirectoryPathModifiedEvent>(ModifiableDirectoryPathModifiedEvent.class, (Object)this){

            public void handleEvent(ModifiableDirectoryPathModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (ArchitectureView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ARCHITECTURE, CoreDirectoryType.ARCHITECTURE})) {
                    ArchitectureView.this.updateArchitecture(false);
                }
            }
        });
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableDirectoryPathDeletedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    @Override
    public boolean validateDrag(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'validateDrag' must not be empty";
        MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isMoveRenameRefactoringPossible(new ArrayList<NamedElement>(elements));
        if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME) && this.getElementInteractor().dragAndDropStarted()) {
            this.m_moveRenameDragAndDropInfo = info;
            this.m_dragSelection = elements;
            return true;
        }
        return false;
    }

    @Override
    public void dragFinished() {
        this.m_moveRenameDragAndDropInfo = null;
        this.m_dragSelection = null;
        this.getElementInteractor().dragAndDropFinished();
    }

    @Override
    public boolean validateDrop(NamedElement target, int operation, TransferData transferType) {
        assert (target != null) : "Parameter 'target' of method 'validateDrop' must not be null";
        if (this.m_moveRenameDragAndDropInfo != null) {
            if (this.m_dragSelection.contains(target)) {
                return false;
            }
            MoveRenameRefactoringInfo info = ((IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class)).isPossibleMoveRefactoringTarget(this.m_moveRenameDragAndDropInfo, (Element)target);
            if (info != null && (info.getRefactoringType() == RefactoringType.MOVE || info.getRefactoringType() == RefactoringType.MOVE_RENAME)) {
                this.m_moveRenameDragAndDropInfo = info;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean perform(NamedElement target, DropLocation location, List<NamedElement> dropped, StructuredViewer viewer) {
        assert (target != null) : "Parameter 'target' of method 'perform' must not be null";
        assert (location != null) : "Parameter 'location' of method 'perform' must not be null";
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'perform' must not be empty";
        if (this.m_moveRenameDragAndDropInfo != null) {
            IIssueProvider issueProvider = (IIssueProvider)this.getSoftwareSystem().getExtension(IIssueProvider.class);
            CreateMoveRenameRefactoringHandler.requestUserToPerformMoveRenameRefactoring(issueProvider, this.m_moveRenameDragAndDropInfo);
            this.m_moveRenameDragAndDropInfo = null;
            return true;
        }
        this.m_moveRenameDragAndDropInfo = null;
        return false;
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_uncheckedArchitectureFiles.getTree(), this.m_checkedLogicalArchitectureFiles.getTree(), this.m_checkedPhysicalArchitectureFiles.getTree(), this.m_violations.getTable(), this.m_deprecations.getTable());
    }

    public List<Control> getViewComponents() {
        return this.getControlsForInteraction();
    }

    private void addListeners() {
        assert (this.m_uncheckedArchitectureFiles != null) : "'m_treeViewer' of method 'addListeners' must not be null";
        this.m_uncheckedArchitectureFiles.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_checkedLogicalArchitectureFiles.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_checkedPhysicalArchitectureFiles.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_uncheckedArchitectureFiles.addTreeListener(this.m_treeViewListener);
        this.m_checkedLogicalArchitectureFiles.addTreeListener(this.m_treeViewListener);
        this.m_checkedPhysicalArchitectureFiles.addTreeListener(this.m_treeViewListener);
        this.m_violations.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_deprecations.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void removeListeners() {
        assert (this.m_uncheckedArchitectureFiles != null) : "'m_treeViewer' of method 'removeListeners' must not be null";
        this.m_uncheckedArchitectureFiles.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_checkedPhysicalArchitectureFiles.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_checkedLogicalArchitectureFiles.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_uncheckedArchitectureFiles.removeTreeListener(this.m_treeViewListener);
        this.m_checkedLogicalArchitectureFiles.removeTreeListener(this.m_treeViewListener);
        this.m_checkedPhysicalArchitectureFiles.removeTreeListener(this.m_treeViewListener);
        this.m_violations.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_deprecations.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedSection) {
            case UNCHECKED: {
                return this.m_uncheckedArchitectureFiles.getTree();
            }
            case CHECKED_PHYSICAL: {
                return this.m_checkedPhysicalArchitectureFiles.getTree();
            }
            case CHECKED_LOGICAL: {
                return this.m_checkedLogicalArchitectureFiles.getTree();
            }
            case VIOLATIONS: {
                return this.m_violations.getTable();
            }
            case DEPRECATIONS: {
                return this.m_deprecations.getTable();
            }
        }
        assert (false) : "Unhandled section: " + String.valueOf((Object)this.m_selectedSection);
        return this.m_checkedPhysicalArchitectureFiles.getTree();
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        if (component == this.m_uncheckedArchitectureFiles.getTree()) {
            this.m_selectedSection = SelectedSection.UNCHECKED;
            this.updateSelectedRoots((IStructuredSelection)new StructuredSelection());
        } else if (component == this.m_checkedPhysicalArchitectureFiles.getTree()) {
            this.m_selectedSection = SelectedSection.CHECKED_PHYSICAL;
            this.updateSelectedRoots((IStructuredSelection)this.m_checkedPhysicalArchitectureFiles.getStructuredSelection());
        } else if (component == this.m_checkedLogicalArchitectureFiles.getTree()) {
            this.m_selectedSection = SelectedSection.CHECKED_LOGICAL;
            this.updateSelectedRoots((IStructuredSelection)this.m_checkedLogicalArchitectureFiles.getStructuredSelection());
        } else if (component == this.m_violations.getTable()) {
            this.m_selectedSection = SelectedSection.VIOLATIONS;
        } else if (component == this.m_deprecations.getTable()) {
            this.m_selectedSection = SelectedSection.DEPRECATIONS;
        } else assert (false) : "Unhandled component: " + String.valueOf(component);
    }

    public List<Element> getSelectedElements() {
        if (this.m_selectedSection == SelectedSection.CHECKED_PHYSICAL) {
            return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)((IStructuredSelection)this.m_checkedPhysicalArchitectureFiles.getSelection()));
        }
        if (this.m_selectedSection == SelectedSection.CHECKED_LOGICAL) {
            return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)((IStructuredSelection)this.m_checkedLogicalArchitectureFiles.getSelection()));
        }
        if (this.m_selectedSection == SelectedSection.UNCHECKED) {
            return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)((IStructuredSelection)this.m_uncheckedArchitectureFiles.getSelection()));
        }
        if (this.m_selectedSection == SelectedSection.VIOLATIONS) {
            return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.m_violations.getSelection());
        }
        if (this.m_selectedSection == SelectedSection.DEPRECATIONS) {
            return SelectionProviderAdapter.getElementsFromSelection((IStructuredSelection)this.m_deprecations.getSelection());
        }
        return Collections.emptyList();
    }

    public void softwareSystemShow(WorkbenchView.ShowMode mode) {
        this.updateViewOptions();
        this.updateArchitecture(false);
        super.softwareSystemShow(mode);
    }

    protected void softwareSystemModified(EnumSet<Modification> modifications, boolean restoredFromHistory) {
        assert (modifications != null) : "Parameter 'modifications' of method 'softwareSystemModified' must not be null";
        if (modifications.contains(Modification.ARCHITECTURE_MODIFIED)) {
            this.updateArchitecture(false);
        }
        super.softwareSystemModified(modifications, restoredFromHistory);
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (analyzerId == null || CoreAnalyzerId.ARCHITECTURE_CHECK.equals((Object)analyzerId)) {
            this.updateArchitecture(true);
        }
        super.analyzerModification(modification, analyzerId);
    }

    public void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.getContentArea().setRedraw(false);
        this.m_tabCheckedPhysical.setText(TAB_CHECKED_PHYSICAL_TEXT);
        this.m_tabCheckedLogical.setText(TAB_CHECKED_LOGICAL_TEXT);
        this.m_tabUnchecked.setText(TAB_UNCHECKED_TEXT);
        this.m_uncheckedArchitectureFiles.setInput(null);
        this.m_checkedPhysicalArchitectureFiles.setInput(null);
        this.m_checkedLogicalArchitectureFiles.setInput(null);
        this.m_violations.showData(null);
        this.m_deprecations.showData(null);
        this.m_selectedRoots.clear();
        this.getContentArea().setRedraw(true);
        this.addListeners();
    }

    public PresentationMode getPresentationMode() {
        if (this.getPart().getMenus().isEmpty()) {
            return PresentationMode.HIERARCHICAL;
        }
        MHandledMenuItem flatItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)FLAT_PRESENTATION_TOOLITEM_ID, MHandledMenuItem.class);
        if (flatItem != null && flatItem.isSelected()) {
            return PresentationMode.FLAT;
        }
        MHandledMenuItem mixedItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)MIXED_PRESENTATION_TOOLITEM_ID, MHandledMenuItem.class);
        if (mixedItem != null && mixedItem.isSelected()) {
            return PresentationMode.MIXED;
        }
        return PresentationMode.HIERARCHICAL;
    }

    public StructureMode getStructureMode() {
        PresentationMode presentationMode = this.getPresentationMode();
        switch (presentationMode) {
            case FLAT: {
                return StructureMode.NON_RECURSIVE;
            }
            case HIERARCHICAL: 
            case MIXED: {
                return StructureMode.RECURSIVE;
            }
        }
        assert (false) : "Unhandled presentation mode: " + String.valueOf(presentationMode);
        return StructureMode.UNSPECIFIED;
    }

    private void updateContentProvider(TreeViewer treeViewer, PresentationMode presentationMode) {
        assert (treeViewer != null) : "Parameter 'treeViewer' of method 'updateContentProvider' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'updateContentProvider' must not be null";
        PresentationModeBasedViewContentAndLabelProvider provider = (PresentationModeBasedViewContentAndLabelProvider)treeViewer.getContentProvider();
        provider.setPresentationMode(presentationMode);
    }

    private void updateViewOptions() {
        PresentationMode presentationMode = this.getPresentationMode();
        this.updateContentProvider(this.m_uncheckedArchitectureFiles, presentationMode);
        this.updateContentProvider(this.m_checkedLogicalArchitectureFiles, presentationMode);
        this.updateContentProvider(this.m_checkedPhysicalArchitectureFiles, presentationMode);
    }

    public void viewOptionsChanged() {
        this.removeListeners();
        this.getContentArea().setRedraw(false);
        this.updateViewOptions();
        this.m_uncheckedArchitectureFiles.refresh();
        this.m_checkedLogicalArchitectureFiles.refresh();
        this.m_checkedPhysicalArchitectureFiles.refresh();
        this.getContentArea().setRedraw(true);
        this.addListeners();
        this.createAndAddNavigationState(NavigationState.Type.VIEW_OPTIONS_CHANGED, null, null);
        super.viewOptionsChanged();
    }

    private void updateSelectedRoots(IStructuredSelection structuredSelection) {
        assert (structuredSelection != null) : "Parameter 'structuredSelection' of method 'updateSelectedRoots' must not be null";
        this.m_selectedRoots.clear();
        for (Object next : structuredSelection.toList()) {
            assert (next != null && next instanceof NamedElement) : "Unexpected class in method 'updateSelectedRoots': " + String.valueOf(next);
            this.m_selectedRoots.add((NamedElement)next);
        }
        this.updateViolationsAndDeprecations();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        if (event.getSource() == this.m_uncheckedArchitectureFiles) {
            this.m_selectedSection = SelectedSection.UNCHECKED;
        } else if (event.getSource() == this.m_checkedPhysicalArchitectureFiles) {
            this.m_selectedSection = SelectedSection.CHECKED_PHYSICAL;
            this.updateSelectedRoots(structuredSelection);
        } else if (event.getSource() == this.m_checkedLogicalArchitectureFiles) {
            this.m_selectedSection = SelectedSection.CHECKED_LOGICAL;
            this.updateSelectedRoots(structuredSelection);
        } else if (event.getSource() == this.m_violations.getTableViewer()) {
            this.m_selectedSection = SelectedSection.VIOLATIONS;
        } else if (event.getSource() == this.m_deprecations.getTableViewer()) {
            this.m_selectedSection = SelectedSection.DEPRECATIONS;
        } else assert (false) : "Unhandled source: " + String.valueOf(event.getSource());
        this.createAndAddNavigationState(NavigationState.Type.CONTENT_SELECTED, null, null);
        this.getSelectionProviderAdapter().handleSelectionChanged(structuredSelection);
    }

    public IContext getContext() {
        List selected;
        if (this.m_selectedSection == SelectedSection.VIOLATIONS && this.m_violations != null && !this.m_violations.isDisposed()) {
            List selected2 = this.m_violations.getSelected();
            if (selected2.size() == 1) {
                return new ArchitectureViewContext(super.getContext(), ((AggregatedDependencyViolation)selected2.get(0)).getProviderId());
            }
        } else if (this.m_selectedSection == SelectedSection.DEPRECATIONS && this.m_deprecations != null && !this.m_deprecations.isDisposed() && (selected = this.m_deprecations.getSelected()).size() == 1) {
            return new ArchitectureViewContext(super.getContext(), ((AggregatedDependencyDeprecation)selected.get(0)).getProviderId());
        }
        return super.getContext();
    }

    private void updateViolationsAndDeprecations() {
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && softwareSystem.isClearable()) {
            AggregatedViolationInfo violationInfo = ((IArchitectureProvider)softwareSystem.getExtension(IArchitectureProvider.class)).getAggregatedViolationInfo(this.m_selectedRoots);
            this.m_violations.setAdditionalFirstColumnInfo(violationInfo.getInfo());
            this.m_violations.showData((Collection)violationInfo.getViolations());
            AggregatedDeprecationInfo deprecationInfo = ((IArchitectureProvider)softwareSystem.getExtension(IArchitectureProvider.class)).getAggregatedDeprecationInfo(this.m_selectedRoots);
            this.m_deprecations.setAdditionalFirstColumnInfo(deprecationInfo.getInfo());
            this.m_deprecations.showData((Collection)deprecationInfo.getDeprecations());
        } else {
            this.m_violations.setAdditionalFirstColumnInfo(null);
            this.m_violations.showData(null);
            this.m_deprecations.setAdditionalFirstColumnInfo(null);
            this.m_deprecations.showData(null);
        }
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (control == this.m_uncheckedArchitectureFiles.getTree()) {
            this.m_uncheckedArchitectureFiles.setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_checkedLogicalArchitectureFiles.getTree()) {
            this.m_checkedLogicalArchitectureFiles.setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_checkedPhysicalArchitectureFiles.getTree()) {
            this.m_checkedPhysicalArchitectureFiles.setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_violations.getTable()) {
            this.m_violations.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (control == this.m_deprecations.getTable()) {
            this.m_deprecations.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Map<IStateData, Object> collectViewDataForState() {
        HashMap<IStateData, Object> stateData = new HashMap<IStateData, Object>(2);
        stateData.put(ArchitectureViewData.PRESENTATION_MODE, this.getPresentationMode());
        return stateData;
    }

    private void completeViewNavigationState(NavigationState state, TreeExpansionEvent event, TreeBasedViewNavigationStateUtility.TreeOperation treeOperation) {
        assert (state != null) : "Parameter 'state' of method 'completeViewNavigationState' must not be null";
        if (this.m_selectedSection == SelectedSection.UNCHECKED) {
            TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_uncheckedArchitectureFiles, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)treeOperation, this.collectViewDataForState());
        } else if (this.m_selectedSection == SelectedSection.CHECKED_LOGICAL) {
            TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_checkedLogicalArchitectureFiles, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)treeOperation, this.collectViewDataForState());
        } else if (this.m_selectedSection == SelectedSection.CHECKED_PHYSICAL) {
            TreeBasedViewNavigationStateUtility.createViewState((NavigationState)state, (IElementResolver)this.getSoftwareSystemProvider().getElementResolver(), (TreeViewer)this.m_checkedPhysicalArchitectureFiles, (TreeExpansionEvent)event, (TreeBasedViewNavigationStateUtility.TreeOperation)treeOperation, this.collectViewDataForState());
        }
        state.addConstant((IStateData)ArchitectureViewData.TAB, (Enum)this.m_selectedSection);
    }

    protected void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'completeNavigationStateForFocusGained' must not be null";
        this.completeViewNavigationState(state, null, null);
    }

    private void createAndAddNavigationState(NavigationState.Type type, TreeExpansionEvent event, TreeBasedViewNavigationStateUtility.TreeOperation treeOperation) {
        assert (type != null) : "Parameter 'type' of method 'createNavigationState' must not be null";
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), type);
        this.completeViewNavigationState(state, event, treeOperation);
        ViewNavigationManager.getInstance().addNavigationState(state);
    }

    private void restore(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restore' must not be null";
        this.m_selectedSection = (SelectedSection)state.getConstant((IStateData)ArchitectureViewData.TAB);
        assert (this.m_selectedSection != null) : "'m_selectedSection' of method 'restore' must not be null";
        if (this.m_selectedSection == SelectedSection.UNCHECKED) {
            PresentationMode presentationModeInState = (PresentationMode)state.getConstant((IStateData)ArchitectureViewData.PRESENTATION_MODE);
            PresentationMode currentPresentationMode = this.getPresentationMode();
            if (currentPresentationMode != presentationModeInState) {
                this.updatePresentationRadioOptionsInViewMenu((MMenu)this.getPart().getMenus().get(0), presentationModeInState);
                this.updateViewOptions();
                this.m_uncheckedArchitectureFiles.refresh();
            }
            this.m_tabFolder.setSelection(this.m_tabUnchecked);
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_uncheckedArchitectureFiles, (NavigationState)state, (IElementResolver)this.getElementResolver());
        } else if (this.m_selectedSection == SelectedSection.CHECKED_LOGICAL) {
            PresentationMode presentationModeInState = (PresentationMode)state.getConstant((IStateData)ArchitectureViewData.PRESENTATION_MODE);
            PresentationMode currentPresentationMode = this.getPresentationMode();
            if (currentPresentationMode != presentationModeInState) {
                this.updatePresentationRadioOptionsInViewMenu((MMenu)this.getPart().getMenus().get(0), presentationModeInState);
                this.updateViewOptions();
                this.m_checkedLogicalArchitectureFiles.refresh();
            }
            this.m_tabFolder.setSelection(this.m_tabCheckedLogical);
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_checkedLogicalArchitectureFiles, (NavigationState)state, (IElementResolver)this.getElementResolver());
            this.m_selectedRoots.clear();
            this.m_selectedRoots.addAll(state.getElements((IElementGroup)ElementGroup.SELECTION, NamedElement.class, this.getElementResolver()));
            this.updateViolationsAndDeprecations();
        } else if (this.m_selectedSection == SelectedSection.CHECKED_PHYSICAL) {
            PresentationMode presentationModeInState = (PresentationMode)state.getConstant((IStateData)ArchitectureViewData.PRESENTATION_MODE);
            PresentationMode currentPresentationMode = this.getPresentationMode();
            if (currentPresentationMode != presentationModeInState) {
                this.updatePresentationRadioOptionsInViewMenu((MMenu)this.getPart().getMenus().get(0), presentationModeInState);
                this.updateViewOptions();
                this.m_checkedPhysicalArchitectureFiles.refresh();
            }
            this.m_tabFolder.setSelection(this.m_tabCheckedPhysical);
            TreeBasedViewNavigationStateUtility.restoreViewState((TreeViewer)this.m_checkedPhysicalArchitectureFiles, (NavigationState)state, (IElementResolver)this.getElementResolver());
            this.m_selectedRoots.clear();
            this.m_selectedRoots.addAll(state.getElements((IElementGroup)ElementGroup.SELECTION, NamedElement.class, this.getElementResolver()));
            this.updateViolationsAndDeprecations();
        } else if (this.m_selectedSection != SelectedSection.VIOLATIONS && this.m_selectedSection != SelectedSection.DEPRECATIONS) assert (false) : "Unhandled view section: " + String.valueOf((Object)this.m_selectedSection);
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.removeListeners();
        this.getContentArea().setRedraw(false);
        this.restore(state);
        this.getContentArea().setRedraw(true);
        this.addListeners();
    }

    protected void updatePresentationRadioOptionsInViewMenu(MMenu parentMenu, PresentationMode presentationMode) {
        assert (parentMenu != null) : "Parameter 'parentMenu' of method 'updateRadioOptionsInViewMenu' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'updateRadioOptionsInViewMenu' must not be null";
        MHandledMenuItem hierarchicalItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)parentMenu, (String)HIERARCHICAL_PRESENATION_TOOLITEM_ID, MHandledMenuItem.class);
        assert (hierarchicalItem != null) : "'firstItem' of method 'beforeTreeSelectionAndExpansionRestore' must not be null";
        hierarchicalItem.setSelected(PresentationMode.HIERARCHICAL == presentationMode);
        MHandledMenuItem mixedItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)parentMenu, (String)MIXED_PRESENTATION_TOOLITEM_ID, MHandledMenuItem.class);
        assert (mixedItem != null) : "'firstItem' of method 'beforeTreeSelectionAndExpansionRestore' must not be null";
        mixedItem.setSelected(PresentationMode.MIXED == presentationMode);
        MHandledMenuItem flatItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)parentMenu, (String)FLAT_PRESENTATION_TOOLITEM_ID, MHandledMenuItem.class);
        assert (flatItem != null) : "'secondItem' of method 'beforeTreeSelectionAndExpansionRestore' must not be null";
        flatItem.setSelected(PresentationMode.FLAT == presentationMode);
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'finishShowInView' must not be empty";
        ArchitectureFile architectureFile = options.size() == 1 && options.get(0) instanceof ArchitectureViewShowInViewRequest ? ((ArchitectureViewShowInViewRequest)options.get(0)).getArchitectureFile() : null;
        ArchitectureElementsInfo info = ((IArchitectureProvider)this.getSoftwareSystem().getExtension(IArchitectureProvider.class)).getArchitectureElementsInfo(elements, architectureFile);
        if (!info.isEmpty()) {
            this.getContentArea().setRedraw(false);
            this.removeListeners();
            StructuredSelection physical = null;
            StructuredSelection logial = null;
            StructuredSelection unchecked = null;
            if (!info.getPhysical().isEmpty()) {
                physical = new StructuredSelection(info.getPhysical());
                this.m_checkedPhysicalArchitectureFiles.setSelection((ISelection)physical, true);
            }
            if (!info.getLogical().isEmpty()) {
                logial = new StructuredSelection(info.getLogical());
                this.m_checkedLogicalArchitectureFiles.setSelection((ISelection)logial, true);
            }
            if (!info.getUnchecked().isEmpty()) {
                unchecked = new StructuredSelection(info.getUnchecked());
                this.m_uncheckedArchitectureFiles.setSelection((ISelection)unchecked, true);
            }
            CTabItem select = null;
            StructuredSelection structuredSelection = null;
            if (info.getPhysical().size() >= info.getLogical().size() && info.getPhysical().size() >= info.getUnchecked().size()) {
                select = this.m_tabCheckedPhysical;
                structuredSelection = physical;
            } else if (info.getLogical().size() >= info.getPhysical().size() && info.getLogical().size() >= info.getUnchecked().size()) {
                select = this.m_tabCheckedLogical;
                structuredSelection = logial;
            } else {
                select = this.m_tabUnchecked;
                structuredSelection = unchecked;
            }
            if (structuredSelection != null) {
                this.updateSelectedRoots((IStructuredSelection)structuredSelection);
            }
            if (select != null) {
                this.m_tabFolder.setSelection(select);
            }
            this.createAndAddNavigationState(NavigationState.Type.CONTENT_SELECTED, null, null);
            this.addListeners();
            this.getContentArea().setRedraw(true);
        }
        super.finishShowInView(sourceViewId, elements, options);
    }

    public List<IStandardEnumeration> getAdditionalShowInViewOptions() {
        return new ArrayList<PresentationMode>(Arrays.asList(this.getPresentationMode()));
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        return element instanceof IArchitectureAssignmentElement ? ((IArchitectureAssignmentElement)element).getRepresentedElement() : super.getLinkNamedElement(element);
    }

    public static enum ArchitectureViewData implements IStateData
    {
        PRESENTATION_MODE,
        TAB;

    }

    private static enum SelectedSection implements IStandardEnumeration
    {
        CHECKED_PHYSICAL,
        CHECKED_LOGICAL,
        UNCHECKED,
        VIOLATIONS,
        DEPRECATIONS;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

