/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.Connection;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Translatable;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.GridPosition;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureRegistry;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentAnchorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigureRouter;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigure;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UmlComponentUsesDependencyFigureRouter
extends UmlComponentDependencyFigureRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmlComponentUsesDependencyFigureRouter.class);

    UmlComponentUsesDependencyFigureRouter(IUmlComponentFigureRegistry registry) {
        super(registry);
    }

    private boolean verticalSegmentsOverlap(int segment1_y1, int segment1_y2, int segment2_y1, int segment2_y2) {
        if (segment1_y1 > segment1_y2) {
            if (segment2_y1 > segment1_y1 && segment2_y2 > segment1_y1) {
                return false;
            }
            if (segment2_y1 < segment1_y2 && segment2_y2 < segment1_y2) {
                return false;
            }
        } else {
            if (segment2_y1 < segment1_y1 && segment2_y2 < segment1_y1) {
                return false;
            }
            if (segment2_y1 > segment1_y2 && segment2_y2 > segment1_y2) {
                return false;
            }
        }
        return true;
    }

    private Point handleVerticalSegmentCollision(UmlComponentDependencyFigure dependencyFigure, Point bendPoint, int targetPosY, int offset) {
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'handleVerticalSegmentCollision' must not be null";
        assert (bendPoint != null) : "Parameter 'bendPoint' of method 'handleVerticalSegmentCollision' must not be null";
        int segment1_y1 = bendPoint.y;
        int segment1_y2 = targetPosY;
        for (UmlComponentDependencyFigure next : this.getAlreadyRouted()) {
            if (next == dependencyFigure) continue;
            PointList nextDependencyPoints = next.getPoints();
            if (nextDependencyPoints.size() >= 2 && nextDependencyPoints.size() % 2 == 0) {
                boolean collides = false;
                int i = 0;
                while (i < nextDependencyPoints.size() - 1) {
                    int segment2_y2;
                    int segment2_y1;
                    Point nextFromPoint = nextDependencyPoints.getPoint(i);
                    Point nextToPoint = nextDependencyPoints.getPoint(i + 1);
                    if (nextFromPoint.x == nextToPoint.x && bendPoint.x == nextFromPoint.x && this.verticalSegmentsOverlap(segment1_y1, segment1_y2, segment2_y1 = nextFromPoint.y, segment2_y2 = nextToPoint.y)) {
                        collides = true;
                        LOGGER.trace("Vertical segment collision with: " + String.valueOf((Object)next));
                        break;
                    }
                    ++i;
                }
                if (!collides) continue;
                bendPoint.setX(bendPoint.x + offset);
                continue;
            }
            LOGGER.warn("Has no segments: " + String.valueOf((Object)next));
        }
        return bendPoint;
    }

    private boolean horizontalSegmentsOverlap(int segment1_x1, int segment1_x2, int segment2_x1, int segment2_x2) {
        if (segment1_x1 > segment1_x2) {
            if (segment2_x1 > segment1_x1 && segment2_x2 > segment1_x1) {
                return false;
            }
            if (segment2_x1 < segment1_x2 && segment2_x2 < segment1_x2) {
                return false;
            }
        } else {
            if (segment2_x1 < segment1_x1 && segment2_x2 < segment1_x1) {
                return false;
            }
            if (segment2_x1 > segment1_x2 && segment2_x2 > segment1_x2) {
                return false;
            }
        }
        return true;
    }

    private Point handleHorizontalSegmentCollision(UmlComponentDependencyFigure dependencyFigure, Point bendPoint, int targetPosX, int offset) {
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'handleHorizontalSegmentCollision' must not be null";
        assert (bendPoint != null) : "Parameter 'bendPoint' of method 'handleHorizontalSegmentCollision' must not be null";
        int segment1_x1 = bendPoint.x;
        int segment1_x2 = targetPosX;
        for (UmlComponentDependencyFigure next : this.getAlreadyRouted()) {
            if (next == dependencyFigure) continue;
            PointList nextDependencyPoints = next.getPoints();
            if (nextDependencyPoints.size() >= 2 && nextDependencyPoints.size() % 2 == 0) {
                boolean collides = false;
                int i = 0;
                while (i < nextDependencyPoints.size() - 1) {
                    int segment2_x2;
                    int segment2_x1;
                    Point nextFromPoint = nextDependencyPoints.getPoint(i);
                    Point nextToPoint = nextDependencyPoints.getPoint(i + 1);
                    if (nextFromPoint.y == nextToPoint.y && bendPoint.y == nextFromPoint.y && this.horizontalSegmentsOverlap(segment1_x1, segment1_x2, segment2_x1 = nextFromPoint.x, segment2_x2 = nextToPoint.x)) {
                        collides = true;
                        LOGGER.trace("Horizontal segment collision with: " + String.valueOf((Object)next));
                        break;
                    }
                    ++i;
                }
                if (!collides) continue;
                bendPoint.setY(bendPoint.y + offset);
                continue;
            }
            LOGGER.warn("Has no segments: " + String.valueOf((Object)next));
        }
        return bendPoint;
    }

    private int calculateFirstBendPointPosX(IUmlComponentFigureGridLayout layout, int column, int startPosX) {
        assert (layout != null) : "Parameter 'layout' of method 'calculateFirstBendPointPosX' must not be null";
        int currentPosX = layout.getVerticalGridLinePosX(column);
        while (currentPosX - layout.getDependencyOffset() >= startPosX + 4) {
            currentPosX -= layout.getDependencyOffset();
        }
        return currentPosX;
    }

    private int getUsableOffsetOfGridLineArea(IUmlComponentFigureGridLayout layout) {
        assert (layout != null) : "Parameter 'layout' of method 'getUsableOffsetOfGridLineArea' must not be null";
        return layout.getSpaceOnEachSideOfGridLines() - layout.getDependencyOffset();
    }

    private void routeLeft(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeLeft' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeLeft' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeLeft' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeLeft' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeLeft' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeLeft' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeLeft' must not be null";
        int bendPoint_1_PosX = this.calculateFirstBendPointPosX(layout, sourceComponentFigure.getGridPosition().getColumn() + 1, startPoint.x);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = layout.getHorizontalGridLinePosY(sourceComponentFigure.getGridPosition().getRow() + 1) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        int bendPoint_3_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn()) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_2 = this.handleHorizontalSegmentCollision(dependencyFigure, new Point(bendPoint_1.x, bendPoint_2_PosY), bendPoint_3_PosX, layout.getDependencyOffset());
        points.addPoint(bendPoint_2);
        int bendPoint_4_PosY = endPoint.y;
        Point bendPoint_3 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_3_PosX, bendPoint_2.y), bendPoint_4_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_3);
        points.addPoint(new Point(bendPoint_3.x, bendPoint_4_PosY));
    }

    private void routeRight(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeRight' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeRight' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeRight' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeRight' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeRight' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeRight' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeRight' must not be null";
        int bendPoint_1_PosX = this.calculateFirstBendPointPosX(layout, sourceComponentFigure.getGridPosition().getColumn() + 1, startPoint.x);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = layout.getHorizontalGridLinePosY(sourceComponentFigure.getGridPosition().getRow()) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        int bendPoint_3_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn());
        Point bendPoint_2 = this.handleHorizontalSegmentCollision(dependencyFigure, new Point(bendPoint_1.x, bendPoint_2_PosY), bendPoint_3_PosX, layout.getDependencyOffset());
        points.addPoint(bendPoint_2);
        int bendPoint_4_PosY = endPoint.y;
        Point bendPoint_3 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_3_PosX, bendPoint_2.y), bendPoint_4_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_3);
        points.addPoint(new Point(bendPoint_3.x, bendPoint_4_PosY));
    }

    private void routeDownLeftOneRow(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeDownLeftOneRow' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeDownLeftOneRow' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeDownLeftOneRow' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeDownLeftOneRow' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeDownLeftOneRow' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeDownLeftOneRow' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeDownLeftOneRow' must not be null";
        int bendPoint_1_PosX = this.calculateFirstBendPointPosX(layout, sourceComponentFigure.getGridPosition().getColumn() + 1, startPoint.x);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = layout.getHorizontalGridLinePosY(sourceComponentFigure.getGridPosition().getRow() + 1) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        int bendPoint_3_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn()) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_2 = this.handleHorizontalSegmentCollision(dependencyFigure, new Point(bendPoint_1.x, bendPoint_2_PosY), bendPoint_3_PosX, layout.getDependencyOffset());
        points.addPoint(bendPoint_2);
        int bendPoint_4_PosY = endPoint.y;
        Point bendPoint_3 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_3_PosX, bendPoint_2.y), bendPoint_4_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_3);
        points.addPoint(new Point(bendPoint_3.x, bendPoint_4_PosY));
    }

    private void routeDownLeft(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeDownLeft' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeDownLeft' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeDownLeft' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeDownLeft' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeDownLeft' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeDownLeft' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeDownLeft' must not be null";
        int bendPoint_1_PosX = layout.getVerticalGridLinePosX(sourceComponentFigure.getGridPosition().getColumn() + 1) + this.getUsableOffsetOfGridLineArea(layout);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = layout.getHorizontalGridLinePosY(targetComponentFigure.getGridPosition().getRow()) + this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, -layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        int bendPoint_3_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn()) + this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_2 = this.handleHorizontalSegmentCollision(dependencyFigure, new Point(bendPoint_1.x, bendPoint_2_PosY), bendPoint_3_PosX, -layout.getDependencyOffset());
        points.addPoint(bendPoint_2);
        int bendPoint_4_PosY = endPoint.y;
        Point bendPoint_3 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_3_PosX, bendPoint_2.y), bendPoint_4_PosY, -layout.getDependencyOffset());
        points.addPoint(bendPoint_3);
        points.addPoint(new Point(bendPoint_3.x, bendPoint_4_PosY));
    }

    private void routeDownRightOneColumn(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeDownRightAdjacent' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeDownRightAdjacent' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeDownRightAdjacent' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeDownRightAdjacent' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeDownRightAdjacent' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeDownRightAdjacent' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeDownRightAdjacent' must not be null";
        int bendPoint_1_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn()) - this.getUsableOffsetOfGridLineArea(layout);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = endPoint.y;
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        points.addPoint(new Point(bendPoint_1.x, bendPoint_2_PosY));
    }

    private void routeDownRight(IUmlComponentFigureGridLayout layout, UmlComponentDependencyFigure dependencyFigure, UmlComponentFigure sourceComponentFigure, UmlComponentFigure targetComponentFigure, Point startPoint, Point endPoint, PointList points) {
        assert (layout != null) : "Parameter 'layout' of method 'routeDownRight' must not be null";
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'routeDownRight' must not be null";
        assert (sourceComponentFigure != null) : "Parameter 'sourceComponentFigure' of method 'routeDownRight' must not be null";
        assert (targetComponentFigure != null) : "Parameter 'targetComponentFigure' of method 'routeDownRight' must not be null";
        assert (sourceComponentFigure != targetComponentFigure) : "Same instances";
        assert (startPoint != null) : "Parameter 'startPoint' of method 'routeDownRight' must not be null";
        assert (endPoint != null) : "Parameter 'endPoint' of method 'routeDownRight' must not be null";
        assert (points != null) : "Parameter 'points' of method 'routeDownRight' must not be null";
        int bendPoint_1_PosX = this.calculateFirstBendPointPosX(layout, sourceComponentFigure.getGridPosition().getColumn() + 1, startPoint.x);
        int bendPoint_1_PosY = startPoint.y;
        int bendPoint_2_PosY = layout.getHorizontalGridLinePosY(sourceComponentFigure.getGridPosition().getRow() + 1) + this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_1 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_1_PosX, bendPoint_1_PosY), bendPoint_2_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_1);
        int bendPoint_3_PosX = layout.getVerticalGridLinePosX(targetComponentFigure.getGridPosition().getColumn()) - this.getUsableOffsetOfGridLineArea(layout);
        Point bendPoint_2 = this.handleHorizontalSegmentCollision(dependencyFigure, new Point(bendPoint_1.x, bendPoint_2_PosY), bendPoint_3_PosX, -layout.getDependencyOffset());
        points.addPoint(bendPoint_2);
        int bendPoint_4_PosY = endPoint.y;
        Point bendPoint_3 = this.handleVerticalSegmentCollision(dependencyFigure, new Point(bendPoint_3_PosX, bendPoint_2.y), bendPoint_4_PosY, layout.getDependencyOffset());
        points.addPoint(bendPoint_3);
        points.addPoint(new Point(bendPoint_3.x, bendPoint_4_PosY));
    }

    private RouteDirection calculateRouteDirection(GridPosition sourceGridPosition, GridPosition targetGridPosition) {
        assert (sourceGridPosition != null) : "Parameter 'sourceGridPosition' of method 'calculateRouteDirection' must not be null";
        assert (targetGridPosition != null) : "Parameter 'targetGridPosition' of method 'calculateRouteDirection' must not be null";
        if (sourceGridPosition.getRow() == targetGridPosition.getRow()) {
            if (sourceGridPosition.getColumn() >= targetGridPosition.getColumn()) {
                return RouteDirection.LEFT;
            }
            if (sourceGridPosition.getColumn() + 1 == targetGridPosition.getColumn()) {
                return RouteDirection.RIGHT_ONE_COLUMN;
            }
            return RouteDirection.RIGHT;
        }
        if (sourceGridPosition.getColumn() >= targetGridPosition.getColumn()) {
            if (sourceGridPosition.getRow() + 1 == targetGridPosition.getRow()) {
                return RouteDirection.DOWN_LEFT_ONE_ROW;
            }
            return RouteDirection.DOWN_LEFT;
        }
        if (sourceGridPosition.getColumn() + 1 == targetGridPosition.getColumn()) {
            return RouteDirection.DOWN_RIGHT_ONE_COLUMN;
        }
        return RouteDirection.DOWN_RIGHT;
    }

    private int sortBySourceConnector(UmlComponentDependencyFigure d1, UmlComponentDependencyFigure d2) {
        assert (d1 != null) : "Parameter 'd1' of method 'sortBySourceConnector' must not be null";
        assert (d2 != null) : "Parameter 'd2' of method 'sortBySourceConnector' must not be null";
        UmlComponentAnchor<?> anchor1 = ((UmlComponentAnchorFigure)d1.getSourceAnchor().getOwner()).getUmlComponentAnchor();
        UmlComponentAnchor<?> anchor2 = ((UmlComponentAnchorFigure)d2.getSourceAnchor().getOwner()).getUmlComponentAnchor();
        NamedElement parent1 = anchor1.getParent();
        assert (parent1 != null) : "'parent1' of method 'sortBySourceConnector' must not be null";
        int index1 = parent1.getIndexOf(UmlComponentAnchor.class, anchor1);
        NamedElement parent2 = anchor2.getParent();
        assert (parent2 != null) : "'parent2' of method 'sortBySourceConnector' must not be null";
        int index2 = parent2.getIndexOf(UmlComponentAnchor.class, anchor2);
        int indexDelta = index1 - index2;
        return indexDelta;
    }

    private int sortByTargetInterface(UmlComponentDependencyFigure d1, UmlComponentDependencyFigure d2) {
        assert (d1 != null) : "Parameter 'd1' of method 'sortByTargetInterface' must not be null";
        assert (d2 != null) : "Parameter 'd2' of method 'sortByTargetInterface' must not be null";
        UmlComponentAnchor<?> anchor1 = ((UmlComponentAnchorFigure)d1.getTargetAnchor().getOwner()).getUmlComponentAnchor();
        UmlComponentAnchor<?> anchor2 = ((UmlComponentAnchorFigure)d2.getTargetAnchor().getOwner()).getUmlComponentAnchor();
        NamedElement parent1 = anchor1.getParent();
        assert (parent1 != null) : "'parent1' of method 'sortByTargetInterface' must not be null";
        int index1 = parent1.getIndexOf(UmlComponentAnchor.class, anchor1);
        NamedElement parent2 = anchor2.getParent();
        assert (parent2 != null) : "'parent2' of method 'sortByTargetInterface' must not be null";
        int index2 = parent2.getIndexOf(UmlComponentAnchor.class, anchor2);
        int indexDelta = index2 - index1;
        return indexDelta;
    }

    List<UmlComponentDependencyFigure> sort(List<UmlComponentDependencyFigure> dependencyFigures) {
        assert (dependencyFigures != null) : "Parameter 'dependencyFigures' of method 'sort' must not be null";
        if (dependencyFigures.isEmpty()) {
            return dependencyFigures;
        }
        final IUmlComponentFigureRegistry registry = this.getRegistry();
        Comparator<UmlComponentDependencyFigure> sorter = new Comparator<UmlComponentDependencyFigure>(){

            @Override
            public int compare(UmlComponentDependencyFigure d1, UmlComponentDependencyFigure d2) {
                if (!$assertionsDisabled && d1 == null) {
                    throw new AssertionError((Object)"Parameter 'd1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && d2 == null) {
                    throw new AssertionError((Object)"Parameter 'd2' of method 'compare' must not be null");
                }
                UmlComponentFigure sourceComponentFigure1 = registry.getUmlComponentFigure(((UmlComponent.UmlComponentDependency)d1.getConnection()).getSourceComponent());
                if (!$assertionsDisabled && sourceComponentFigure1 == null) {
                    throw new AssertionError((Object)"'sourceComponentFigure1' of method 'compare' must not be null");
                }
                GridPosition sourceGridPosition1 = sourceComponentFigure1.getGridPosition();
                UmlComponentFigure targetComponentFigure1 = registry.getUmlComponentFigure(((UmlComponent.UmlComponentDependency)d1.getConnection()).getTargetComponent());
                if (!$assertionsDisabled && targetComponentFigure1 == null) {
                    throw new AssertionError((Object)"'targetComponentFigure1' of method 'compare' must not be null");
                }
                GridPosition targetGridPosition1 = targetComponentFigure1.getGridPosition();
                RouteDirection routeDirection1 = UmlComponentUsesDependencyFigureRouter.this.calculateRouteDirection(sourceGridPosition1, targetGridPosition1);
                UmlComponentFigure sourceComponentFigure2 = registry.getUmlComponentFigure(((UmlComponent.UmlComponentDependency)d2.getConnection()).getSourceComponent());
                if (!$assertionsDisabled && sourceComponentFigure2 == null) {
                    throw new AssertionError((Object)"'sourceComponentFigure2' of method 'compare' must not be null");
                }
                GridPosition sourceGridPosition2 = sourceComponentFigure2.getGridPosition();
                UmlComponentFigure targetComponentFigure2 = registry.getUmlComponentFigure(((UmlComponent.UmlComponentDependency)d2.getConnection()).getTargetComponent());
                if (!$assertionsDisabled && targetComponentFigure2 == null) {
                    throw new AssertionError((Object)"'targetComponentFigure2' of method 'compare' must not be null");
                }
                GridPosition targetGridPosition2 = targetComponentFigure2.getGridPosition();
                RouteDirection routeDirection2 = UmlComponentUsesDependencyFigureRouter.this.calculateRouteDirection(sourceGridPosition2, targetGridPosition2);
                int sourceRow = sourceGridPosition1.getRow() - sourceGridPosition2.getRow();
                if (sourceRow != 0) {
                    return sourceRow;
                }
                int sourceColumn = sourceGridPosition1.getColumn() - sourceGridPosition2.getColumn();
                if (sourceColumn != 0) {
                    return sourceColumn;
                }
                int indexConnectorDelta = UmlComponentUsesDependencyFigureRouter.this.sortBySourceConnector(d1, d2);
                if (indexConnectorDelta != 0) {
                    return indexConnectorDelta;
                }
                if (routeDirection1 != routeDirection2) {
                    return routeDirection1.ordinal() - routeDirection2.ordinal();
                }
                switch (routeDirection1) {
                    case DOWN_LEFT_ONE_ROW: {
                        int targetRowDelta = targetGridPosition2.getRow() - targetGridPosition1.getRow();
                        if (targetRowDelta != 0) {
                            return targetRowDelta;
                        }
                        int targetColumnDelta = targetGridPosition1.getColumn() - targetGridPosition2.getColumn();
                        if (targetColumnDelta != 0) {
                            return targetColumnDelta;
                        }
                        int indexDelta = UmlComponentUsesDependencyFigureRouter.this.sortByTargetInterface(d1, d2);
                        if (indexDelta == 0) break;
                        return indexDelta;
                    }
                    case DOWN_LEFT: {
                        int targetRowDelta = targetGridPosition1.getRow() - targetGridPosition2.getRow();
                        if (targetRowDelta != 0) {
                            return targetRowDelta;
                        }
                        int targetColumnDelta = targetGridPosition1.getColumn() - targetGridPosition2.getColumn();
                        if (targetColumnDelta != 0) {
                            return targetColumnDelta;
                        }
                        int indexDelta = UmlComponentUsesDependencyFigureRouter.this.sortByTargetInterface(d1, d2);
                        if (indexDelta == 0) break;
                        return indexDelta;
                    }
                    case DOWN_RIGHT_ONE_COLUMN: 
                    case DOWN_RIGHT: {
                        int targetRowDelta = targetGridPosition2.getRow() - targetGridPosition1.getRow();
                        if (targetRowDelta != 0) {
                            return targetRowDelta;
                        }
                        int targetColumnDelta = targetGridPosition1.getColumn() - targetGridPosition2.getColumn();
                        if (targetColumnDelta != 0) {
                            return targetColumnDelta;
                        }
                        int indexDelta = UmlComponentUsesDependencyFigureRouter.this.sortByTargetInterface(d1, d2);
                        if (indexDelta == 0) break;
                        return indexDelta;
                    }
                    case LEFT: {
                        int columnDelta = targetGridPosition1.getColumn() - targetGridPosition2.getColumn();
                        if (columnDelta == 0) break;
                        return columnDelta;
                    }
                    case RIGHT_ONE_COLUMN: 
                    case RIGHT: {
                        int columnDelta = targetGridPosition2.getColumn() - targetGridPosition1.getColumn();
                        if (columnDelta == 0) break;
                        return columnDelta;
                    }
                }
                return 1;
            }
        };
        Collections.sort(dependencyFigures, sorter);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Sorted dependencies start ###");
            for (UmlComponentDependencyFigure next : dependencyFigures) {
                LOGGER.debug(String.valueOf(next.getConnection()));
            }
            LOGGER.debug("### Sorted dependencies end ###");
        }
        return dependencyFigures;
    }

    @Override
    protected void performRoute(UmlComponentDependencyFigure dependencyFigure) {
        assert (dependencyFigure != null) : "Parameter 'dependencyFigure' of method 'performRoute' must not be null";
        PointList points = dependencyFigure.getPoints();
        points.removeAllPoints();
        Point startPoint = new Point(this.getStartPoint((Connection)dependencyFigure));
        dependencyFigure.translateToRelative((Translatable)startPoint);
        points.addPoint(startPoint);
        Point endPoint = new Point(this.getEndPoint((Connection)dependencyFigure));
        dependencyFigure.translateToRelative((Translatable)endPoint);
        UmlComponent.UmlComponentDependency dependency = (UmlComponent.UmlComponentDependency)dependencyFigure.getConnection();
        assert (dependency != null && dependency instanceof UmlComponent.Uses) : "Unexpected class in method 'performRoute': " + String.valueOf(dependency);
        UmlComponent sourceComponent = dependency.getSourceComponent();
        UmlComponentFigure sourceComponentFigure = this.getRegistry().getUmlComponentFigure(sourceComponent);
        assert (sourceComponentFigure != null) : "'sourceComponentFigure' of method 'performRoute' must not be null";
        IUmlComponentFigureGridLayout layout = sourceComponentFigure.getGridLayout();
        UmlComponent targetComponent = dependency.getTargetComponent();
        UmlComponentFigure targetComponentFigure = this.getRegistry().getUmlComponentFigure(targetComponent);
        assert (targetComponentFigure != null) : "'targetComponentFigure' of method 'performRoute' must not be null";
        assert (targetComponentFigure.getGridLayout() == layout) : "Different layouts";
        RouteDirection routeDirection = this.calculateRouteDirection(sourceComponentFigure.getGridPosition(), targetComponentFigure.getGridPosition());
        LOGGER.debug(String.valueOf(dependency) + ": " + String.valueOf(sourceComponentFigure.getGridPosition()) + " -> " + String.valueOf(targetComponentFigure.getGridPosition()) + " [" + String.valueOf((Object)routeDirection) + "]");
        switch (routeDirection) {
            case LEFT: {
                this.routeLeft(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            case RIGHT_ONE_COLUMN: {
                break;
            }
            case RIGHT: {
                this.routeRight(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            case DOWN_LEFT_ONE_ROW: {
                this.routeDownLeftOneRow(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            case DOWN_LEFT: {
                this.routeDownLeft(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            case DOWN_RIGHT_ONE_COLUMN: {
                this.routeDownRightOneColumn(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            case DOWN_RIGHT: {
                this.routeDownRight(layout, dependencyFigure, sourceComponentFigure, targetComponentFigure, startPoint, endPoint, points);
                break;
            }
            default: {
                assert (false) : "Unhandled route: " + String.valueOf((Object)routeDirection);
                break;
            }
        }
        points.addPoint(endPoint);
        dependencyFigure.setPoints(points);
    }

    static enum RouteDirection {
        LEFT,
        RIGHT_ONE_COLUMN,
        RIGHT,
        DOWN_LEFT_ONE_ROW,
        DOWN_LEFT,
        DOWN_RIGHT_ONE_COLUMN,
        DOWN_RIGHT;

    }
}

