/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SecondaryTreeNodeFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureAnchor;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TreeEdgeFigureRouter;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.dependenciesview.LinePropertiesUtilities;

final class TreeEdgeFigure
extends DrawConnectionFigure<ArchitecturalViewNode.ArchitecturalViewDependency> {
    private static final int CONTAINS_TOLERANCE = 3;
    private static final int FULL_CIRCLE_RADIUS = 6;
    private static final int FULL_CIRCLE_DIAMETER = 12;

    public static int getNeededArcWidthBeingCircle(int distance, int weight) {
        assert (distance > 0) : "'distance' must be greater than 0";
        int lineWidth = LinePropertiesUtilities.calculateLineWidth((int)weight);
        return distance / 2 + lineWidth + (lineWidth % 2 == 0 ? 0 : 1);
    }

    TreeEdgeFigure(ArchitecturalViewNode.ArchitecturalViewDependency edge, DrawConnectionFigure.IConnectionFigureProvider<ArchitecturalViewNode.ArchitecturalViewDependency> connector, TreeEdgeFigureAnchor source, TreeEdgeFigureAnchor target, TreeEdgeFigureRouter connectionRouter) {
        super((Object)edge);
        assert (edge != null) : "Parameter 'edge' of method 'TreeEdgeFigure' must not be null";
        assert (connector != null) : "Parameter 'connector' of method 'TreeEdgeFigure' must not be null";
        assert (source != null) : "Parameter 'source' of method 'TreeEdgeFigure' must not be null";
        assert (target != null) : "Parameter 'target' of method 'TreeEdgeFigure' must not be null";
        assert (connectionRouter != null) : "Parameter 'connectionRouter' of method 'TreeEdgeFigure' must not be null";
        this.initialize(connector, source, target, (ConnectionRouter)connectionRouter);
    }

    public TreeEdgeFigureAnchor getSourceAnchor() {
        return (TreeEdgeFigureAnchor)super.getSourceAnchor();
    }

    public TreeEdgeFigureAnchor getTargetAnchor() {
        return (TreeEdgeFigureAnchor)super.getTargetAnchor();
    }

    public int getFromNodeIndex() {
        return ((SecondaryTreeNodeFigure)this.getSourceAnchor().getOwner()).getIndex();
    }

    public int getToNodeIndex() {
        return ((SecondaryTreeNodeFigure)this.getTargetAnchor().getOwner()).getIndex();
    }

    public int getWeight() {
        return ((ArchitecturalViewNode.ArchitecturalViewDependency)this.getConnection()).getNumberOfParserDependencies();
    }

    private int getLineWidth() {
        return LinePropertiesUtilities.calculateLineWidth((int)this.getWeight());
    }

    public Mode getMode() {
        int to;
        int from = this.getFromNodeIndex();
        if (from == (to = this.getToNodeIndex())) {
            return Mode.FULL_ARC;
        }
        if (from < to) {
            return Mode.HALF_ARC_LEFT;
        }
        return Mode.HALF_ARC_RIGHT;
    }

    private int getHeight(int y1, int y2) {
        int height = Math.abs(y1 - y2);
        if (height == 0) {
            height = 2;
        }
        if (height % 2 != 0) {
            ++height;
        }
        return height + 1;
    }

    private int getWidth(TreeEdgeFigureRouter router, int height, Mode mode) {
        assert (router != null) : "Parameter 'router' of method 'getWidth' must not be null";
        assert (height >= 2) : "'height' must be greater than 0";
        assert (mode != null) : "Parameter 'mode' of method 'getWidth' must not be null";
        int width = height / 2;
        if (router.isArcSpaceLimited()) {
            int availableWidth = switch (mode) {
                case Mode.HALF_ARC_LEFT -> router.getAvailableArcSpaceLeft();
                case Mode.HALF_ARC_RIGHT -> router.getAvailableArcSpaceRight();
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled mode" + String.valueOf((Object)mode)));
                    }
                    yield width;
                }
            };
            if (width > availableWidth) {
                width = availableWidth;
            }
        }
        return width;
    }

    public void setPoints(PointList pointList) {
        assert (pointList != null) : "Parameter 'pointList' of method 'setPoints' must not be null";
        assert (pointList.size() == 2) : "Unexpected point list size (2): " + String.valueOf((Object)this);
        assert (this.getPoints() == pointList) : "Different instances";
        ConnectionRouter connectionRouter = this.getConnectionRouter();
        assert (connectionRouter != null && connectionRouter instanceof TreeEdgeFigureRouter) : "Unexpected class in method 'setPoints': " + String.valueOf(connectionRouter);
        TreeEdgeFigureRouter router = (TreeEdgeFigureRouter)connectionRouter;
        Rectangle bounds = new Rectangle();
        Point firstPoint = pointList.getFirstPoint();
        Point lastPoint = pointList.getLastPoint();
        Mode mode = this.getMode();
        switch (mode) {
            case HALF_ARC_LEFT: {
                bounds.y = firstPoint.y + 1;
                bounds.height = this.getHeight(lastPoint.y, firstPoint.y);
                bounds.width = this.getWidth(router, bounds.height, mode);
                bounds.x = firstPoint.x - bounds.width;
                break;
            }
            case HALF_ARC_RIGHT: {
                bounds.y = lastPoint.y + 1;
                bounds.height = this.getHeight(firstPoint.y, lastPoint.y);
                bounds.width = this.getWidth(router, bounds.height, mode);
                bounds.x = lastPoint.x + 3;
                break;
            }
            case FULL_ARC: {
                bounds.x = firstPoint.x + 1;
                bounds.y = firstPoint.y - 12 + 4;
                bounds.width = 12;
                bounds.height = 12;
                break;
            }
            default: {
                assert (false) : "Unhandled mode" + String.valueOf((Object)mode);
                break;
            }
        }
        this.setBounds(bounds);
        this.firePropertyChange("points", null, pointList);
        this.repaint();
    }

    private boolean highlight(ArchitecturalViewNode.ArchitecturalViewDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'highlight' must not be null";
        if (!this.getProvider().hasSelection()) {
            return true;
        }
        if (dependency.isSelected()) {
            return true;
        }
        ArchitecturalViewNode fromNode = dependency.getFrom();
        ArchitecturalViewNode toNode = dependency.getTo();
        return fromNode.isSelected() || toNode.isSelected() || fromNode.isParentSelected() || toNode.isParentSelected();
    }

    protected void performPaintFigure(Graphics graphics, ArchitecturalViewNode.ArchitecturalViewDependency dependency) {
        assert (graphics != null) : "Parameter 'graphics' of method 'performPaintFigure' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'performPaintFigure' must not be null";
        int lineWidth = LinePropertiesUtilities.setLineAttributes((int)dependency.getNumberOfParserDependencies(), (int)dependency.getNumberOfParserDependenciesViolating(), (int)dependency.getNumberOfParserDependenciesViolatingToBeFixed(), (int)dependency.getNumberOfParserDependenciesViolatingIgnored(), (int)dependency.getNumberOfParserDependenciesDeprecated(), (int)dependency.getNumberOfParserDependenciesDeprecatedToBeFixed(), (int)dependency.getNumberOfParserDependenciesDeprecatedIgnored(), (boolean)this.highlight(dependency), (Graphics)graphics);
        Rectangle bounds = this.getBounds();
        switch (this.getMode()) {
            case HALF_ARC_LEFT: {
                if (lineWidth <= 2) {
                    graphics.drawArc(bounds.x + 1, bounds.y + 1, bounds.width * 2 - 1, bounds.height - 3, 90, 180);
                    break;
                }
                graphics.drawArc(bounds.x + 2, bounds.y + 2, bounds.width * 2 - 5, bounds.height - 5, 90, 180);
                break;
            }
            case HALF_ARC_RIGHT: {
                if (lineWidth <= 2) {
                    graphics.drawArc(bounds.x - bounds.width, bounds.y + 1, bounds.width * 2 - 2, bounds.height - 3, 270, 180);
                    break;
                }
                graphics.drawArc(bounds.x - bounds.width, bounds.y + 2, bounds.width * 2 - 3, bounds.height - 5, 270, 180);
                break;
            }
            case FULL_ARC: {
                if (lineWidth <= 2) {
                    graphics.drawArc(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3, 245, 290);
                    break;
                }
                graphics.drawArc(bounds.x + 2, bounds.y + 2, bounds.width - 5, bounds.height - 5, 270, 270);
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.getMode());
                break;
            }
        }
    }

    private boolean halfArcContainsPoint(Point center, int x, int y) {
        assert (center != null) : "Parameter 'center' of method 'halfArcContainsPoint' must not be null";
        double outer = Math.pow(x - center.x, 2.0) / Math.pow(this.bounds.width + 3, 2.0) + Math.pow(y - center.y, 2.0) / Math.pow(this.bounds.height / 2 + 3, 2.0);
        if (outer <= 1.0) {
            int lineWidth = this.getLineWidth();
            double inner = Math.pow(x - center.x, 2.0) / Math.pow(this.bounds.width - lineWidth - 3, 2.0) + Math.pow(y - center.y, 2.0) / Math.pow(this.bounds.height / 2 - lineWidth - 3, 2.0);
            if (inner >= 1.0) {
                return true;
            }
        }
        return false;
    }

    private boolean fullArcContainsPoint(int x, int y) {
        Point center = this.bounds.getCenter();
        double distance = Math.sqrt((x - center.x) * (x - center.x) + (y - center.y) * (y - center.y));
        return distance <= 6.0 && distance >= (double)(6 - this.getLineWidth() - 1);
    }

    public boolean containsPoint(int x, int y) {
        Rectangle bounds = this.getBounds();
        if (!bounds.contains(x, y)) {
            return false;
        }
        Mode mode = this.getMode();
        switch (mode) {
            case HALF_ARC_LEFT: {
                return this.halfArcContainsPoint(bounds.getRight(), x, y);
            }
            case HALF_ARC_RIGHT: {
                return this.halfArcContainsPoint(bounds.getLeft(), x, y);
            }
            case FULL_ARC: {
                return this.fullArcContainsPoint(x, y);
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)mode);
        return false;
    }

    static enum Mode {
        HALF_ARC_LEFT,
        HALF_ARC_RIGHT,
        FULL_ARC;

    }
}

