/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.MoveRenameNamedElementInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferRefactoringsExecutionInfo;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class TransferRefactoringsWizardPage
extends StandardWizardPage {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_TRANSFER_REFACTORINGS.getStandardName();
    private final TransferRefactoringsExecutionInfo m_info;
    private Button m_deleteRefactoringRelatedOperations;

    TransferRefactoringsWizardPage(TransferRefactoringsExecutionInfo info) {
        super(NAME, CoreDialogId.ARCHITECTURAL_VIEW_TRANSFER_REFACTORINGS.getPresentationName());
        assert (info != null) : "Parameter 'info' of method 'GenerateArchitectureFileWizardPage' must not be null";
        this.m_info = info;
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void createContent(Composite composite) {
        int numberOfDeletedParserDependencies;
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        final Button transferArchitecture = new Button(composite, 32);
        transferArchitecture.setText("Transfer Refactorings");
        transferArchitecture.setSelection(this.m_info.transfer());
        transferArchitecture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransferRefactoringsWizardPage.this.m_info.transfer(transferArchitecture.getSelection());
                if (TransferRefactoringsWizardPage.this.m_info.transfer()) {
                    TransferRefactoringsWizardPage.this.m_deleteRefactoringRelatedOperations.setEnabled(true);
                } else {
                    TransferRefactoringsWizardPage.this.setPageComplete(true);
                    TransferRefactoringsWizardPage.this.m_deleteRefactoringRelatedOperations.setEnabled(false);
                }
                TransferRefactoringsWizardPage.this.getContainer().updateButtons();
            }
        });
        transferArchitecture.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        int numberOfDeletedElements = this.m_info.getNumberOfDeletedElements();
        if (numberOfDeletedElements > 0) {
            Label imageLabel = new Label(composite, 0);
            imageLabel.setImage(UiResourceManager.getInstance().getImage("DeleteRefactoring"));
            imageLabel.setLayoutData((Object)new GridData(1, 2, false, false));
            Label elementsInfo = new Label(composite, 0);
            elementsInfo.setText("Create 1 refactoring to delete " + numberOfDeletedElements + " " + this.m_info.getDeleteElementPresentationName().toLowerCase() + (numberOfDeletedElements == 1 ? "." : "s."));
            elementsInfo.setLayoutData((Object)new GridData(4, 2, true, false));
        }
        if ((numberOfDeletedParserDependencies = this.m_info.getNumberOfDeletedParserDependencies()) > 0) {
            Label imageLabel = new Label(composite, 0);
            imageLabel.setImage(UiResourceManager.getInstance().getImage("DeleteRefactoring"));
            imageLabel.setLayoutData((Object)new GridData(1, 2, false, false));
            Label dependenciesInfo = new Label(composite, 0);
            dependenciesInfo.setText("Create 1 refactoring to delete " + numberOfDeletedParserDependencies + (numberOfDeletedParserDependencies == 1 ? " parser dependency." : " parser dependencies."));
            dependenciesInfo.setLayoutData((Object)new GridData(4, 2, true, false));
        }
        if (this.m_info.hasMoveRenameRefactoringData()) {
            for (Map.Entry nextEntry : this.m_info.getMoveRenameRefactoringData().entrySet()) {
                MoveRenameNamedElementInfo.Topic nextTopic = (MoveRenameNamedElementInfo.Topic)nextEntry.getKey();
                int nextSize = ((List)nextEntry.getValue()).size();
                Label imageLabel = new Label(composite, 0);
                imageLabel.setImage(UiResourceManager.getInstance().getImage(nextTopic.getImageResourceName()));
                imageLabel.setLayoutData((Object)new GridData(1, 2, false, false));
                Label rename = new Label(composite, 0);
                rename.setText("Create " + nextSize + " " + nextTopic.getPresentationName().toLowerCase() + (nextSize == 1 ? " refactoring." : " refactorings."));
                rename.setLayoutData((Object)new GridData(4, 2, true, false));
            }
        }
        this.m_deleteRefactoringRelatedOperations = new Button(composite, 32);
        this.m_deleteRefactoringRelatedOperations.setText("Delete refactoring related operations");
        this.m_deleteRefactoringRelatedOperations.setSelection(this.m_info.deleteRefactoringRelatedOperations());
        this.m_deleteRefactoringRelatedOperations.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransferRefactoringsWizardPage.this.m_info.setDeleteRefactoringRelatedOperations(TransferRefactoringsWizardPage.this.m_deleteRefactoringRelatedOperations.getSelection());
            }
        });
        this.m_deleteRefactoringRelatedOperations.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
    }
}

