/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SplitArchitecturalViewBeforeCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.SplitArchitecturalViewBeforeOperationDialog;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;

public final class SplitArchitecturalViewBeforeOperationHandler
extends ArchitecturalViewHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.SPLIT_ARCHITECTURAL_VIEW_BEFORE_OPERATION;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> selection, String defaultLabel) {
                if (!$assertionsDisabled && selection == null) {
                    throw new AssertionError((Object)"Parameter 'selection' of method 'getLabel' must not be null");
                }
                ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No software system available");
                }
                ArchitecturalViewOperation operation = (ArchitecturalViewOperation)SplitArchitecturalViewBeforeOperationHandler.getSingleSelection(ArchitecturalViewOperation.class, selection, (boolean)false);
                if (!$assertionsDisabled && operation == null) {
                    throw new AssertionError((Object)"'element' of method 'getLabel' must not be null");
                }
                StrictPair possible = ((IArchitecturalViewOperationProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewOperationProvider.class)).isSplitBeforeOperationPossible(operation);
                if (!$assertionsDisabled && possible == null) {
                    throw new AssertionError((Object)"'possible' of method 'getLabel' must not be null");
                }
                return "Split Architectural View Before Operation " + ((ArchitecturalViewOperation)possible.getSecond()).getIndex() + " [" + ((ArchitecturalViewFile)possible.getFirst()).getIdentifyingPath() + "]...";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.FILE;
            }

            public boolean addSeparatorBefore() {
                return true;
            }
        };
    }

    @Override
    protected boolean mayBeExecutedInView(IViewId viewId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'mayBeExecutedInView' must not be null";
        return viewId == ViewId.ARCHITECTURAL_OPERATIONS_VIEW;
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        ArchitecturalViewOperation operation;
        if (this.mayBeExecuted(selection) && (operation = (ArchitecturalViewOperation)SplitArchitecturalViewBeforeOperationHandler.getSingleSelection(ArchitecturalViewOperation.class, (List)selection.getElements(), (boolean)false)) != null) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No software system available";
            return ((IArchitecturalViewOperationProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewOperationProvider.class)).isSplitBeforeOperationPossible(operation) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        final ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No software system available";
        ArchitecturalViewOperation operation = (ArchitecturalViewOperation)SplitArchitecturalViewBeforeOperationHandler.getSingleSelection(ArchitecturalViewOperation.class, (List)selection.getElements(), (boolean)false);
        assert (operation != null) : "'operation' of method 'execute' must not be null";
        final StrictPair possible = ((IArchitecturalViewOperationProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewOperationProvider.class)).isSplitBeforeOperationPossible(operation);
        assert (possible != null) : "'possible' of method 'execute' must not be null";
        SplitArchitecturalViewBeforeCommand command = new SplitArchitecturalViewBeforeCommand(provider, new SplitArchitecturalViewBeforeCommand.ISplitArchitecturalViewBeforeInteraction(){

            public boolean collect(SplitArchitecturalViewBeforeCommand.SplitArchitecturalViewBeforeData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                RunnableWithResult<SplitArchitecturalViewBeforeOperationDialog> runnable = new RunnableWithResult<SplitArchitecturalViewBeforeOperationDialog>(){

                    public void run() {
                        SplitArchitecturalViewBeforeOperationDialog dialog = new SplitArchitecturalViewBeforeOperationDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), ((IArchitecturalViewProvider)provider.getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewNameValidator(), "Splits '" + ((ArchitecturalViewFile)possible.getFirst()).getIdentifyingPath() + "' before operation with index " + ((ArchitecturalViewOperation)possible.getSecond()).getIndex() + ". A new file is created\ncontaining all operations index " + ((ArchitecturalViewOperation)possible.getSecond()).getIndex() + " and above. Those operations are removed\nfrom '" + ((ArchitecturalViewFile)possible.getFirst()).getIdentifyingPath() + ". The new file depends on '" + ((ArchitecturalViewFile)possible.getFirst()).getIdentifyingPath() + "' and will\nbe set as currently opened in case '" + ((ArchitecturalViewFile)possible.getFirst()).getIdentifyingPath() + "' has been loaded.\n\nThis operation cannot be undone!\n");
                        if (dialog.open() == 0) {
                            this.setResult(dialog);
                        }
                    }
                };
                UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                if (runnable.getResult() != null) {
                    data.setSplit((ArchitecturalViewFile)possible.getFirst());
                    data.setOperation((ArchitecturalViewOperation)possible.getSecond());
                    data.setName(((SplitArchitecturalViewBeforeOperationDialog)runnable.getResult()).getName());
                    data.setDescription(((SplitArchitecturalViewBeforeOperationDialog)runnable.getResult()).getDescription());
                    return true;
                }
                return false;
            }

            public void processSplitArchitecturalViewResult(OperationResultWithOutcome<ArchitecturalViewFile> result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processSplitArchitecturalViewResult' must not be null");
                }
                UserInterfaceAdapter.getInstance().process(result);
            }
        });
        UserInterfaceAdapter.getInstance().run((Command)command);
    }
}

