/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationView;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import jakarta.annotation.PostConstruct;
import java.util.EnumSet;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class SortModeToolControl
implements ExplorationView.ISortModeListener {
    private ExplorationView m_view;
    private Composite m_parent;
    private Composite m_composite;

    private void createComposite(ExplorationViewOperationMode operationMode, EnumSet<ExplorationViewSortMode> sortModes, ExplorationViewSortMode selectSortMode, boolean visible) {
        assert (operationMode != null) : "Parameter 'operationMode' of method 'createComposite' must not be null";
        assert (sortModes != null && !sortModes.isEmpty()) : "Parameter 'sortModes' of method 'createComposite' must not be empty";
        assert (selectSortMode != null) : "Parameter 'selectSortMode' of method 'createComposite' must not be null";
        assert (this.m_view != null) : "'m_view' of method 'createComposite' must not be null";
        assert (this.m_parent != null) : "'m_parent' of method 'createComposite' must not be null";
        if (this.m_composite != null) {
            this.m_composite.dispose();
            this.m_composite = null;
        }
        this.m_composite = new Composite(this.m_parent, 0);
        this.m_composite.setLayout((Layout)new GridLayout(1 + sortModes.size(), false));
        this.m_composite.setVisible(visible);
        Label label = new Label(this.m_composite, 0x1000000);
        label.setFont(UiResourceManager.getInstance().getFont(1));
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Sort nodes:");
        for (final ExplorationViewSortMode next : sortModes) {
            Button nextButton = new Button(this.m_composite, 16);
            nextButton.setText(next.getPresentationName());
            if (operationMode.isArchitectureModelling()) {
                if (next == ExplorationViewSortMode.LEVELIZE) {
                    nextButton.setToolTipText(next.getDescription() + "\nNOTE: Only this mode supports all operations since most of them depend on the artifact definition order.");
                } else {
                    nextButton.setToolTipText(next.getDescription() + "\nNOTE: This mode does not support all operations since most of them depend on the artifact definition order.");
                }
            } else {
                nextButton.setToolTipText(next.getDescription());
            }
            nextButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            nextButton.setSelection(next == selectSortMode);
            nextButton.setData((Object)next);
            nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SortModeToolControl.this.m_view.setLevelizationMode(next);
                }
            });
        }
    }

    @PostConstruct
    public void createControls(Composite parent, MPart part) {
        assert (parent != null) : "Parameter 'parent' of method 'createControls' must not be null";
        assert (part != null) : "Parameter 'part' of method 'createControls' must not be null";
        assert (this.m_view == null) : "'m_view' of method 'createControls' must be null";
        assert (this.m_parent == null) : "'m_parent' of method 'createControls' must be null";
        this.m_parent = parent;
        this.m_parent.setLayout((Layout)new FillLayout());
        this.m_view = (ExplorationView)RcpUtility.getWorkbenchView((MPart)part, ExplorationView.class);
        assert (this.m_view != null) : "'m_view' of method 'createControls' must not be null";
        this.m_view.setLevelizationModeListener(this);
        this.createComposite(ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL, EnumSet.allOf(ExplorationViewSortMode.class), ExplorationViewSortMode.getDefault(), false);
    }

    @Override
    public void modified(ExplorationViewOperationMode operationMode, EnumSet<ExplorationViewSortMode> sortModes, ExplorationViewSortMode selectSortMode) {
        assert (operationMode != null) : "Parameter 'operationMode' of method 'modified' must not be null";
        assert (sortModes != null && !sortModes.isEmpty()) : "Parameter 'sortModes' of method 'modified' must not be empty";
        assert (selectSortMode != null) : "Parameter 'selectSortMode' of method 'modified' must not be null";
        assert (this.m_view != null) : "'m_view' of method 'modified' must not be null";
        assert (this.m_parent != null) : "'m_parent' of method 'modified' must not be null";
        assert (this.m_composite != null) : "'m_composite' of method 'modified' must not be null";
        this.createComposite(operationMode, sortModes, selectSortMode, true);
        this.m_parent.layout(true);
        this.m_parent.getParent().layout(true);
    }
}

