/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.SearchCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewTreeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LayoutCreator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PartialAlternativeInfoComposite;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MoveElementsDialog
extends ExplorationViewDialog
implements Predicate<ArchitecturalViewNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveElementsDialog.class);
    private static final String PREFERENCES_PREFIX = CoreDialogId.ARCHITECTURAL_VIEW_MOVE_ELEMENTS.getStandardName() + ".";
    private static final String PATTERN = "Pattern";
    private final Set<ArchitecturalViewNode> m_invalidTargets = new THashSet();
    private final Set<ArchitecturalViewNode> m_includeExplicitely = new THashSet();
    private final ISoftwareSystemProvider m_systemProvider;
    private final IArchitecturalViewProvider m_provider;
    private final List<ArchitecturalViewNode> m_elements;
    private final PartialAlternativeInfo m_partialAlternativeInfo;
    private final ExplorationViewRepresentation m_representation;
    private PropertyTableViewer<ArchitecturalViewElement> m_toBeMoved;
    private PartialAlternativeInfoComposite m_partialAlternativeInfoComposite;
    private Composite m_targetPositionComposite;
    private Button m_byName;
    private Button m_byFullName;
    private Button m_autoMatchTrailingCharacters;
    private Button m_ignoreCase;
    private Text m_searchPattern;
    private TreeViewer m_targetViewer;
    private Text m_targetValidityInfo;
    private boolean m_containsAtLeastOneArtifact;
    private TargetPosition m_targetPosition = TargetPosition.AS_CHILD_OF_TARGET;
    private MovableTargetInfo m_targetInfo;
    private ArchitecturalViewElement m_selected;
    private CancellableWorkerContext m_currentWorkerContext;
    private SearchCommand m_currentCommand;

    MoveElementsDialog(Shell shell, ISoftwareSystemProvider systemProvider, IArchitecturalViewProvider provider, List<ArchitecturalViewNode> elements, PartialAlternativeInfo partialAlternativeInfo) {
        super(shell, CoreDialogId.ARCHITECTURAL_VIEW_MOVE_ELEMENTS.getPresentationName());
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'MoveElementsDialog' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'MoveElementsDialog' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'MoveElementsDialog' must not be empty";
        this.m_systemProvider = systemProvider;
        this.m_provider = provider;
        this.m_elements = elements;
        this.m_partialAlternativeInfo = partialAlternativeInfo;
        this.m_representation = this.m_provider.getArchitecturalViewRepresentation(this.m_elements);
        assert (this.m_representation != null) : "'representation' of method 'fillDialogArea' must not be null";
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ARCHITECTURAL_VIEW_MOVE_ELEMENTS;
    }

    protected void applyData() {
        if (!this.m_containsAtLeastOneArtifact) {
            IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
            boolean isSearchByFullName = settings.getBoolean(PREFERENCES_PREFIX + SearchCriteria.FULL_NAME.name(), false);
            this.m_byName.setSelection(!isSearchByFullName);
            this.m_byFullName.setSelection(isSearchByFullName);
            this.m_autoMatchTrailingCharacters.setSelection(settings.getBoolean(PREFERENCES_PREFIX + SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), true));
            this.m_ignoreCase.setSelection(settings.getBoolean(PREFERENCES_PREFIX + SearchCriteria.IGNORE_CASE.name(), true));
            this.m_searchPattern.setText(settings.get(PREFERENCES_PREFIX + PATTERN, ""));
        }
    }

    protected IEclipsePreferences saveData() {
        if (!this.m_containsAtLeastOneArtifact) {
            IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.standalone");
            settings.putBoolean(PREFERENCES_PREFIX + SearchCriteria.FULL_NAME.name(), this.m_byFullName.getSelection());
            settings.putBoolean(PREFERENCES_PREFIX + SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS.name(), this.m_autoMatchTrailingCharacters.getSelection());
            settings.putBoolean(PREFERENCES_PREFIX + SearchCriteria.IGNORE_CASE.name(), this.m_ignoreCase.getSelection());
            settings.put(PREFERENCES_PREFIX + PATTERN, this.m_searchPattern.getText());
            return settings;
        }
        return null;
    }

    protected Point getPreferredSize() {
        return new Point(800, 600);
    }

    protected Point getMinimumSize() {
        return new Point(600, 400);
    }

    protected final Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        assert (okButton != null) : "'okButton' of method 'createButtonBar' must not be null";
        okButton.setEnabled(false);
        return control;
    }

    private void elementsToBeMovedChanged(boolean isInitialization) {
        if (!isInitialization) {
            this.cancelSearch();
            this.m_searchPattern.setText("");
            this.m_invalidTargets.clear();
        }
        this.m_containsAtLeastOneArtifact = false;
        for (ArchitecturalViewNode architecturalViewNode : this.getElements()) {
            if (architecturalViewNode instanceof ArtifactNode) {
                this.m_containsAtLeastOneArtifact = true;
                this.m_invalidTargets.add(architecturalViewNode);
                this.m_invalidTargets.addAll(architecturalViewNode.getChildrenRecursively(ArtifactNode.class, new Class[]{AssignableNode.class}));
                continue;
            }
            if (!(architecturalViewNode instanceof RecursiveNode)) continue;
            this.m_invalidTargets.add(architecturalViewNode);
            this.m_invalidTargets.addAll(architecturalViewNode.getChildrenRecursively(RecursiveNode.class, new Class[]{AssignableToArtifactNode.class}));
        }
        if (this.m_containsAtLeastOneArtifact) {
            this.m_targetPositionComposite.setEnabled(true);
            Control[] controlArray = this.m_targetPositionComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(true);
                ++n2;
            }
        } else {
            this.m_targetPositionComposite.setEnabled(false);
            Control[] controlArray = this.m_targetPositionComposite.getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control control = controlArray[n3];
                control.setEnabled(false);
                ++n3;
            }
        }
        if (!this.m_containsAtLeastOneArtifact) {
            this.m_searchPattern.setEnabled(true);
            this.m_byName.setEnabled(true);
            this.m_byFullName.setEnabled(true);
            this.m_autoMatchTrailingCharacters.setEnabled(true);
            this.m_ignoreCase.setEnabled(true);
        } else {
            this.m_searchPattern.setEnabled(false);
            this.m_byName.setEnabled(false);
            this.m_byFullName.setEnabled(false);
            this.m_autoMatchTrailingCharacters.setEnabled(false);
            this.m_ignoreCase.setEnabled(false);
        }
        if (!isInitialization) {
            this.getContents().setRedraw(false);
            this.m_toBeMoved.showData(this.getElements());
            this.m_targetViewer.refresh();
            this.m_targetViewer.setSelection((ISelection)new StructuredSelection());
            this.getContents().setRedraw(true);
        }
    }

    private void updateTargetInfo() {
        if (this.m_selected != null) {
            switch (this.m_targetPosition) {
                case BEFORE_TARGET: {
                    ArchitecturalViewElement parent = (ArchitecturalViewElement)this.m_selected.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (parent != null) : "'parent' of method 'updateTargetInfo' must not be null";
                    this.m_targetInfo = new MovableTargetInfo(parent, this.m_selected.getRelativeIndex());
                    break;
                }
                case AS_CHILD_OF_TARGET: {
                    this.m_targetInfo = new MovableTargetInfo(this.m_selected, -1);
                    break;
                }
                case AFTER_TARGET: {
                    ArchitecturalViewElement parent = (ArchitecturalViewElement)this.m_selected.getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (parent != null) : "'parent' of method 'updateTargetInfo' must not be null";
                    this.m_targetInfo = new MovableTargetInfo(parent, Math.min(this.m_selected.getRelativeIndex() + 1, parent.getNumberOfChildren()));
                    break;
                }
                default: {
                    assert (false) : "Unhandled target position: " + String.valueOf((Object)this.m_targetPosition);
                    break;
                }
            }
            StringBuilder builder = new StringBuilder();
            MoveElementsInfo operationInfo = this.m_provider.isPossibleTargetInMoveElements(this.getElements(), this.m_targetInfo);
            if (operationInfo.isApplicable()) {
                builder.append("Selected target is valid.");
            } else {
                this.m_targetInfo = null;
                builder.append("Selected target is not valid.");
            }
            if (!operationInfo.isApplicable() || operationInfo.hasAdditionalElementInfo()) {
                for (String next : operationInfo.getElementInfo()) {
                    builder.append("\n").append(next);
                }
            }
            this.m_targetValidityInfo.setText(builder.toString());
        } else {
            this.m_targetInfo = null;
            this.m_targetValidityInfo.setText("No Target Selected.");
        }
        Button okButton = this.getButton(0);
        assert (okButton != null) : "'okButton' of method 'selectionChanged' must not be null";
        okButton.setEnabled(this.m_targetInfo != null);
    }

    private void cancelSearch() {
        if (this.m_currentWorkerContext != null) {
            this.m_currentWorkerContext.cancel();
            this.m_currentWorkerContext = null;
            this.m_currentCommand = null;
        }
    }

    @Override
    public boolean test(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'test' must not be null";
        return node.isRecursive() && !node.isExternal() && !node.isDeleted();
    }

    private void searchPatternModified() {
        String pattern;
        this.cancelSearch();
        final EnumSet<SearchCriteria> criteria = EnumSet.noneOf(SearchCriteria.class);
        if (this.m_byFullName.getSelection()) {
            criteria.add(SearchCriteria.FULL_NAME);
        }
        if (this.m_autoMatchTrailingCharacters.getSelection()) {
            criteria.add(SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS);
        }
        if (this.m_ignoreCase.getSelection()) {
            criteria.add(SearchCriteria.IGNORE_CASE);
        }
        if (this.m_provider.isSearchPatternValid(pattern = this.m_searchPattern.getText(), criteria)) {
            final SearchCommand command = new SearchCommand(this.m_systemProvider, new SearchCommand.ISearchInteraction(){

                public boolean collect(SearchCommand.SearchData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setRepresentation(MoveElementsDialog.this.m_representation);
                    data.setPattern(pattern);
                    data.setSearchCriteria(criteria);
                    data.setInclude((Predicate)MoveElementsDialog.this);
                    return true;
                }
            });
            assert (command.isEnabled().isSuccess()) : "Not enabled: " + String.valueOf(command);
            this.m_currentWorkerContext = new CancellableWorkerContext();
            this.m_currentCommand = command;
            UserInterfaceAdapter.getInstance().run((Command)command, (IWorkerContext)this.m_currentWorkerContext, new CommandResultConsumer(){

                public void consume(CommandException exception) {
                    super.consume(exception);
                    if (MoveElementsDialog.this.m_currentCommand == command && exception == null && MoveElementsDialog.this.m_targetViewer != null && !MoveElementsDialog.this.m_targetViewer.getTree().isDisposed()) {
                        List matched = command.getMatching();
                        LOGGER.debug("Process " + matched.size() + " matched element(s)");
                        MoveElementsDialog.this.m_includeExplicitely.clear();
                        Iterator iterator = matched.iterator();
                        while (iterator.hasNext()) {
                            ArchitecturalViewNode nextMatched;
                            ArchitecturalViewNode nextCurrent = nextMatched = (ArchitecturalViewNode)iterator.next();
                            while (nextCurrent != null) {
                                if (MoveElementsDialog.this.m_includeExplicitely.add(nextCurrent)) {
                                    if (!((nextCurrent = (ArchitecturalViewNode)nextCurrent.getParent(ArchitecturalViewNode.class, ParentMode.ONLY_DIRECT_PARENT)) instanceof ArtifactNode)) continue;
                                    nextCurrent = null;
                                    continue;
                                }
                                nextCurrent = null;
                            }
                        }
                        MoveElementsDialog.this.m_targetViewer.getTree().setRedraw(false);
                        MoveElementsDialog.this.m_targetViewer.refresh();
                        MoveElementsDialog.this.m_targetViewer.getTree().setRedraw(true);
                        LOGGER.debug("Process " + matched.size() + " matched element(s) - done");
                    }
                }
            });
        } else {
            LOGGER.debug("Clear explicitely included");
            this.m_includeExplicitely.clear();
            this.m_targetViewer.refresh();
        }
    }

    private void searchCriteriaChanged() {
        String pattern = this.m_searchPattern.getText();
        if (pattern != null && pattern.length() > 0) {
            this.m_searchPattern.setText(pattern);
        }
    }

    protected final void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite toBeMovedArea = new Composite((Composite)sashForm, 0);
        toBeMovedArea.setLayout((Layout)LayoutCreator.createCompositeGridLayout(1));
        if (this.m_partialAlternativeInfo != null) {
            this.m_partialAlternativeInfoComposite = new PartialAlternativeInfoComposite(toBeMovedArea, this.m_partialAlternativeInfo, new PartialAlternativeInfoComposite.IConsumer(){

                @Override
                public void modified() {
                    MoveElementsDialog.this.elementsToBeMovedChanged(false);
                }
            });
            this.m_partialAlternativeInfoComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        }
        this.m_toBeMoved = new PropertyTableViewer(toBeMovedArea, (BeanPropertyReader.BeanAdapter)new ArchitecturalViewElementBeanAadpter(), PropertyTableViewer.SelectionType.SINGLE_COLUMN);
        this.m_toBeMoved.addColumn("To Be Moved", "name", null, "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_toBeMoved.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite targetArea = new Composite((Composite)sashForm, 0);
        targetArea.setLayout((Layout)LayoutCreator.createCompositeGridLayout(3));
        Label targetPositionLabel = new Label(targetArea, 0);
        targetPositionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        targetPositionLabel.setText("Move to position:");
        targetPositionLabel.setToolTipText("Determines the position relative to the selected target of the move operation.");
        this.m_targetPositionComposite = new Composite(targetArea, 0);
        this.m_targetPositionComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        this.m_targetPositionComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        TargetPosition[] targetPositionArray = TargetPosition.values();
        int n = targetPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TargetPosition next = targetPositionArray[n2];
            Button nextButton = new Button(this.m_targetPositionComposite, 16);
            nextButton.setText(next.getPresentationName());
            nextButton.setData((Object)next);
            nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MoveElementsDialog.this.m_targetPosition = next;
                    MoveElementsDialog.this.updateTargetInfo();
                }
            });
            nextButton.setSelection(this.m_targetPosition.equals((Object)next));
            ++n2;
        }
        Label criteriaLabel = new Label(targetArea, 0);
        criteriaLabel.setText("Non-artifact-targets search criteria:");
        criteriaLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite searchCriteriaRadioButtonsGroup = new Composite(targetArea, 0);
        searchCriteriaRadioButtonsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        searchCriteriaRadioButtonsGroup.setLayout((Layout)LayoutCreator.createCompositeGridLayout(5, 0));
        this.m_byName = new Button(searchCriteriaRadioButtonsGroup, 16);
        this.m_byName.setText("Name");
        this.m_byName.setSelection(true);
        this.m_byName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.searchCriteriaChanged();
            }
        });
        this.m_byFullName = new Button(searchCriteriaRadioButtonsGroup, 16);
        this.m_byFullName.setText("Full name");
        this.m_byFullName.setSelection(false);
        this.m_byFullName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.searchCriteriaChanged();
            }
        });
        new Label(searchCriteriaRadioButtonsGroup, 0).setText("| ");
        this.m_autoMatchTrailingCharacters = new Button(searchCriteriaRadioButtonsGroup, 32);
        this.m_autoMatchTrailingCharacters.setText("Auto match trailing characters");
        this.m_autoMatchTrailingCharacters.setSelection(true);
        this.m_autoMatchTrailingCharacters.setToolTipText("If enabled every pattern is automatically appended with ** to match names starting with the specified pattern");
        this.m_autoMatchTrailingCharacters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.searchCriteriaChanged();
            }
        });
        this.m_ignoreCase = new Button(searchCriteriaRadioButtonsGroup, 32);
        this.m_ignoreCase.setText("Ignore case");
        this.m_ignoreCase.setSelection(true);
        this.m_ignoreCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.searchCriteriaChanged();
            }
        });
        Label searchPatternLabel = new Label(targetArea, 0);
        searchPatternLabel.setText("Non-artifact-targets search pattern:");
        searchPatternLabel.setToolTipText("Wildcards: ?=any character, *=any sequence between dots or slashes, **=any sequence");
        searchPatternLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_searchPattern = new Text(targetArea, 2048);
        this.m_searchPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_searchPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MoveElementsDialog.this.searchPatternModified();
            }
        });
        this.m_searchPattern.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                MoveElementsDialog.this.cancelSearch();
            }
        });
        ToolBar toolBar = new ToolBar(targetArea, 0x800000);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        ToolItem collapseAll = new ToolItem(toolBar, 8);
        collapseAll.setImage(UiResourceManager.getInstance().getImage("CollapseAll"));
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.m_targetViewer.collapseAll();
            }
        });
        ToolItem expandAll = new ToolItem(toolBar, 8);
        expandAll.setImage(UiResourceManager.getInstance().getImage("ExpandAll"));
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MoveElementsDialog.this.m_targetViewer.expandAll();
            }
        });
        this.m_targetViewer = new TreeViewer(targetArea, 4);
        this.m_targetViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        ContentAndLabelProvider contentAndLabelProvider = new ContentAndLabelProvider();
        this.m_targetViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.m_targetViewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.m_targetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                Object selected = event.getStructuredSelection().getFirstElement();
                if (selected != null) {
                    if (!$assertionsDisabled && !(selected instanceof ArchitecturalViewElement)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(selected)));
                    }
                    MoveElementsDialog.this.m_selected = (ArchitecturalViewElement)selected;
                } else {
                    MoveElementsDialog.this.m_selected = null;
                }
                MoveElementsDialog.this.updateTargetInfo();
            }
        });
        this.m_targetValidityInfo = new Text((Composite)sashForm, 64);
        this.m_targetValidityInfo.setText("No target selected.");
        this.m_targetValidityInfo.setEditable(false);
        sashForm.setWeights(new int[]{15, 80, 5});
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        this.elementsToBeMovedChanged(true);
        this.m_toBeMoved.showData(this.getElements());
        this.m_targetViewer.setInput((Object)this.m_representation);
        this.m_targetViewer.expandToLevel(2);
    }

    List<? extends ArchitecturalViewNode> getElements() {
        List<ArchitecturalViewNode> alternative;
        if (this.m_partialAlternativeInfoComposite != null && (alternative = this.m_partialAlternativeInfoComposite.getAlternativeElements()) != null) {
            return alternative;
        }
        return new ArrayList<ArchitecturalViewNode>(this.m_elements);
    }

    MovableTargetInfo getMovableTargetInfo() {
        return this.m_targetInfo;
    }

    static final class ArchitecturalViewElementBeanAadpter
    extends BeanPropertyReader.BeanAdapter<ArchitecturalViewElement> {
        private ArchitecturalViewElement m_element;

        ArchitecturalViewElementBeanAadpter() {
        }

        protected void setAdaptedObject(ArchitecturalViewElement adaptedObject) {
            this.m_element = adaptedObject;
        }

        public String getName() {
            return this.m_element.getPresentationName(false);
        }

        public Image getImage() {
            return UiResourceManager.getInstance().getImage((Element)this.m_element);
        }
    }

    final class ContentAndLabelProvider
    extends ArchitecturalViewTreeContentAndLabelProvider
    implements Predicate<ArchitecturalViewElement> {
        ContentAndLabelProvider() {
        }

        public Object[] getElements(Object parent) {
            assert (parent != null && parent instanceof ExplorationViewRepresentation) : "Unexpected class in method 'getElements': " + String.valueOf(parent);
            return ((ExplorationViewRepresentation)parent).getAllNodeChildren((Predicate)this, true).toArray();
        }

        public Object getParent(Object child) {
            assert (child instanceof ArchitecturalViewElement) : "Unexpected class in method 'getChildren': " + String.valueOf(child);
            return ((ArchitecturalViewElement)child).getParent(ArchitecturalViewElement.class, ParentMode.ONLY_DIRECT_PARENT);
        }

        public boolean hasChildren(Object parent) {
            assert (parent instanceof ArchitecturalViewNode) : "Unexpected class in method 'hasChildren': " + String.valueOf(parent);
            return !((ArchitecturalViewNode)parent).getAllNodeChildren((Predicate)this, false).isEmpty();
        }

        public Object[] getChildren(Object parent) {
            assert (parent instanceof ArchitecturalViewNode) : "Unexpected class in method 'hasChildren': " + String.valueOf(parent);
            return ((ArchitecturalViewNode)parent).getAllNodeChildren((Predicate)this, true).toArray();
        }

        public String getText(Object element) {
            assert (element != null && element instanceof ArchitecturalViewNode) : "Unexpected class in method 'getText': " + String.valueOf(element);
            return ((ArchitecturalViewNode)element).getRawPresentationName(true);
        }

        @Override
        public boolean test(ArchitecturalViewElement element) {
            assert (element != null && element instanceof ArchitecturalViewNode) : "Unexpected class in method 'test': " + String.valueOf(element);
            return !element.isDeleted() && !MoveElementsDialog.this.m_invalidTargets.contains(element) && (element instanceof ArtifactNode || MoveElementsDialog.this.m_includeExplicitely.contains(element));
        }
    }

    static enum TargetPosition implements IStandardEnumeration
    {
        BEFORE_TARGET,
        AS_CHILD_OF_TARGET,
        AFTER_TARGET;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

