/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ExplorationViewDialog;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LayoutCreator;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.PartialAlternativeInfoComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

abstract class FocusPropertiesDialog
extends ExplorationViewDialog {
    private final List<Button> m_focusTypeButtons = new ArrayList<Button>(ExplorationViewFocusProperties.FocusType.values().length);
    private final List<Button> m_nodeInclusionModeButtons = new ArrayList<Button>(ExplorationViewFocusProperties.NodeInclusionMode.values().length);
    private final List<Button> m_dependencyInclusionModeButtons = new ArrayList<Button>(ExplorationViewFocusProperties.NodeInclusionMode.values().length);
    private final List<Button> m_parserDependencyTypeButtons = new ArrayList<Button>();
    private final ExplorationViewFocusProperties m_focusProperties;
    private PartialAlternativeInfoComposite m_partialAlternativeInfoComposite;

    FocusPropertiesDialog(Shell shell, String title, ExplorationViewFocusProperties focusProperties) {
        super(shell, title);
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'FocusPropertiesDialog' must not be empty";
        assert (focusProperties != null) : "Parameter 'focusProperties' of method 'FocusPropertiesDialog' must not be null";
        this.m_focusProperties = focusProperties;
    }

    protected final ExplorationViewFocusProperties getFocusProperties() {
        return this.m_focusProperties;
    }

    private void updateParserDependencyTypes() {
        Set parserDependencyTypes = this.m_focusProperties.getParserDependencyTypes();
        for (Button next : this.m_parserDependencyTypeButtons) {
            next.setSelection(parserDependencyTypes.contains(next.getData()));
        }
        Button okButton = this.getButton(0);
        assert (okButton != null) : "'okButton' of method 'createButtonBar' must not be null";
        okButton.setEnabled(this.m_focusProperties.isValid());
    }

    protected void addFocusTypesWidgets(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addFocusTypesWidgets' must not be null";
        EnumSet availableFocusTypes = this.m_focusProperties.getAvailableFocusTypes();
        if (!availableFocusTypes.isEmpty()) {
            Group group = new Group(composite, 32);
            group.setText("Focus Type");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createGroupLayout(1));
            for (final ExplorationViewFocusProperties.FocusType next : availableFocusTypes) {
                Button nextButton = new Button((Composite)group, 16);
                nextButton.setText(next.getPresentationName());
                nextButton.setData((Object)next);
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        FocusPropertiesDialog.this.m_focusProperties.setFocusType(next);
                    }
                });
                nextButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
                this.m_focusTypeButtons.add(nextButton);
            }
        }
    }

    protected final void enableFocus(boolean enable) {
        this.m_nodeInclusionModeButtons.forEach(b -> b.setEnabled(enable));
        this.m_parserDependencyTypeButtons.forEach(b -> b.setEnabled(enable));
    }

    protected final void fillDialogArea(Composite composite) {
        Collection parserDependencyTypes;
        List dependencyInclusionModes;
        PartialAlternativeInfo partialAlternativeInfo;
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        String info = this.m_focusProperties.getInfo();
        if (!info.isEmpty()) {
            Group group = new Group(composite, 32);
            group.setText("Info");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createCompositeGridLayout(1));
            Label label = new Label((Composite)group, 0);
            label.setText(info);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        if ((partialAlternativeInfo = this.m_focusProperties.getPartialAlternativeInfo()) != null) {
            Group group = new Group(composite, 32);
            group.setText("Child Nodes");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createCompositeGridLayout(1));
            this.m_partialAlternativeInfoComposite = new PartialAlternativeInfoComposite((Composite)group, partialAlternativeInfo, new PartialAlternativeInfoComposite.IConsumer(){

                @Override
                public boolean showBasedOnLabel() {
                    return false;
                }

                @Override
                public void modified() {
                    FocusPropertiesDialog.this.m_focusProperties.usePartialAlternative(FocusPropertiesDialog.this.m_partialAlternativeInfoComposite.usePartialAlternative());
                }
            });
            this.m_focusProperties.usePartialAlternative(this.m_partialAlternativeInfoComposite.usePartialAlternative());
            this.m_partialAlternativeInfoComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        }
        this.addFocusTypesWidgets(composite);
        List nodeInclusionModes = this.m_focusProperties.getAvailableNodeInclusionModes();
        if (!nodeInclusionModes.isEmpty()) {
            Group group = new Group(composite, 32);
            group.setText("Nodes");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createGroupLayout(1));
            for (final ExplorationViewFocusProperties.NodeInclusionMode next : nodeInclusionModes) {
                Button nextButton = new Button((Composite)group, 16);
                nextButton.setText(next.getPresentationName());
                nextButton.setToolTipText(next.getDescription());
                nextButton.setData((Object)next);
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        FocusPropertiesDialog.this.m_focusProperties.setNodeInclusionMode(next);
                    }
                });
                nextButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
                this.m_nodeInclusionModeButtons.add(nextButton);
            }
        }
        if (!(dependencyInclusionModes = this.m_focusProperties.getAvailableDependencyInclusionModes()).isEmpty()) {
            Group group = new Group(composite, 32);
            group.setText("Dependencies");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)LayoutCreator.createGroupLayout(1));
            for (final ExplorationViewFocusProperties.DependencyInclusionMode next : dependencyInclusionModes) {
                Button nextButton = new Button((Composite)group, 16);
                nextButton.setText(next.getPresentationName());
                nextButton.setData((Object)next);
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        FocusPropertiesDialog.this.m_focusProperties.setDependencyInclusionMode(next);
                    }
                });
                nextButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
                this.m_dependencyInclusionModeButtons.add(nextButton);
            }
        }
        if (!(parserDependencyTypes = this.m_focusProperties.getAvailableParserDependencyTypes()).isEmpty()) {
            Group group = new Group(composite, 32);
            group.setText("Dependency Types");
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            GridLayout groupLayout = LayoutCreator.createGroupLayout(3);
            if (parserDependencyTypes.size() > 1) {
                groupLayout.marginBottom = 0;
            }
            group.setLayout((Layout)groupLayout);
            for (final IParserDependencyType next : parserDependencyTypes) {
                final Button nextButton = new Button((Composite)group, 32);
                nextButton.setText(next.getPresentationName());
                nextButton.setData((Object)next);
                nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (nextButton.getSelection()) {
                            FocusPropertiesDialog.this.m_focusProperties.addToParserDependencyTypes(next);
                        } else {
                            FocusPropertiesDialog.this.m_focusProperties.removeFromParserDependencyTypes(next);
                        }
                        FocusPropertiesDialog.this.updateParserDependencyTypes();
                    }
                });
                this.m_parserDependencyTypeButtons.add(nextButton);
                nextButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 3, 1));
            }
            if (parserDependencyTypes.size() > 1) {
                Button selectAll = new Button((Composite)group, 8);
                selectAll.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 2, 1));
                selectAll.setText("All");
                selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        FocusPropertiesDialog.this.m_focusProperties.addAllParserDependencyTypes();
                        FocusPropertiesDialog.this.updateParserDependencyTypes();
                    }
                });
                Button deselectAll = new Button((Composite)group, 8);
                deselectAll.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                deselectAll.setText("None");
                deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        FocusPropertiesDialog.this.m_focusProperties.removeAllParserDependencyTypes();
                        FocusPropertiesDialog.this.updateParserDependencyTypes();
                    }
                });
            }
        }
    }

    protected final Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        assert (okButton != null) : "'okButton' of method 'createButtonBar' must not be null";
        okButton.setEnabled(this.m_focusProperties.isValid());
        return control;
    }

    protected void applyData() {
        ExplorationViewFocusProperties.NodeInclusionMode mode;
        String standardName;
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        if (!this.m_focusTypeButtons.isEmpty()) {
            EnumSet availableFocusTypes = this.m_focusProperties.getAvailableFocusTypes();
            assert (availableFocusTypes != null && !availableFocusTypes.isEmpty()) : "'availableFocusTypes' of method 'applyData' must not be empty";
            ExplorationViewFocusProperties.FocusType firstAvailable = (ExplorationViewFocusProperties.FocusType)availableFocusTypes.iterator().next();
            String standardName2 = preferences.get(ExplorationViewFocusProperties.FocusType.class.getSimpleName(), firstAvailable.getStandardName());
            ExplorationViewFocusProperties.FocusType focusType = null;
            try {
                focusType = ExplorationViewFocusProperties.FocusType.fromStandardName((String)standardName2);
            }
            catch (IllegalArgumentException e) {
                focusType = firstAvailable;
            }
            ExplorationViewFocusProperties.FocusType focusTypeUsed = null;
            for (Button next : this.m_focusTypeButtons) {
                if (next.getData() != focusType) continue;
                next.setSelection(true);
                focusTypeUsed = focusType;
                break;
            }
            if (focusTypeUsed == null) {
                Button buttonToUse = this.m_focusTypeButtons.get(0);
                focusTypeUsed = (ExplorationViewFocusProperties.FocusType)buttonToUse.getData();
                buttonToUse.setSelection(true);
            }
            this.m_focusProperties.setFocusType(focusTypeUsed);
        }
        if (!this.m_nodeInclusionModeButtons.isEmpty()) {
            standardName = preferences.get(ExplorationViewFocusProperties.NodeInclusionMode.class.getSimpleName(), ExplorationViewFocusProperties.NodeInclusionMode.NO_ADDITONAL_NODES.getStandardName());
            mode = null;
            try {
                mode = ExplorationViewFocusProperties.NodeInclusionMode.fromStandardName((String)standardName);
            }
            catch (IllegalArgumentException e) {
                mode = ExplorationViewFocusProperties.NodeInclusionMode.NODES_IN_AND_OUT;
            }
            ExplorationViewFocusProperties.NodeInclusionMode nodeDependencyKindUsed = null;
            for (Button next : this.m_nodeInclusionModeButtons) {
                if (next.getData() != mode) continue;
                next.setSelection(true);
                nodeDependencyKindUsed = mode;
                break;
            }
            if (nodeDependencyKindUsed == null) {
                nodeDependencyKindUsed = (ExplorationViewFocusProperties.NodeInclusionMode)this.m_nodeInclusionModeButtons.get(0).getData();
            }
            this.m_focusProperties.setNodeInclusionMode(nodeDependencyKindUsed);
        }
        if (!this.m_dependencyInclusionModeButtons.isEmpty()) {
            standardName = preferences.get(ExplorationViewFocusProperties.DependencyInclusionMode.class.getSimpleName(), ExplorationViewFocusProperties.DependencyInclusionMode.ALL_DEPENDENCIES.getStandardName());
            mode = null;
            try {
                mode = ExplorationViewFocusProperties.DependencyInclusionMode.fromStandardName((String)standardName);
            }
            catch (IllegalArgumentException e) {
                mode = ExplorationViewFocusProperties.DependencyInclusionMode.ALL_DEPENDENCIES;
            }
            ExplorationViewFocusProperties.DependencyInclusionMode modeUsed = null;
            for (Button next : this.m_dependencyInclusionModeButtons) {
                if (next.getData() != mode) continue;
                modeUsed = mode;
                next.setSelection(true);
                break;
            }
            if (modeUsed == null) {
                modeUsed = (ExplorationViewFocusProperties.DependencyInclusionMode)this.m_dependencyInclusionModeButtons.get(0).getData();
            }
            this.m_focusProperties.setDependencyInclusionMode(modeUsed);
        }
        if (!this.m_parserDependencyTypeButtons.isEmpty()) {
            for (IParserDependencyType next : this.m_focusProperties.getAvailableParserDependencyTypes()) {
                if (preferences.getBoolean(next.getStandardName(), true)) {
                    this.m_focusProperties.addToParserDependencyTypes(next);
                    continue;
                }
                this.m_focusProperties.removeFromParserDependencyTypes(next);
            }
            this.updateParserDependencyTypes();
        }
    }

    protected IEclipsePreferences saveData() {
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.standalone");
        ExplorationViewFocusProperties.FocusType focusType = this.m_focusProperties.getFocusType();
        preferences.put(ExplorationViewFocusProperties.FocusType.class.getSimpleName(), focusType.getStandardName());
        ExplorationViewFocusProperties.NodeInclusionMode nodeInclusionMode = this.m_focusProperties.getNodeInclusionMode();
        preferences.put(ExplorationViewFocusProperties.NodeInclusionMode.class.getSimpleName(), nodeInclusionMode.getStandardName());
        ExplorationViewFocusProperties.DependencyInclusionMode dependencyInclusionMode = this.m_focusProperties.getDependencyInclusionMode();
        preferences.put(ExplorationViewFocusProperties.DependencyInclusionMode.class.getSimpleName(), dependencyInclusionMode.getStandardName());
        for (IParserDependencyType next : this.m_focusProperties.getAvailableParserDependencyTypes()) {
            preferences.putBoolean(next.getStandardName(), this.m_focusProperties.getParserDependencyTypes().contains(next));
        }
        return preferences;
    }
}

